/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.buttons;

import java.util.function.Consumer;
import java.util.function.Supplier;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIClickable;
import mchorse.bbs_mod.ui.utils.icons.Icon;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIIcon
extends UIClickable<UIIcon> {
    private Icon icon;
    private Supplier<Icon> iconSupplier;
    public int iconColor = -1;
    public int hoverColor = -3355444;
    public int activeColor = -3355444;
    public int disabledColor = -2143272896;
    private boolean active;

    public UIIcon(Icon icon, Consumer<UIIcon> callback) {
        super(callback);
        this.icon = icon;
        this.wh(20, 20);
    }

    public UIIcon(Supplier<Icon> iconSupplier, Consumer<UIIcon> callback) {
        super(callback);
        this.iconSupplier = iconSupplier;
        this.wh(20, 20);
    }

    public Icon getIcon() {
        Icon icon;
        if (this.iconSupplier != null && (icon = this.iconSupplier.get()) != null) {
            return icon;
        }
        return this.icon;
    }

    public UIIcon both(Icon icon) {
        this.icon = icon;
        return this;
    }

    public UIIcon both(Supplier<Icon> icon) {
        this.iconSupplier = icon;
        return this;
    }

    public UIIcon iconColor(int color) {
        this.iconColor = color;
        return this;
    }

    public UIIcon hoverColor(int color) {
        this.hoverColor = color;
        return this;
    }

    public UIIcon disabledColor(int color) {
        this.disabledColor = color;
        return this;
    }

    public UIIcon activeColor(int color) {
        this.activeColor = color;
        return this;
    }

    public UIIcon active(boolean active) {
        this.active = active;
        return this;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    protected UIIcon get() {
        return this;
    }

    @Override
    protected void renderSkin(UIContext context) {
        Icon icon = this.getIcon();
        int color = this.isEnabled() ? (this.active ? this.activeColor : (this.hover ? this.hoverColor : this.iconColor)) : this.disabledColor;
        context.batcher.icon(icon, color, this.area.mx(), this.area.my(), 0.5f, 0.5f);
    }
}

