/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories;

import java.io.InputStream;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.forms.FormUtils;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.forms.forms.StructureForm;
import mchorse.bbs_mod.forms.forms.utils.PivotSettings;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIButton;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIIcon;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIToggle;
import mchorse.bbs_mod.ui.framework.elements.input.UITrackpad;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframeSheet;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframes;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIKeyframeFactory;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.keyframes.Keyframe;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;

@Environment(value=EnvType.CLIENT)
public class UIPivotSettingsKeyframeFactory
extends UIKeyframeFactory<PivotSettings> {
    private UIToggle auto;
    private UITrackpad x;
    private UITrackpad y;
    private UITrackpad z;
    private UIButton calcCenter;

    public UIPivotSettingsKeyframeFactory(Keyframe<PivotSettings> keyframe, UIKeyframes editor) {
        super(keyframe, editor);
        PivotSettings value = keyframe.getValue();
        this.auto = new UIToggle(IKey.EMPTY, value.auto, t -> this.setValue(this.buildValue()));
        this.x = new UITrackpad(v -> this.setValue(this.buildValue())).block().onlyNumbers().limit(-1024.0, 1024.0);
        this.y = new UITrackpad(v -> this.setValue(this.buildValue())).block().onlyNumbers().limit(-1024.0, 1024.0);
        this.z = new UITrackpad(v -> this.setValue(this.buildValue())).block().onlyNumbers().limit(-1024.0, 1024.0);
        this.x.setValue(value.pivot.x);
        this.y.setValue(value.pivot.y);
        this.z.setValue(value.pivot.z);
        this.x.textbox.setColor(0xFF3333);
        this.y.textbox.setColor(0x33FF33);
        this.z.textbox.setColor(0x3366FF);
        UIIcon pivotIcon = new UIIcon(Icons.SPHERE, null);
        pivotIcon.setEnabled(false);
        this.calcCenter = new UIButton(UIKeys.FORMS_EDITORS_STRUCTURE_CALCULATE_CENTER, b -> this.calculateCenterAndApply());
        this.scroll.add((IUIElement)UI.label(UIKeys.TRANSFORMS_PIVOT_TITLE).marginTop(10));
        this.scroll.add((IUIElement)this.auto);
        this.scroll.add((IUIElement)UI.row(pivotIcon, this.x, this.y, this.z));
        this.scroll.add((IUIElement)this.calcCenter);
    }

    private PivotSettings buildValue() {
        PivotSettings s = new PivotSettings();
        s.auto = this.auto.getValue();
        s.pivot.set((float)this.x.getValue(), (float)this.y.getValue(), (float)this.z.getValue(), 0.0f);
        return s;
    }

    private void calculateCenterAndApply() {
        UIKeyframeSheet sheet = this.editor.getGraph().getSheet(this.keyframe);
        if (sheet == null) {
            return;
        }
        Form form = FormUtils.getForm(sheet.property);
        if (!(form instanceof StructureForm)) {
            return;
        }
        StructureForm form2 = (StructureForm)form;
        String path = (String)form2.structureFile.get();
        if (path == null || path.isEmpty()) {
            return;
        }
        try (InputStream is = BBSMod.getProvider().getAsset(Link.assets(path));){
            class_2487 root = class_2507.method_10629((InputStream)is);
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            if (root.method_10573("blocks", 9)) {
                class_2499 list = root.method_10554("blocks", 10);
                for (int i = 0; i < list.size(); ++i) {
                    class_2487 be = list.method_10602(i);
                    class_2499 pos = be.method_10554("pos", 3);
                    if (pos == null || pos.size() < 3) continue;
                    int x = pos.method_10600(0);
                    int y = pos.method_10600(1);
                    int z = pos.method_10600(2);
                    if (x < minX) {
                        minX = x;
                    }
                    if (y < minY) {
                        minY = y;
                    }
                    if (z < minZ) {
                        minZ = z;
                    }
                    if (x > maxX) {
                        maxX = x;
                    }
                    if (y > maxY) {
                        maxY = y;
                    }
                    if (z <= maxZ) continue;
                    maxZ = z;
                }
            }
            if (minX != Integer.MAX_VALUE) {
                float cx = (float)(minX + maxX) / 2.0f;
                float cy = (float)(minY + maxY) / 2.0f;
                float cz = (float)(minZ + maxZ) / 2.0f;
                int widthX = maxX - minX + 1;
                int widthY = maxY - minY + 1;
                int widthZ = maxZ - minZ + 1;
                float parityX = widthX % 2 == 1 ? -0.5f : 0.0f;
                float parityY = widthY % 2 == 1 ? -0.5f : 0.0f;
                float parityZ = widthZ % 2 == 1 ? -0.5f : 0.0f;
                this.auto.setValue(false);
                this.x.setValue(cx - parityX);
                this.y.setValue(cy - parityY);
                this.z.setValue(cz - parityZ);
                this.setValue(this.buildValue());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

