/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.cubic.ModelInstance;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.forms.FormUtils;
import mchorse.bbs_mod.forms.FormUtilsClient;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.forms.forms.MobForm;
import mchorse.bbs_mod.forms.forms.ModelForm;
import mchorse.bbs_mod.forms.renderers.ModelFormRenderer;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.film.UIFilmPanel;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIButton;
import mchorse.bbs_mod.ui.framework.elements.input.UIPropTransform;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframeSheet;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframes;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIKeyframeFactory;
import mchorse.bbs_mod.ui.framework.elements.input.list.UIList;
import mchorse.bbs_mod.ui.framework.elements.input.list.UISearchList;
import mchorse.bbs_mod.ui.framework.elements.input.list.UIStringList;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIConfirmOverlayPanel;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlay;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlayPanel;
import mchorse.bbs_mod.ui.framework.elements.utils.UILabel;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.pose.UIPoseEditor;
import mchorse.bbs_mod.utils.Axis;
import mchorse.bbs_mod.utils.CollectionUtils;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.joml.Vectors;
import mchorse.bbs_mod.utils.keyframes.Keyframe;
import mchorse.bbs_mod.utils.pose.Pose;
import mchorse.bbs_mod.utils.pose.PoseTransform;
import mchorse.bbs_mod.utils.pose.Transform;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Vector3d;
import org.joml.Vector3dc;

@Environment(value=EnvType.CLIENT)
public class UIPoseKeyframeFactory
extends UIKeyframeFactory<Pose> {
    public UIPoseFactoryEditor poseEditor;

    public UIPoseKeyframeFactory(Keyframe<Pose> keyframe, UIKeyframes editor) {
        super(keyframe, editor);
        this.poseEditor = new UIPoseFactoryEditor(editor, keyframe);
        UIKeyframeSheet sheet = editor.getGraph().getSheet(keyframe);
        Form form = FormUtils.getForm(sheet.property);
        if (form instanceof ModelForm) {
            ModelForm modelForm = (ModelForm)form;
            model = ((ModelFormRenderer)FormUtilsClient.getRenderer(modelForm)).getModel();
            this.poseEditor.setDefaultTextureSupplier(() -> {
                Link base = (Link)modelForm.texture.get();
                if (base != null) {
                    return base;
                }
                ModelInstance m = ((ModelFormRenderer)FormUtilsClient.getRenderer(modelForm)).getModel();
                return m != null ? m.texture : null;
            });
            if (model != null) {
                this.poseEditor.setPose(keyframe.getValue(), ((ModelInstance)model).poseGroup);
                this.poseEditor.fillGroups(((ModelInstance)model).model, ((ModelInstance)model).flippedParts, false);
                if (((Boolean)BBSSettings.boneAnchoringEnabled.get()).booleanValue() && sheet != null && sheet.anchoredBone != null) {
                    this.poseEditor.selectBone(sheet.anchoredBone);
                }
            }
        } else {
            model = FormUtils.getForm(sheet.property);
            if (model instanceof MobForm) {
                MobForm mobForm = (MobForm)model;
                List<String> bones = FormUtilsClient.getRenderer(mobForm).getBones();
                this.poseEditor.setPose(keyframe.getValue(), "");
                this.poseEditor.fillGroups(bones, false);
                if (((Boolean)BBSSettings.boneAnchoringEnabled.get()).booleanValue() && sheet != null && sheet.anchoredBone != null) {
                    this.poseEditor.selectBone(sheet.anchoredBone);
                }
            }
        }
        this.scroll.add((IUIElement)this.poseEditor);
    }

    @Override
    public void resize() {
        boolean categoriesEnabled;
        this.poseEditor.removeAll();
        UIKeyframeSheet sheet = this.editor.getGraph().getSheet(this.keyframe);
        boolean anchoringEnabled = (Boolean)BBSSettings.boneAnchoringEnabled.get();
        boolean isAnchored = anchoringEnabled && sheet != null && sheet.anchoredBone != null;
        boolean bl = categoriesEnabled = BBSSettings.modelBlockCategoriesPanelEnabled != null && (Boolean)BBSSettings.modelBlockCategoriesPanelEnabled.get() != false;
        if (isAnchored) {
            this.poseEditor.anchoredLegend.setVisible(true);
            this.poseEditor.anchoredLegend.label = IKey.constant("Hueso anclado: " + sheet.anchoredBone);
            this.poseEditor.selectBone(sheet.anchoredBone);
        } else {
            this.poseEditor.anchoredLegend.setVisible(false);
            if (!anchoringEnabled) {
                this.poseEditor.anchorBone.setVisible(false);
                this.poseEditor.unanchorBone.setVisible(false);
            } else {
                this.poseEditor.anchorBone.setVisible(true);
                this.poseEditor.unanchorBone.setVisible(true);
            }
        }
        if (this.getFlex().getW() > 240) {
            UIElement right;
            UIElement left = UI.column(UI.label(UIKeys.POSE_CONTEXT_FIX), this.poseEditor.fix, UI.row(this.poseEditor.color, this.poseEditor.lighting), this.poseEditor.transform);
            if (isAnchored) {
                this.poseEditor.pickTexture.w(1.0f);
                right = UI.column(UI.label(UIKeys.FORMS_EDITOR_BONE), this.poseEditor.anchoredLegend, this.poseEditor.pickTexture, this.poseEditor.unanchorBone);
            } else {
                this.poseEditor.pickTexture.w(1.0f);
                UIElement groupsRow = categoriesEnabled ? UI.row(this.poseEditor.groups, this.poseEditor.categories) : UI.row(this.poseEditor.groups);
                right = anchoringEnabled ? UI.column(UI.label(UIKeys.FORMS_EDITOR_BONE), groupsRow, this.poseEditor.pickTexture, this.poseEditor.anchorBone) : UI.column(UI.label(UIKeys.FORMS_EDITOR_BONE), groupsRow, this.poseEditor.pickTexture);
            }
            this.poseEditor.add((IUIElement)UI.row(left, right));
        } else if (isAnchored) {
            this.poseEditor.add(UI.label(UIKeys.FORMS_EDITOR_BONE), this.poseEditor.anchoredLegend, this.poseEditor.pickTexture, this.poseEditor.unanchorBone, UI.label(UIKeys.POSE_CONTEXT_FIX), this.poseEditor.fix, UI.row(this.poseEditor.color, this.poseEditor.lighting), this.poseEditor.transform);
        } else {
            UIElement groupsRow;
            UIElement uIElement = groupsRow = categoriesEnabled ? UI.row(this.poseEditor.groups, this.poseEditor.categories) : UI.row(this.poseEditor.groups);
            if (anchoringEnabled) {
                this.poseEditor.add(UI.label(UIKeys.FORMS_EDITOR_BONE), groupsRow, this.poseEditor.pickTexture, this.poseEditor.anchorBone, UI.label(UIKeys.POSE_CONTEXT_FIX), this.poseEditor.fix, UI.row(this.poseEditor.color, this.poseEditor.lighting), this.poseEditor.transform);
            } else {
                this.poseEditor.add(UI.label(UIKeys.FORMS_EDITOR_BONE), groupsRow, this.poseEditor.pickTexture, UI.label(UIKeys.POSE_CONTEXT_FIX), this.poseEditor.fix, UI.row(this.poseEditor.color, this.poseEditor.lighting), this.poseEditor.transform);
            }
        }
        for (UIElement child : this.scroll.getChildren(UIElement.class)) {
            child.noCulling();
        }
        super.resize();
    }

    @Environment(value=EnvType.CLIENT)
    public static class UIPoseFactoryEditor
    extends UIPoseEditor {
        private UIKeyframes editor;
        private Keyframe<Pose> keyframe;
        public UIButton anchorBone;
        public UIButton unanchorBone;
        public UILabel anchoredLegend;

        public static void apply(UIKeyframes editor, Keyframe keyframe, Consumer<Pose> consumer) {
            for (UIKeyframeSheet sheet : editor.getGraph().getSheets()) {
                if (sheet.channel.getFactory() != keyframe.getFactory()) continue;
                for (Keyframe kf : sheet.selection.getSelected()) {
                    Object t = kf.getValue();
                    if (!(t instanceof Pose)) continue;
                    Pose pose = (Pose)t;
                    kf.preNotify();
                    consumer.accept(pose);
                    kf.postNotify();
                }
            }
        }

        public static void apply(UIKeyframes editor, Keyframe keyframe, String group, Consumer<PoseTransform> consumer) {
            UIPoseFactoryEditor.apply(editor, keyframe, pose -> consumer.accept(pose.get(group)));
        }

        public UIPoseFactoryEditor(UIKeyframes editor, Keyframe<Pose> keyframe) {
            this.editor = editor;
            this.keyframe = keyframe;
            ((UIPoseTransforms)this.transform).setKeyframe(this);
            this.anchoredLegend = UI.label(IKey.constant("Hueso anclado: -"));
            this.anchoredLegend.h(20);
            this.anchoredLegend.setVisible(false);
            this.anchorBone = new UIButton(UIKeys.POSE_TRACKS_ANCHOR_SELECT_BONE, b -> {
                if (!((Boolean)BBSSettings.boneAnchoringEnabled.get()).booleanValue()) {
                    return;
                }
                UIKeyframeSheet sheet = this.editor.getGraph().getSheet(this.keyframe);
                if (sheet == null) {
                    return;
                }
                List bones = this.groups.getList();
                UISearchList<String> search = new UISearchList<String>(new UIStringList(null));
                UIList<String> list = search.list;
                UIConfirmOverlayPanel panel = new UIConfirmOverlayPanel(UIKeys.POSE_TRACKS_ANCHOR_SELECT_BONE_TITLE, UIKeys.POSE_TRACKS_ANCHOR_SELECT_BONE_DESCRIPTION, confirm -> {
                    int index;
                    String bone;
                    if (confirm.booleanValue() && (bone = (String)CollectionUtils.getSafe(bones, index = list.getIndex())) != null) {
                        UIFilmPanel filmPanel;
                        sheet.anchoredBone = bone;
                        this.selectBone(bone);
                        this.anchoredLegend.setVisible(true);
                        this.anchoredLegend.label = IKey.constant("Hueso anclado: " + bone);
                        UIPoseKeyframeFactory factory = this.getParent(UIPoseKeyframeFactory.class);
                        if (factory != null) {
                            factory.resize();
                        }
                        if ((filmPanel = this.getParent(UIFilmPanel.class)) != null && filmPanel.replayEditor != null && filmPanel.replayEditor.getReplay() != null) {
                            filmPanel.replayEditor.getReplay().setCustomSheetTitle(sheet.id, bone);
                        }
                    }
                });
                for (String g : bones) {
                    list.add(g);
                }
                String current = sheet.anchoredBone != null ? sheet.anchoredBone : (String)this.groups.getCurrentFirst();
                int idx = bones.indexOf(current);
                list.setIndex(Math.max(idx, 0));
                list.background();
                search.relative(panel.confirm).y(-5).w(1.0f).h(164).anchor(0.0f, 1.0f);
                panel.confirm.w(1.0f, -10);
                panel.content.add((IUIElement)search);
                UIOverlay.addOverlay(this.getContext(), (UIOverlayPanel)panel, 240, 300);
            });
            this.unanchorBone = new UIButton(UIKeys.POSE_TRACKS_ANCHOR_UNANCHOR, b -> {
                UIKeyframeSheet sheet = this.editor.getGraph().getSheet(this.keyframe);
                if (sheet != null) {
                    UIPoseKeyframeFactory factory;
                    sheet.anchoredBone = null;
                    this.anchoredLegend.setVisible(false);
                    UIFilmPanel filmPanel = this.getParent(UIFilmPanel.class);
                    if (filmPanel != null && filmPanel.replayEditor != null && filmPanel.replayEditor.getReplay() != null) {
                        filmPanel.replayEditor.getReplay().setCustomSheetTitle(sheet.id, null);
                    }
                    if ((factory = this.getParent(UIPoseKeyframeFactory.class)) != null) {
                        factory.resize();
                    }
                }
            });
            this.anchorBone.w(1.0f);
            this.unanchorBone.w(1.0f);
        }

        private String getGroup(PoseTransform transform) {
            return CollectionUtils.getKey(this.getPose().transforms, transform);
        }

        public List<String> getCategoryBones(String category) {
            if (category == null || category.isEmpty()) {
                return Collections.emptyList();
            }
            return this.boneCategories.getBones(this.getPoseGroupKey(), category);
        }

        @Override
        protected UIPropTransform createTransformEditor() {
            return new UIPoseTransforms().enableHotkeys();
        }

        @Override
        protected void pastePose(MapType data) {
            String current = (String)this.groups.getCurrentFirst();
            UIPoseFactoryEditor.apply(this.editor, this.keyframe, pose -> pose.fromData(data));
            this.pickBone(current);
        }

        @Override
        protected void flipPose() {
            String current = (String)this.groups.getCurrentFirst();
            UIPoseFactoryEditor.apply(this.editor, this.keyframe, pose -> pose.flip(this.flippedParts));
            this.pickBone(current);
        }

        @Override
        protected void setFix(PoseTransform transform, float value) {
            UIPoseFactoryEditor.apply(this.editor, this.keyframe, this.getGroup(transform), poseT -> {
                poseT.fix = value;
            });
        }

        @Override
        protected void setColor(PoseTransform transform, int value) {
            UIPoseFactoryEditor.apply(this.editor, this.keyframe, this.getGroup(transform), poseT -> poseT.color.set(value));
        }

        @Override
        protected void setLighting(PoseTransform poseTransform, boolean value) {
            UIPoseFactoryEditor.apply(this.editor, this.keyframe, this.getGroup(poseTransform), poseT -> {
                poseT.lighting = value ? 0.0f : 1.0f;
            });
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class UIPoseTransforms
    extends UIPropTransform {
        private UIPoseFactoryEditor editor;

        public void setKeyframe(UIPoseFactoryEditor editor) {
            this.editor = editor;
        }

        private List<String> targets() {
            String selectedCategory;
            boolean categoriesEnabled = BBSSettings.modelBlockCategoriesPanelEnabled != null && (Boolean)BBSSettings.modelBlockCategoriesPanelEnabled.get() != false;
            String string = selectedCategory = categoriesEnabled && this.editor.categories != null ? (String)this.editor.categories.getCurrentFirst() : null;
            if (selectedCategory == null || selectedCategory.isEmpty()) {
                return Collections.singletonList(this.editor.getGroup());
            }
            return this.editor.getCategoryBones(selectedCategory);
        }

        @Override
        protected void reset() {
            for (String key : this.targets()) {
                UIPoseFactoryEditor.apply(this.editor.editor, this.editor.keyframe, key, poseT -> {
                    poseT.translate.set(0.0f, 0.0f, 0.0f);
                    poseT.scale.set(1.0f, 1.0f, 1.0f);
                    poseT.rotate.set(0.0f, 0.0f, 0.0f);
                    poseT.rotate2.set(0.0f, 0.0f, 0.0f);
                    poseT.pivot.set(0.0f, 0.0f, 0.0f);
                });
            }
            this.refillTransform();
        }

        @Override
        public void pasteTranslation(Vector3d translation) {
            for (String key : this.targets()) {
                UIPoseFactoryEditor.apply(this.editor.editor, this.editor.keyframe, key, poseT -> poseT.translate.set((Vector3dc)translation));
            }
            this.refillTransform();
        }

        @Override
        public void pasteScale(Vector3d scale) {
            for (String key : this.targets()) {
                UIPoseFactoryEditor.apply(this.editor.editor, this.editor.keyframe, key, poseT -> poseT.scale.set((Vector3dc)scale));
            }
            this.refillTransform();
        }

        @Override
        public void pasteRotation(Vector3d rotation) {
            for (String key : this.targets()) {
                UIPoseFactoryEditor.apply(this.editor.editor, this.editor.keyframe, key, poseT -> poseT.rotate.set((Vector3dc)Vectors.toRad(rotation)));
            }
            this.refillTransform();
        }

        @Override
        public void pasteRotation2(Vector3d rotation) {
            for (String key : this.targets()) {
                UIPoseFactoryEditor.apply(this.editor.editor, this.editor.keyframe, key, poseT -> poseT.rotate2.set((Vector3dc)Vectors.toRad(rotation)));
            }
            this.refillTransform();
        }

        @Override
        public void pastePivot(Vector3d pivot) {
            for (String key : this.targets()) {
                UIPoseFactoryEditor.apply(this.editor.editor, this.editor.keyframe, key, poseT -> poseT.pivot.set((float)pivot.x, (float)pivot.y, (float)pivot.z));
            }
            this.refillTransform();
        }

        @Override
        public void setT(Axis axis, double x, double y, double z) {
            Transform transform = this.getTransform();
            float dx = (float)(x - (double)transform.translate.x);
            float dy = (float)(y - (double)transform.translate.y);
            float dz = (float)(z - (double)transform.translate.z);
            for (String key : this.targets()) {
                UIPoseFactoryEditor.apply(this.editor.editor, this.editor.keyframe, key, poseT -> {
                    poseT.translate.x += dx;
                    poseT.translate.y += dy;
                    poseT.translate.z += dz;
                });
            }
        }

        @Override
        public void setS(Axis axis, double x, double y, double z) {
            Transform transform = this.getTransform();
            float dx = (float)(x - (double)transform.scale.x);
            float dy = (float)(y - (double)transform.scale.y);
            float dz = (float)(z - (double)transform.scale.z);
            for (String key : this.targets()) {
                UIPoseFactoryEditor.apply(this.editor.editor, this.editor.keyframe, key, poseT -> {
                    poseT.scale.x += dx;
                    poseT.scale.y += dy;
                    poseT.scale.z += dz;
                });
            }
        }

        @Override
        public void setR(Axis axis, double x, double y, double z) {
            Transform transform = this.getTransform();
            float dx = MathUtils.toRad((float)x) - transform.rotate.x;
            float dy = MathUtils.toRad((float)y) - transform.rotate.y;
            float dz = MathUtils.toRad((float)z) - transform.rotate.z;
            for (String key : this.targets()) {
                UIPoseFactoryEditor.apply(this.editor.editor, this.editor.keyframe, key, poseT -> {
                    poseT.rotate.x += dx;
                    poseT.rotate.y += dy;
                    poseT.rotate.z += dz;
                });
            }
        }

        @Override
        public void setR2(Axis axis, double x, double y, double z) {
            Transform transform = this.getTransform();
            float dx = MathUtils.toRad((float)x) - transform.rotate2.x;
            float dy = MathUtils.toRad((float)y) - transform.rotate2.y;
            float dz = MathUtils.toRad((float)z) - transform.rotate2.z;
            for (String key : this.targets()) {
                UIPoseFactoryEditor.apply(this.editor.editor, this.editor.keyframe, key, poseT -> {
                    poseT.rotate2.x += dx;
                    poseT.rotate2.y += dy;
                    poseT.rotate2.z += dz;
                });
            }
        }

        @Override
        public void setP(Axis axis, double x, double y, double z) {
            Transform transform = this.getTransform();
            float dx = (float)x - transform.pivot.x;
            float dy = (float)y - transform.pivot.y;
            float dz = (float)z - transform.pivot.z;
            for (String key : this.targets()) {
                UIPoseFactoryEditor.apply(this.editor.editor, this.editor.keyframe, key, poseT -> {
                    poseT.pivot.x += dx;
                    poseT.pivot.y += dy;
                    poseT.pivot.z += dz;
                });
            }
        }
    }
}

