/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.input.list;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mchorse.bbs_mod.audio.AudioCacheManager;
import mchorse.bbs_mod.audio.SoundLikeManager;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIIcon;
import mchorse.bbs_mod.ui.framework.elements.input.list.UIStringList;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.IOUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class UIVanillaSoundList
extends UIStringList {
    private final Map<String, VanillaSoundAsset> soundAssetMap = new HashMap<String, VanillaSoundAsset>();
    private UIIcon likeButton = new UIIcon(Icons.LIKE, null);
    private UIIcon downloadButton = new UIIcon(Icons.DOWNLOAD, null);
    private Consumer<String> downloadCallback;
    private Runnable likeToggleCallback;
    private SoundLikeManager likeManager;
    private boolean loaded = false;
    private JsonObject cachedSoundsJson = null;

    public UIVanillaSoundList(Consumer<List<String>> callback, SoundLikeManager likeManager) {
        super(callback);
        this.likeManager = likeManager;
    }

    private void ensureLoaded() {
        if (!this.loaded) {
            this.loadVanillaSoundFiles();
            this.populateList();
            this.loaded = true;
        }
    }

    public void setDownloadCallback(Consumer<String> callback) {
        this.downloadCallback = callback;
    }

    public void setLikeToggleCallback(Runnable callback) {
        this.likeToggleCallback = callback;
    }

    private String detectSoundCategory(String soundPath) {
        if (soundPath.startsWith("record.")) {
            return "Record";
        }
        if (soundPath.startsWith("music.")) {
            return "Music";
        }
        if (soundPath.startsWith("ambient.")) {
            return "Ambient";
        }
        if (soundPath.startsWith("block.")) {
            return "Block";
        }
        if (soundPath.startsWith("entity.")) {
            return "Entity";
        }
        if (soundPath.startsWith("item.")) {
            return "Item";
        }
        if (soundPath.startsWith("ui.")) {
            return "UI";
        }
        if (soundPath.startsWith("weather.")) {
            return "Weather";
        }
        return "Other";
    }

    private void loadVanillaSoundFiles() {
        this.soundAssetMap.clear();
        HashSet<String> existingDisplayNames = new HashSet<String>();
        try {
            class_310 client = class_310.method_1551();
            class_3300 resourceManager = client.method_1478();
            if (this.cachedSoundsJson == null) {
                this.cachedSoundsJson = this.loadSoundsJson(resourceManager);
            }
            class_2378 soundRegistry = class_7923.field_41172;
            for (class_2960 soundId : soundRegistry.method_10235()) {
                if (!soundId.method_12836().equals("minecraft")) continue;
                String soundPath = soundId.method_12832();
                Object displayName = soundPath;
                int suffix = 1;
                String category = this.detectSoundCategory(soundPath);
                while (existingDisplayNames.contains(displayName)) {
                    displayName = soundPath + "_" + suffix++;
                }
                existingDisplayNames.add((String)displayName);
                List<String> actualSoundPaths = this.findAllSoundFilesFromCache(soundId);
                if (actualSoundPaths != null && !actualSoundPaths.isEmpty()) {
                    for (int i = 0; i < actualSoundPaths.size(); ++i) {
                        String soundPathFull = actualSoundPaths.get(i);
                        String pathWithoutExt = soundPathFull.endsWith(".ogg") ? soundPathFull.substring(0, soundPathFull.length() - 4) : soundPathFull;
                        String flatDisplayName = pathWithoutExt.replace("/", "_");
                        Object uniqueKey = flatDisplayName;
                        int uniqueSuffix = 1;
                        while (existingDisplayNames.contains(uniqueKey)) {
                            uniqueKey = flatDisplayName + "_" + uniqueSuffix++;
                        }
                        existingDisplayNames.add((String)uniqueKey);
                        ArrayList<String> singlePath = new ArrayList<String>();
                        singlePath.add(soundPathFull);
                        this.soundAssetMap.put((String)uniqueKey, new VanillaSoundAsset((String)uniqueKey, soundId.toString(), singlePath, category));
                    }
                    continue;
                }
                String flatDisplayName = soundPath.replace(".", "_");
                this.soundAssetMap.put(flatDisplayName, new VanillaSoundAsset(flatDisplayName, soundId.toString(), new ArrayList<String>(), category));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JsonObject loadSoundsJson(class_3300 resourceManager) {
        block8: {
            JsonObject jsonObject;
            block9: {
                class_2960 soundsJsonId = new class_2960("minecraft", "sounds.json");
                Optional resource = resourceManager.method_14486(soundsJsonId);
                if (!resource.isPresent()) break block8;
                InputStream inputStream = ((class_3298)resource.get()).method_14482();
                try {
                    String jsonContent = IOUtils.readText(inputStream);
                    jsonObject = JsonParser.parseString((String)jsonContent).getAsJsonObject();
                    if (inputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                inputStream.close();
            }
            return jsonObject;
        }
        return null;
    }

    private List<String> findAllSoundFilesFromCache(class_2960 soundId) {
        if (this.cachedSoundsJson == null) {
            return null;
        }
        try {
            String soundPath = soundId.method_12832();
            JsonObject soundEntry = this.cachedSoundsJson.getAsJsonObject(soundPath);
            if (soundEntry == null) {
                return null;
            }
            if (soundEntry.has("sounds") && soundEntry.get("sounds").isJsonArray()) {
                JsonArray soundsArray = soundEntry.getAsJsonArray("sounds");
                ArrayList<String> actualPaths = new ArrayList<String>();
                for (int i = 0; i < soundsArray.size(); ++i) {
                    JsonObject soundObj;
                    JsonElement sound = soundsArray.get(i);
                    if (sound.isJsonPrimitive()) {
                        String path = sound.getAsString();
                        actualPaths.add(path);
                        continue;
                    }
                    if (!sound.isJsonObject() || (soundObj = sound.getAsJsonObject()).has("type") && soundObj.get("type").getAsString().equals("event") || !soundObj.has("name")) continue;
                    String path = soundObj.get("name").getAsString();
                    actualPaths.add(path);
                }
                if (actualPaths.isEmpty()) {
                    return null;
                }
                return actualPaths;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void populateList() {
        this.list.clear();
        for (String key : this.soundAssetMap.keySet()) {
            VanillaSoundAsset asset = this.soundAssetMap.get(key);
            String prefix = "[" + asset.category + "]: ";
            String displayName = prefix + asset.displayName;
            this.list.add(displayName);
        }
        this.list.sort(String::compareToIgnoreCase);
        this.update();
    }

    @Override
    protected void renderElementPart(UIContext context, String element, int i, int x, int y, boolean hover, boolean selected) {
        int textWidth = context.batcher.getFont().getWidth(element);
        int buttonSpace = 40;
        int maxWidth = this.area.w - 8 - buttonSpace;
        String displayText = element;
        if (textWidth > maxWidth) {
            displayText = context.batcher.getFont().limitToWidth(element, maxWidth);
        }
        context.batcher.textShadow(displayText, x + 4, y + (this.scroll.scrollItemSize - context.batcher.getFont().getHeight()) / 2, hover ? 0xDDDDFF : -1);
        String downloadedPath = this.findDownloadedSound(element);
        boolean isDownloaded = downloadedPath != null;
        int currentIconX = this.area.x + this.area.w - 20;
        int iconY = y + (this.scroll.scrollItemSize - 16) / 2;
        if (!isDownloaded) {
            boolean isHoverOnDownload = this.area.isInside(context) && context.mouseX >= currentIconX && context.mouseX < currentIconX + 16 && context.mouseY >= iconY && context.mouseY < iconY + 16;
            this.downloadButton.iconColor(isHoverOnDownload ? -1 : -7829368);
            this.downloadButton.area.set(currentIconX, iconY, 16, 16);
            this.downloadButton.render(context);
            currentIconX -= 20;
        }
        boolean isHoverOnLike = this.area.isInside(context) && context.mouseX >= currentIconX && context.mouseX < currentIconX + 16 && context.mouseY >= iconY && context.mouseY < iconY + 16;
        boolean isLiked = isDownloaded && this.likeManager.isSoundLiked(downloadedPath);
        this.likeButton.both(isLiked ? Icons.DISLIKE : Icons.LIKE);
        this.likeButton.iconColor(isHoverOnLike || isLiked ? -1 : -7829368);
        this.likeButton.area.set(currentIconX, iconY, 16, 16);
        this.likeButton.render(context);
    }

    @Override
    public boolean subMouseClicked(UIContext context) {
        int scrollIndex;
        String element;
        if (this.area.isInside(context) && context.mouseButton == 0 && (element = (String)this.getElementAt(scrollIndex = this.scroll.getIndex(context.mouseX, context.mouseY))) != null) {
            int y = this.area.y + scrollIndex * this.scroll.scrollItemSize - (int)this.scroll.getScroll();
            int iconY = y + (this.scroll.scrollItemSize - 16) / 2;
            String downloadedPath = this.findDownloadedSound(element);
            boolean isDownloaded = downloadedPath != null;
            int currentIconX = this.area.x + this.area.w - 20;
            if (!isDownloaded) {
                if (context.mouseX >= currentIconX && context.mouseX < currentIconX + 16 && context.mouseY >= iconY && context.mouseY < iconY + 16) {
                    this.downloadSound(element);
                    return true;
                }
                currentIconX -= 20;
            }
            if (context.mouseX >= currentIconX && context.mouseX < currentIconX + 16 && context.mouseY >= iconY && context.mouseY < iconY + 16) {
                this.toggleLikeWithDownload(element);
                return true;
            }
        }
        return super.subMouseClicked(context);
    }

    private void toggleLikeWithDownload(String displayName) {
        String originalName = this.removePrefix(displayName);
        VanillaSoundAsset asset = this.soundAssetMap.get(originalName);
        if (asset == null) {
            return;
        }
        try {
            String downloadedPath = this.findDownloadedSound(displayName);
            if (downloadedPath != null) {
                this.likeManager.toggleSoundLiked(downloadedPath, displayName);
                if (this.likeToggleCallback != null) {
                    this.likeToggleCallback.run();
                }
                this.update();
            } else {
                String finalName = this.copyToAssetsDirectoryWithOriginalName(originalName, asset);
                if (finalName != null) {
                    String assetsPath = "assets:audio/" + finalName + ".ogg";
                    this.likeManager.setSoundLiked(assetsPath, displayName, true);
                    if (this.downloadCallback != null) {
                        this.downloadCallback.accept(assetsPath);
                    }
                    if (this.likeToggleCallback != null) {
                        this.likeToggleCallback.run();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String removePrefix(String displayName) {
        int colonSpace;
        int endBracket = displayName.indexOf(93);
        if (endBracket > 0 && displayName.startsWith("[") && (colonSpace = displayName.indexOf("]: ", endBracket)) > 0) {
            return displayName.substring(colonSpace + 3);
        }
        return displayName;
    }

    private String findDownloadedSound(String displayName) {
        try {
            File exactMatch;
            String originalName = this.removePrefix(displayName);
            File gameDir = FabricLoader.getInstance().getGameDir().toFile();
            File audioDir = new File(gameDir, "config/bbs/assets/audio");
            if (!audioDir.exists() || !audioDir.isDirectory()) {
                return null;
            }
            Object flatFileName = originalName;
            if (!((String)flatFileName).endsWith(".ogg")) {
                flatFileName = (String)flatFileName + ".ogg";
            }
            if ((exactMatch = new File(audioDir, (String)flatFileName)).exists()) {
                return "assets:audio/" + (String)flatFileName;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private String copyToTempFile(VanillaSoundAsset asset) {
        block11: {
            try {
                File cachedFile;
                AudioCacheManager cacheManager = AudioCacheManager.getInstance();
                if (asset.actualSoundPaths == null || asset.actualSoundPaths.isEmpty()) break block11;
                Object soundPath = asset.actualSoundPaths.get(0);
                if (!((String)soundPath).endsWith(".ogg")) {
                    soundPath = (String)soundPath + ".ogg";
                }
                if ((cachedFile = cacheManager.getCachedFile((String)soundPath)) != null && cachedFile.exists()) {
                    return cachedFile.getName();
                }
                File cacheFile = cacheManager.createTempCacheFile((String)soundPath);
                if (cacheFile == null) {
                    return null;
                }
                class_2960 soundFileId = new class_2960("minecraft", "sounds/" + (String)soundPath);
                class_310 client = class_310.method_1551();
                Optional resource = client.method_1478().method_14486(soundFileId);
                if (!resource.isPresent()) break block11;
                try (InputStream inputStream = ((class_3298)resource.get()).method_14482();){
                    Files.copy(inputStream, cacheFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                return cacheFile.getName();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void downloadSound(String displayName) {
        String originalName = this.removePrefix(displayName);
        VanillaSoundAsset asset = this.soundAssetMap.get(originalName);
        if (asset == null) {
            return;
        }
        try {
            String finalName = this.copyToAssetsDirectory(displayName, asset);
            if (finalName != null) {
                String fullPath = "assets:audio/" + finalName + ".ogg";
                if (this.downloadCallback != null) {
                    this.downloadCallback.accept(fullPath);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String copyToAssetsDirectory(String displayName, VanillaSoundAsset asset) {
        String originalName = this.removePrefix(displayName);
        return this.copyToAssetsDirectoryWithOriginalName(originalName, asset);
    }

    private String copyToAssetsDirectoryWithOriginalName(String originalName, VanillaSoundAsset asset) {
        block10: {
            try {
                File gameDir = FabricLoader.getInstance().getGameDir().toFile();
                File audioDir = new File(gameDir, "config/bbs/assets/audio");
                if (!audioDir.exists()) {
                    audioDir.mkdirs();
                }
                if (asset.actualSoundPaths == null || asset.actualSoundPaths.isEmpty()) break block10;
                Object soundPath = asset.actualSoundPaths.get(0);
                if (!((String)soundPath).endsWith(".ogg")) {
                    soundPath = (String)soundPath + ".ogg";
                }
                class_2960 soundFileId = new class_2960("minecraft", "sounds/" + (String)soundPath);
                class_310 client = class_310.method_1551();
                Optional resource = client.method_1478().method_14486(soundFileId);
                if (!resource.isPresent()) break block10;
                String newSoundName = this.generateSoundName(originalName, audioDir);
                File targetFile = new File(audioDir, newSoundName + ".ogg");
                try (InputStream inputStream = ((class_3298)resource.get()).method_14482();){
                    Files.copy(inputStream, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                return newSoundName;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private String generateSoundName(String originalName, File audioDir) {
        File originalFile = new File(audioDir, originalName + ".ogg");
        if (!originalFile.exists()) {
            return originalName;
        }
        Pattern pattern = Pattern.compile("(.*)_(\\d+)$");
        Matcher matcher = pattern.matcher(originalName);
        if (matcher.matches()) {
            String baseName = matcher.group(1);
            int currentNumber = Integer.parseInt(matcher.group(2));
            return this.findAvailableFileName(baseName, currentNumber + 1, audioDir);
        }
        return this.findAvailableFileName(originalName, 1, audioDir);
    }

    private String findAvailableFileName(String baseName, int startNumber, File audioDir) {
        String candidateName;
        File candidateFile;
        int number = startNumber;
        do {
            candidateName = baseName + "_" + number;
            candidateFile = new File(audioDir, candidateName + ".ogg");
            ++number;
        } while (candidateFile.exists());
        return candidateName;
    }

    public File getTemporaryFileForSound(String displayName) {
        String originalName = this.removePrefix(displayName);
        VanillaSoundAsset asset = this.soundAssetMap.get(originalName);
        if (asset == null || asset.actualSoundPaths == null || asset.actualSoundPaths.isEmpty()) {
            return null;
        }
        try {
            String tempFileName = this.copyToTempFile(asset);
            if (tempFileName != null) {
                File cacheFile;
                AudioCacheManager cacheManager = AudioCacheManager.getInstance();
                Object soundPath = asset.actualSoundPaths.get(0);
                if (!((String)soundPath).endsWith(".ogg")) {
                    soundPath = (String)soundPath + ".ogg";
                }
                if ((cacheFile = cacheManager.getCachedFile((String)soundPath)) != null && cacheFile.exists()) {
                    return cacheFile;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void refresh() {
        this.ensureLoaded();
    }

    @Environment(value=EnvType.CLIENT)
    private static class VanillaSoundAsset {
        final String displayName;
        final String resourcePath;
        final List<String> actualSoundPaths;
        final String category;

        VanillaSoundAsset(String displayName, String resourcePath, List<String> actualSoundPaths, String category) {
            this.displayName = displayName;
            this.resourcePath = resourcePath;
            this.actualSoundPaths = actualSoundPaths;
            this.category = category;
        }
    }
}

