/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.clips;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import mchorse.bbs_mod.camera.clips.ClipFactoryData;
import mchorse.bbs_mod.camera.clips.overwrite.KeyframeClip;
import mchorse.bbs_mod.camera.data.Point;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.ListType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.settings.values.core.ValueGroup;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.clips.Clip;
import mchorse.bbs_mod.utils.factory.IFactory;

public class Clips
extends ValueGroup {
    private List<Clip> clips = new ArrayList<Clip>();
    private IFactory<Clip, ClipFactoryData> factory;

    public Clips(String id, IFactory<Clip, ClipFactoryData> factory) {
        super(id);
        this.factory = factory;
    }

    public IFactory<Clip, ClipFactoryData> getFactory() {
        return this.factory;
    }

    public int findFreeLayer(Clip clip) {
        int layer = (Integer)clip.layer.get();
        block0: while (true) {
            for (Clip newClip : this.clips) {
                float a1 = ((Integer)clip.tick.get()).intValue();
                float a2 = a1 + (float)((Integer)clip.duration.get()).intValue();
                float b1 = ((Integer)newClip.tick.get()).intValue();
                float b2 = b1 + (float)((Integer)newClip.duration.get()).intValue();
                if (layer != (Integer)newClip.layer.get() || !MathUtils.isInside(a1, a2, b1, b2)) continue;
                ++layer;
                continue block0;
            }
            break;
        }
        return layer;
    }

    public void sortLayers() {
        for (Clip clip : this.clips) {
            clip.layer.set(0);
        }
        for (Clip clip : this.clips) {
            for (Clip otherClip : this.clips) {
                if (clip == otherClip) continue;
                boolean sameLayer = clip.layer.get() == otherClip.layer.get();
                boolean intersects = MathUtils.isInside(((Integer)clip.tick.get()).intValue(), (Integer)clip.tick.get() + (Integer)clip.duration.get(), ((Integer)otherClip.tick.get()).intValue(), (Integer)otherClip.tick.get() + (Integer)otherClip.duration.get());
                if (!sameLayer || !intersects) continue;
                otherClip.layer.set((Integer)otherClip.layer.get() + 1);
            }
        }
    }

    public int getTopLayer() {
        int layer = 0;
        for (Clip clip : this.clips) {
            layer = Math.max(layer, (Integer)clip.layer.get());
        }
        return layer;
    }

    public int calculateDuration() {
        int max = 0;
        for (Clip clip : this.clips) {
            max = Math.max(max, (Integer)clip.tick.get() + (Integer)clip.duration.get());
        }
        return max;
    }

    public Clip get(int index) {
        return index >= 0 && index < this.clips.size() ? this.clips.get(index) : null;
    }

    public Clip getClipAt(int tick, int layer) {
        for (Clip clip : this.clips) {
            if (!clip.isInside(tick) || (Integer)clip.layer.get() != layer) continue;
            return clip;
        }
        return null;
    }

    public List<Clip> getClips(int tick) {
        return this.getClips(tick, Integer.MAX_VALUE);
    }

    public List<Clip> getClips(int tick, int maxLayer) {
        ArrayList<Clip> clipList = new ArrayList<Clip>();
        for (Clip clip : this.clips) {
            boolean isGlobal;
            boolean bl = isGlobal = clip.isGlobal() && maxLayer == Integer.MAX_VALUE;
            if (!clip.isInside(tick) && !isGlobal || (Integer)clip.layer.get() >= maxLayer) continue;
            clipList.add(clip);
        }
        clipList.sort(Comparator.comparingInt(a -> (Integer)a.layer.get()));
        return clipList;
    }

    public int getIndex(Clip clip) {
        return this.clips.indexOf(clip);
    }

    public void addClip(Clip clip) {
        this.preNotify();
        this.clips.add(clip);
        this.sync();
        this.postNotify();
    }

    public void remove(Clip clip) {
        this.preNotify();
        this.clips.remove(clip);
        this.sync();
        this.postNotify();
    }

    public void copyOver(Clips clips, int tick) {
        this.preNotify();
        this.clips.removeIf(next -> (Integer)next.tick.get() >= tick);
        for (Clip clip : clips.clips) {
            Clip copy = clip.copy();
            copy.tick.set(tick + (Integer)copy.tick.get());
            this.addClip(copy);
        }
        this.sortLayers();
        this.sync();
        this.postNotify();
    }

    public void sync() {
        this.removeAll();
        int c = this.clips.size();
        for (int i = 0; i < c; ++i) {
            Clip clip = this.clips.get(i);
            clip.setId(String.valueOf(i));
            this.add(clip);
        }
    }

    public List<Clip> get() {
        return Collections.unmodifiableList(this.clips);
    }

    public <T extends Clip> List<T> getClips(Class<T> type) {
        ArrayList<Clip> result = new ArrayList<Clip>();
        for (Clip clip : this.clips) {
            if (!type.isInstance(clip)) continue;
            result.add((Clip)type.cast(clip));
        }
        return result;
    }

    public int findNextTick(int tick) {
        int output = Integer.MAX_VALUE;
        for (Clip clip : this.clips) {
            int left = (Integer)clip.tick.get() - tick;
            int right = left + (Integer)clip.duration.get();
            int a = Math.max(left, 0);
            int b = Math.max(right, 0);
            if (a > 0) {
                output = Math.min(output, a);
                continue;
            }
            if (b <= 0) continue;
            output = Math.min(output, b);
        }
        return tick + (output != Integer.MAX_VALUE ? output : 0);
    }

    public int findPreviousTick(int tick) {
        int output = Integer.MIN_VALUE;
        for (Clip clip : this.clips) {
            int left = (Integer)clip.tick.get() - tick;
            int right = left + (Integer)clip.duration.get();
            int a = Math.min(left, 0);
            int b = Math.min(right, 0);
            if (b < 0) {
                output = Math.max(output, b);
                continue;
            }
            if (a >= 0) continue;
            output = Math.max(output, a);
        }
        return tick + (output != Integer.MIN_VALUE ? output : 0);
    }

    public void shift(float tick) {
        for (Clip clip : this.clips) {
            clip.tick.set(Math.round((float)((Integer)clip.tick.get()).intValue() + tick));
        }
    }

    public void shift(double dx, double dy, double dz) {
        for (Clip clip : this.clips) {
            clip.shift(dx, dy, dz);
        }
    }

    @Override
    public BaseType toData() {
        ListType list = new ListType();
        for (Clip clip : this.clips) {
            list.add(this.factory.toData(clip));
        }
        return list;
    }

    @Override
    public void fromData(BaseType base) {
        this.clips.clear();
        for (BaseType type : base.asList()) {
            if (!type.isMap()) continue;
            try {
                Clip clip = this.factory.fromData(type.asMap());
                if (clip == null) continue;
                this.clips.add(clip);
            }
            catch (Exception e) {
                MapType map = type.asMap();
                if (!map.getString("type").equalsIgnoreCase("bbs:circular")) continue;
                KeyframeClip clip = new KeyframeClip();
                Point point = new Point(0.0, 0.0, 0.0);
                point.fromData(map.getMap("start"));
                clip.fromData(map);
                clip.x.insert(0.0f, point.x);
                clip.y.insert(0.0f, point.y);
                clip.z.insert(0.0f, point.z);
                clip.yaw.insert(0.0f, Double.valueOf(map.getFloat("start")));
                clip.yaw.insert(((Integer)clip.duration.get()).intValue(), (double)map.getFloat("start") + (double)map.getFloat("circles"));
                clip.pitch.insert(0.0f, Double.valueOf(map.getFloat("pitch")));
                clip.roll.insert(0.0f, 0.0);
                clip.fov.insert(0.0f, Double.valueOf(map.getFloat("fov")));
                clip.distance.insert(0.0f, Double.valueOf(map.getFloat("distance")));
                this.clips.add(clip);
            }
        }
        this.sync();
    }
}

