/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.resources;

import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import mchorse.bbs_mod.utils.IOUtils;
import mchorse.bbs_mod.utils.colors.Color;
import mchorse.bbs_mod.utils.colors.Colors;
import mchorse.bbs_mod.utils.interps.Lerps;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class Pixels {
    private ByteBuffer buffer;
    public final int width;
    public final int height;
    public final int bits;
    public Color color = new Color();

    public static Pixels fromPNGStream(InputStream stream) throws IOException {
        ByteBuffer pixels;
        int bitsPerPixel;
        int h;
        int w;
        ByteBuffer image = IOUtils.readByteBuffer(stream, 8192);
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer width = stack.mallocInt(1);
            IntBuffer height = stack.mallocInt(1);
            IntBuffer bits = stack.mallocInt(1);
            if (!STBImage.stbi_info_from_memory((ByteBuffer)image, (IntBuffer)width, (IntBuffer)height, (IntBuffer)bits)) {
                throw new RuntimeException("Failed to read image information: " + STBImage.stbi_failure_reason());
            }
            w = width.get(0);
            h = height.get(0);
            bitsPerPixel = bits.get(0);
            pixels = STBImage.stbi_load_from_memory((ByteBuffer)image, (IntBuffer)width, (IntBuffer)height, (IntBuffer)bits, (int)0);
            if (bitsPerPixel <= 2) {
                ByteBuffer newBuffer = MemoryUtil.memAlloc((int)(w * h * 4));
                pixels.position(0);
                pixels.limit(pixels.capacity());
                int c = pixels.limit() / bitsPerPixel;
                for (int i = 0; i < c; ++i) {
                    byte g = pixels.get();
                    byte a = bitsPerPixel == 1 ? (byte)-1 : (byte)pixels.get();
                    newBuffer.put(g);
                    newBuffer.put(g);
                    newBuffer.put(g);
                    newBuffer.put(a);
                }
                newBuffer.flip();
                MemoryUtil.memFree((Buffer)pixels);
                pixels = newBuffer;
                bitsPerPixel = 4;
            }
        }
        MemoryUtil.memFree((Buffer)image);
        return new Pixels(pixels, w, h, bitsPerPixel);
    }

    public static Pixels fromIntArray(int width, int height, int[] data) {
        Pixels pixels = Pixels.fromSize(width, height);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int i = x + y * width;
                pixels.setColor(x, y, Colors.COLOR.set(data[i]));
            }
        }
        return pixels;
    }

    public static Pixels fromSize(int w, int h) {
        ByteBuffer buffer = MemoryUtil.memAlloc((int)(w * h * 4));
        buffer.position(0);
        int c = w * h;
        for (int i = 0; i < c; ++i) {
            buffer.put((byte)0);
            buffer.put((byte)0);
            buffer.put((byte)0);
            buffer.put((byte)0);
        }
        return new Pixels(buffer, w, h);
    }

    public Pixels(ByteBuffer buffer, int w, int h) {
        this(buffer, w, h, 4);
    }

    public Pixels(ByteBuffer buffer, int w, int h, int bits) {
        this.buffer = buffer;
        this.width = w;
        this.height = h;
        this.bits = bits;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public int toIndex(int x, int y) {
        return x + y * this.width;
    }

    public int toX(int index) {
        return index % this.width;
    }

    public int toY(int index) {
        return index / this.width;
    }

    public int getCount() {
        return this.width * this.height;
    }

    public Color getColor(int index) {
        if (index < 0 || index >= this.width * this.height) {
            return null;
        }
        this.buffer.position(index * this.bits);
        this.color.r = (float)(this.buffer.get() & 0xFF) / 255.0f;
        this.color.g = (float)(this.buffer.get() & 0xFF) / 255.0f;
        this.color.b = (float)(this.buffer.get() & 0xFF) / 255.0f;
        this.color.a = this.bits == 4 ? (float)(this.buffer.get() & 0xFF) / 255.0f : 1.0f;
        return this.color;
    }

    public Color getColor(int x, int y) {
        return this.getColor(this.toIndex(x, y));
    }

    public void setColor(int index, Color color) {
        this.buffer.position(index * this.bits);
        this.buffer.put((byte)(color.r * 255.0f));
        this.buffer.put((byte)(color.g * 255.0f));
        this.buffer.put((byte)(color.b * 255.0f));
        if (this.bits == 4) {
            this.buffer.put((byte)(color.a * 255.0f));
        }
    }

    public void setColor(int x, int y, Color color) {
        this.setColor(this.toIndex(x, y), color);
    }

    public void draw(Pixels pixels, int x, int y) {
        Color color = new Color();
        int ic = Math.min(x + pixels.width, this.width);
        for (int i = Math.max(x, 0); i < ic; ++i) {
            int jc = Math.min(y + pixels.height, this.height);
            for (int j = Math.max(y, 0); j < jc; ++j) {
                int px = i - x;
                int py = j - y;
                Color target = pixels.getColor(px, py);
                Color source = this.getColor(i, j);
                color.a = 1.0f - (1.0f - target.a) * (1.0f - source.a);
                color.r = target.r * target.a / color.a + source.r * source.a * (1.0f - target.a) / color.a;
                color.g = target.g * target.a / color.a + source.g * source.a * (1.0f - target.a) / color.a;
                color.b = target.b * target.a / color.a + source.b * source.a * (1.0f - target.a) / color.a;
                this.setColor(i, j, color);
            }
        }
    }

    public void draw(Pixels pixels, int x, int y, int w, int h) {
        Color color = new Color();
        int ic = Math.min(x + w, this.width);
        for (int i = Math.max(x, 0); i < ic; ++i) {
            int jc = Math.min(y + h, this.height);
            for (int j = Math.max(y, 0); j < jc; ++j) {
                float fx = (float)(i - x) / (float)w;
                float fy = (float)(j - y) / (float)h;
                int px = (int)((float)pixels.width * fx);
                int py = (int)((float)pixels.height * fy);
                Color target = pixels.getColor(px, py);
                Color source = this.getColor(i, j);
                color.a = 1.0f - (1.0f - target.a) * (1.0f - source.a);
                color.r = target.r * target.a / color.a + source.r * source.a * (1.0f - target.a) / color.a;
                color.g = target.g * target.a / color.a + source.g * source.a * (1.0f - target.a) / color.a;
                color.b = target.b * target.a / color.a + source.b * source.a * (1.0f - target.a) / color.a;
                this.setColor(i, j, color);
            }
        }
    }

    public void drawRect(int x, int y, int w, int h, int c) {
        Color color = new Color().set(c);
        int ic = Math.min(x + w, this.width);
        for (int i = Math.max(x, 0); i < ic; ++i) {
            int jc = Math.min(y + h, this.height);
            for (int j = Math.max(y, 0); j < jc; ++j) {
                this.setColor(i, j, color);
            }
        }
    }

    public void drawPixels(Pixels source, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        int dirY;
        int dirX = dx2 - dx1 < 0 ? -1 : 1;
        int n = dirY = dy2 - dy1 < 0 ? -1 : 1;
        if (dirX < 0) {
            --dx1;
            --dx2;
        }
        if (dirY < 0) {
            --dy1;
            --dy2;
        }
        for (int x = dx1; x != dx2; x += dirX) {
            for (int y = dy1; y != dy2; y += dirY) {
                int yy;
                float fx = (float)(x - dx1) / (float)(dx2 - dx1);
                float fy = (float)(y - dy1) / (float)(dy2 - dy1);
                int xx = (int)Lerps.lerp(sx1, sx2, fx);
                Color color = source.getColor(xx, yy = (int)Lerps.lerp(sy1, sy2, fy));
                if (color == null) continue;
                this.setColor(x, y, color);
            }
        }
    }

    public int[] getARGB() {
        int[] colors = new int[this.width * this.height * 4];
        int c = this.getCount();
        for (int i = 0; i < c; ++i) {
            colors[i] = this.getColor(i).getARGBColor();
        }
        return colors;
    }

    public Pixels createCopy(int x, int y, int w, int h) {
        Pixels pixels = Pixels.fromSize(w, h);
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                Color color = this.getColor(x + i, y + j);
                pixels.setColor(i, j, color);
            }
        }
        return pixels;
    }

    public void rewindBuffer() {
        if (this.buffer != null) {
            this.buffer.position(0);
            this.buffer.limit(this.buffer.capacity());
        }
    }

    public void delete() {
        MemoryUtil.memFree((Buffer)this.buffer);
        this.buffer = null;
    }
}

