/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.cubic.render.vao;

import mchorse.bbs_mod.bobj.BOBJArmature;
import mchorse.bbs_mod.bobj.BOBJLoader;
import mchorse.bbs_mod.client.BBSRendering;
import mchorse.bbs_mod.cubic.render.vao.ModelVAORenderer;
import mchorse.bbs_mod.ui.framework.elements.utils.StencilMap;
import mchorse.bbs_mod.utils.joml.Matrices;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL30;

@Environment(value=EnvType.CLIENT)
public class BOBJModelVAO {
    public BOBJLoader.CompiledData data;
    public BOBJArmature armature;
    private int vao;
    private int count;
    public int vertexBuffer;
    public int normalBuffer;
    public int lightBuffer;
    public int texCoordBuffer;
    public int tangentBuffer;
    public int midTextureBuffer;
    private float[] tmpVertices;
    private float[] tmpNormals;
    private int[] tmpLight;
    private float[] tmpTangents;

    public BOBJModelVAO(BOBJLoader.CompiledData data) {
        this.data = data;
        this.armature = this.data.mesh.armature;
        this.initBuffers();
    }

    private void initBuffers() {
        this.vao = GL30.glGenVertexArrays();
        GL30.glBindVertexArray((int)this.vao);
        this.vertexBuffer = GL30.glGenBuffers();
        this.normalBuffer = GL30.glGenBuffers();
        this.lightBuffer = GL30.glGenBuffers();
        this.texCoordBuffer = GL30.glGenBuffers();
        this.tangentBuffer = GL30.glGenBuffers();
        this.midTextureBuffer = GL30.glGenBuffers();
        this.count = this.data.normData.length / 3;
        this.tmpVertices = new float[this.data.posData.length];
        this.tmpNormals = new float[this.data.normData.length];
        this.tmpLight = new int[this.data.posData.length];
        this.tmpTangents = new float[this.count * 4];
        GL30.glBindBuffer((int)34962, (int)this.vertexBuffer);
        GL30.glBufferData((int)34962, (float[])this.data.posData, (int)35048);
        GL30.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)0, (long)0L);
        GL30.glBindBuffer((int)34962, (int)this.normalBuffer);
        GL30.glBufferData((int)34962, (float[])this.data.normData, (int)35048);
        GL30.glVertexAttribPointer((int)5, (int)3, (int)5126, (boolean)false, (int)0, (long)0L);
        GL30.glBindBuffer((int)34962, (int)this.lightBuffer);
        GL30.glBufferData((int)34962, (int[])this.tmpLight, (int)35048);
        GL30.glVertexAttribIPointer((int)4, (int)2, (int)5124, (int)0, (long)0L);
        GL30.glBindBuffer((int)34962, (int)this.texCoordBuffer);
        GL30.glBufferData((int)34962, (float[])this.data.texData, (int)35044);
        GL30.glVertexAttribPointer((int)2, (int)2, (int)5126, (boolean)false, (int)0, (long)0L);
        GL30.glBindBuffer((int)34962, (int)this.tangentBuffer);
        GL30.glBufferData((int)34962, (float[])this.tmpTangents, (int)35044);
        GL30.glVertexAttribPointer((int)9, (int)4, (int)5126, (boolean)false, (int)0, (long)0L);
        GL30.glBindBuffer((int)34962, (int)this.texCoordBuffer);
        GL30.glBufferData((int)34962, (float[])this.data.texData, (int)35044);
        GL30.glVertexAttribPointer((int)8, (int)2, (int)5126, (boolean)false, (int)0, (long)0L);
    }

    public void delete() {
        GL30.glDeleteVertexArrays((int)this.vao);
        GL15.glDeleteBuffers((int)this.vertexBuffer);
        GL15.glDeleteBuffers((int)this.normalBuffer);
        GL15.glDeleteBuffers((int)this.lightBuffer);
        GL15.glDeleteBuffers((int)this.texCoordBuffer);
        GL15.glDeleteBuffers((int)this.tangentBuffer);
        GL15.glDeleteBuffers((int)this.midTextureBuffer);
    }

    public void updateMesh(StencilMap stencilMap) {
        Vector4f sum = new Vector4f();
        Vector4f result = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
        Vector3f sumNormal = new Vector3f();
        Vector3f resultNormal = new Vector3f();
        float[] oldVertices = this.data.posData;
        float[] newVertices = this.tmpVertices;
        float[] oldNormals = this.data.normData;
        float[] newNormals = this.tmpNormals;
        Matrix4f[] matrices = this.armature.matrices;
        int c = this.count;
        for (int i = 0; i < c; ++i) {
            int count = 0;
            float maxWeight = -1.0f;
            int lightBone = -1;
            for (int w = 0; w < 4; ++w) {
                float weight = this.data.weightData[i * 4 + w];
                if (!(weight > 0.0f)) continue;
                int index = this.data.boneIndexData[i * 4 + w];
                sum.set(oldVertices[i * 3], oldVertices[i * 3 + 1], oldVertices[i * 3 + 2], 1.0f);
                matrices[index].transform(sum);
                result.add((Vector4fc)sum.mul(weight));
                sumNormal.set(oldNormals[i * 3], oldNormals[i * 3 + 1], oldNormals[i * 3 + 2]);
                Matrices.TEMP_3F.set((Matrix4fc)matrices[index]).transform(sumNormal);
                resultNormal.add((Vector3fc)sumNormal.mul(weight));
                ++count;
                if (!(weight > maxWeight)) continue;
                lightBone = index;
                maxWeight = weight;
            }
            if (count == 0) {
                result.set(oldVertices[i * 3], oldVertices[i * 3 + 1], oldVertices[i * 3 + 2], 1.0f);
                resultNormal.set(oldNormals[i * 3], oldNormals[i * 3 + 1], oldNormals[i * 3 + 2]);
            }
            result.x /= result.w;
            result.y /= result.w;
            result.z /= result.w;
            newVertices[i * 3] = result.x;
            newVertices[i * 3 + 1] = result.y;
            newVertices[i * 3 + 2] = result.z;
            newNormals[i * 3] = resultNormal.x;
            newNormals[i * 3 + 1] = resultNormal.y;
            newNormals[i * 3 + 2] = resultNormal.z;
            result.set(0.0f, 0.0f, 0.0f, 0.0f);
            resultNormal.set(0.0f, 0.0f, 0.0f);
            if (stencilMap == null) continue;
            this.tmpLight[i * 2] = Math.max(0, stencilMap.increment ? lightBone : 0);
            this.tmpLight[i * 2 + 1] = 0;
        }
        this.processData(newVertices, newNormals);
        GL15.glBindBuffer((int)34962, (int)this.vertexBuffer);
        GL15.glBufferData((int)34962, (float[])newVertices, (int)35048);
        GL15.glBindBuffer((int)34962, (int)this.normalBuffer);
        GL15.glBufferData((int)34962, (float[])newNormals, (int)35048);
        if (BBSRendering.isIrisShadersEnabled()) {
            BBSRendering.calculateTangents(this.tmpTangents, newVertices, newNormals, this.data.texData);
            GL15.glBindBuffer((int)34962, (int)this.tangentBuffer);
            GL15.glBufferData((int)34962, (float[])this.tmpTangents, (int)35048);
        }
        if (stencilMap != null) {
            GL15.glBindBuffer((int)34962, (int)this.lightBuffer);
            GL15.glBufferData((int)34962, (int[])this.tmpLight, (int)35048);
        }
    }

    protected void processData(float[] newVertices, float[] newNormals) {
    }

    public void render(class_5944 shader, class_4587 stack, float r, float g, float b, float a, StencilMap stencilMap, int light, int overlay) {
        if (shader == null) {
            class_5944 fallback = class_757.method_34507();
            if (fallback == null) {
                return;
            }
            shader = fallback;
        }
        boolean hasShaders = BBSRendering.isIrisShadersEnabled();
        GL30.glVertexAttrib4f((int)1, (float)r, (float)g, (float)b, (float)a);
        GL30.glVertexAttribI2i((int)3, (int)(overlay & 0xFFFF), (int)(overlay >> 16 & 0xFFFF));
        GL30.glVertexAttribI2i((int)4, (int)(light & 0xFFFF), (int)(light >> 16 & 0xFFFF));
        int currentVAO = GL30.glGetInteger((int)34229);
        int currentElementArrayBuffer = GL30.glGetInteger((int)34965);
        ModelVAORenderer.setupUniforms(stack, shader);
        shader.method_34586();
        GL30.glBindVertexArray((int)this.vao);
        GL30.glEnableVertexAttribArray((int)0);
        GL30.glEnableVertexAttribArray((int)2);
        GL30.glEnableVertexAttribArray((int)5);
        if (stencilMap != null) {
            GL30.glEnableVertexAttribArray((int)4);
        }
        if (hasShaders) {
            GL30.glEnableVertexAttribArray((int)9);
        }
        if (hasShaders) {
            GL30.glEnableVertexAttribArray((int)8);
        }
        GL30.glDrawArrays((int)4, (int)0, (int)this.count);
        GL30.glDisableVertexAttribArray((int)0);
        GL30.glDisableVertexAttribArray((int)2);
        GL30.glDisableVertexAttribArray((int)5);
        if (stencilMap != null) {
            GL30.glDisableVertexAttribArray((int)4);
        }
        if (hasShaders) {
            GL30.glDisableVertexAttribArray((int)9);
        }
        if (hasShaders) {
            GL30.glDisableVertexAttribArray((int)8);
        }
        shader.method_34585();
        GL30.glBindVertexArray((int)currentVAO);
        GL30.glBindBuffer((int)34963, (int)currentElementArrayBuffer);
    }
}

