/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.film;

import java.util.List;
import java.util.Map;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.camera.clips.CameraClipContext;
import mchorse.bbs_mod.camera.clips.misc.AudioClientClip;
import mchorse.bbs_mod.camera.data.Position;
import mchorse.bbs_mod.film.BaseFilmController;
import mchorse.bbs_mod.film.Film;
import mchorse.bbs_mod.utils.clips.Clip;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;

@Environment(value=EnvType.CLIENT)
public class WorldFilmController
extends BaseFilmController {
    protected CameraClipContext context;
    protected Position position = new Position();
    public int tick;
    public int duration;

    public WorldFilmController(Film film) {
        super(film);
        this.createEntities();
        this.duration = film.camera.calculateDuration();
        this.context = new CameraClipContext();
        this.context.clips = film.camera;
    }

    @Override
    public Map<String, Integer> getActors() {
        return BBSModClient.getFilms().actors.get(this.film.getId());
    }

    @Override
    public int getTick() {
        return this.tick;
    }

    @Override
    public boolean hasFinished() {
        return this.tick >= this.duration;
    }

    @Override
    public void update() {
        if (!this.paused) {
            ++this.tick;
        }
        super.update();
    }

    @Override
    public void render(WorldRenderContext context) {
        super.render(context);
        int tick = Math.max(this.tick, 0);
        List<Clip> clips = this.context.clips.getClips(tick);
        if (clips.isEmpty()) {
            return;
        }
        this.context.clipData.clear();
        this.context.setup(tick, context.tickCounter().method_60637(false));
        for (Clip clip : clips) {
            this.context.apply(clip, this.position);
        }
        this.context.currentLayer = 0;
        AudioClientClip.manageSounds(this.context);
    }

    @Override
    public void shutdown() {
        this.context.shutdown();
    }
}

