/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.forms.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.IntBuffer;
import java.util.function.Supplier;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.forms.forms.FramebufferForm;
import mchorse.bbs_mod.forms.renderers.FormRenderer;
import mchorse.bbs_mod.forms.renderers.FormRenderingContext;
import mchorse.bbs_mod.graphics.Framebuffer;
import mchorse.bbs_mod.graphics.Renderbuffer;
import mchorse.bbs_mod.graphics.texture.Texture;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.Quad;
import mchorse.bbs_mod.utils.colors.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import net.minecraft.class_8251;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.MemoryStack;

@Environment(value=EnvType.CLIENT)
public class FramebufferFormRenderer
extends FormRenderer<FramebufferForm> {
    private static final Quad quad = new Quad();
    private static final Quad uvQuad = new Quad();
    private static final Link framebufferKey = Link.bbs("framebuffer_form");

    public FramebufferFormRenderer(FramebufferForm form) {
        super(form);
    }

    @Override
    protected void renderInUI(UIContext context, int x1, int y1, int x2, int y2) {
    }

    @Override
    public void renderBodyParts(FormRenderingContext context) {
        int height;
        int width;
        Framebuffer framebuffer = BBSModClient.getFramebuffers().getFramebuffer(framebufferKey, f -> {
            Texture texture = new Texture();
            texture.setSize(2, 2);
            texture.setFilter(9728);
            texture.setWrap(33071);
            Renderbuffer renderbuffer = new Renderbuffer();
            renderbuffer.resize(2, 2);
            f.deleteTextures().attach(texture, 36064);
            f.attach(renderbuffer);
            f.unbind();
        });
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer viewport = stack.mallocInt(4);
            GL30.glGetIntegerv((int)2978, (IntBuffer)viewport);
            width = viewport.get(2);
            height = viewport.get(3);
        }
        Texture mainTexture = framebuffer.getMainTexture();
        int w = MathUtils.clamp((Integer)((FramebufferForm)this.form).width.get(), 2, 4096);
        int h = MathUtils.clamp((Integer)((FramebufferForm)this.form).height.get(), 2, 4096);
        int prevDraw = GL30.glGetInteger((int)36006);
        int prevRead = GL30.glGetInteger((int)36010);
        Vector3f light0 = RenderSystem.shaderLightDirections[0];
        Vector3f light1 = RenderSystem.shaderLightDirections[1];
        Matrix4f projectionMatrix = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
        GL30.glCullFace((int)1028);
        RenderSystem.setShaderLights((Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f));
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setOrtho(-1.0f, 1.0f, 1.0f, -1.0f, -500.0f, 500.0f), (class_8251)class_8251.field_43361);
        RenderSystem.getModelViewStack().pushMatrix();
        RenderSystem.getModelViewStack().identity();
        RenderSystem.applyModelViewMatrix();
        framebuffer.apply();
        if (w != mainTexture.width || h != mainTexture.height) {
            framebuffer.resize(w, h);
        }
        framebuffer.clear();
        context.stack.method_22903();
        context.stack.method_23760().method_23761().identity();
        context.stack.method_23760().method_23762().identity();
        super.renderBodyParts(context);
        context.stack.method_22909();
        GL30.glBindFramebuffer((int)36009, (int)prevDraw);
        GL30.glBindFramebuffer((int)36008, (int)prevRead);
        GL30.glViewport((int)0, (int)0, (int)width, (int)height);
        RenderSystem.setShaderLights((Vector3f)light0, (Vector3f)light1);
        RenderSystem.getModelViewStack().popMatrix();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrix, (class_8251)class_8251.field_43361);
        GL30.glCullFace((int)1029);
        boolean shading = !context.isPicking();
        class_293 format = shading ? class_290.field_1580 : class_290.field_1575;
        Supplier<class_5944> shader = shading ? class_757::method_34508 : class_757::method_34543;
        this.renderModel(framebuffer.getMainTexture(), format, shader, context.stack, context.overlay, context.light, context.color, context.getTransition());
    }

    private void renderModel(Texture texture, class_293 format, Supplier<class_5944> shader, class_4587 matrices, int overlay, int light, int overlayColor, float transition) {
        float w = texture.width;
        float h = texture.height;
        Vector4f crop = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
        float uvTLx = crop.x / w;
        float uvTLy = crop.y / h;
        float uvBRx = 1.0f - crop.z / w;
        float uvBRy = 1.0f - crop.w / h;
        FramebufferFormRenderer.uvQuad.p1.set(uvTLx, uvTLy, 0.0f);
        FramebufferFormRenderer.uvQuad.p2.set(uvBRx, uvTLy, 0.0f);
        FramebufferFormRenderer.uvQuad.p3.set(uvTLx, uvBRy, 0.0f);
        FramebufferFormRenderer.uvQuad.p4.set(uvBRx, uvBRy, 0.0f);
        float ratioX = w > h ? h / w : 1.0f;
        float ratioY = h > w ? w / h : 1.0f;
        float TLx = (uvTLx - 0.5f) * ratioY;
        float TLy = -(uvTLy - 0.5f) * ratioX;
        float BRx = (uvBRx - 0.5f) * ratioY;
        float BRy = -(uvBRy - 0.5f) * ratioX;
        FramebufferFormRenderer.quad.p1.set(TLx, TLy, 0.0f);
        FramebufferFormRenderer.quad.p2.set(BRx, TLy, 0.0f);
        FramebufferFormRenderer.quad.p3.set(TLx, BRy, 0.0f);
        FramebufferFormRenderer.quad.p4.set(BRx, BRy, 0.0f);
        this.renderQuad(format, texture, shader, matrices, overlay, light, overlayColor, transition);
    }

    private void renderQuad(class_293 format, Texture texture, Supplier<class_5944> shader, class_4587 matrices, int overlay, int light, int overlayColor, float transition) {
        class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27379, format);
        Color color = Color.white();
        class_4587.class_4665 entry = matrices.method_23760();
        Matrix4f matrix = entry.method_23761();
        color.mul(overlayColor);
        class_757 gameRenderer = class_310.method_1551().field_1773;
        if (format == class_290.field_1580) {
            gameRenderer.method_22974().method_3316();
            gameRenderer.method_22975().method_23209();
        }
        BBSModClient.getTextures().bindTexture(texture);
        RenderSystem.setShader(shader);
        texture.bind();
        texture.setFilterMipmap(false, false);
        this.fill(format, (class_4588)builder, matrix, FramebufferFormRenderer.quad.p3.x, FramebufferFormRenderer.quad.p3.y, color, FramebufferFormRenderer.uvQuad.p3.x, FramebufferFormRenderer.uvQuad.p3.y, overlay, light, entry, 1.0f);
        this.fill(format, (class_4588)builder, matrix, FramebufferFormRenderer.quad.p2.x, FramebufferFormRenderer.quad.p2.y, color, FramebufferFormRenderer.uvQuad.p2.x, FramebufferFormRenderer.uvQuad.p2.y, overlay, light, entry, 1.0f);
        this.fill(format, (class_4588)builder, matrix, FramebufferFormRenderer.quad.p1.x, FramebufferFormRenderer.quad.p1.y, color, FramebufferFormRenderer.uvQuad.p1.x, FramebufferFormRenderer.uvQuad.p1.y, overlay, light, entry, 1.0f);
        this.fill(format, (class_4588)builder, matrix, FramebufferFormRenderer.quad.p3.x, FramebufferFormRenderer.quad.p3.y, color, FramebufferFormRenderer.uvQuad.p3.x, FramebufferFormRenderer.uvQuad.p3.y, overlay, light, entry, 1.0f);
        this.fill(format, (class_4588)builder, matrix, FramebufferFormRenderer.quad.p4.x, FramebufferFormRenderer.quad.p4.y, color, FramebufferFormRenderer.uvQuad.p4.x, FramebufferFormRenderer.uvQuad.p4.y, overlay, light, entry, 1.0f);
        this.fill(format, (class_4588)builder, matrix, FramebufferFormRenderer.quad.p2.x, FramebufferFormRenderer.quad.p2.y, color, FramebufferFormRenderer.uvQuad.p2.x, FramebufferFormRenderer.uvQuad.p2.y, overlay, light, entry, 1.0f);
        this.fill(format, (class_4588)builder, matrix, FramebufferFormRenderer.quad.p1.x, FramebufferFormRenderer.quad.p1.y, color, FramebufferFormRenderer.uvQuad.p1.x, FramebufferFormRenderer.uvQuad.p1.y, overlay, light, entry, -1.0f);
        this.fill(format, (class_4588)builder, matrix, FramebufferFormRenderer.quad.p2.x, FramebufferFormRenderer.quad.p2.y, color, FramebufferFormRenderer.uvQuad.p2.x, FramebufferFormRenderer.uvQuad.p2.y, overlay, light, entry, -1.0f);
        this.fill(format, (class_4588)builder, matrix, FramebufferFormRenderer.quad.p3.x, FramebufferFormRenderer.quad.p3.y, color, FramebufferFormRenderer.uvQuad.p3.x, FramebufferFormRenderer.uvQuad.p3.y, overlay, light, entry, -1.0f);
        this.fill(format, (class_4588)builder, matrix, FramebufferFormRenderer.quad.p2.x, FramebufferFormRenderer.quad.p2.y, color, FramebufferFormRenderer.uvQuad.p2.x, FramebufferFormRenderer.uvQuad.p2.y, overlay, light, entry, -1.0f);
        this.fill(format, (class_4588)builder, matrix, FramebufferFormRenderer.quad.p4.x, FramebufferFormRenderer.quad.p4.y, color, FramebufferFormRenderer.uvQuad.p4.x, FramebufferFormRenderer.uvQuad.p4.y, overlay, light, entry, -1.0f);
        this.fill(format, (class_4588)builder, matrix, FramebufferFormRenderer.quad.p3.x, FramebufferFormRenderer.quad.p3.y, color, FramebufferFormRenderer.uvQuad.p3.x, FramebufferFormRenderer.uvQuad.p3.y, overlay, light, entry, -1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableBlend();
        class_286.method_43433((class_9801)builder.method_60800());
        if (format == class_290.field_1580) {
            gameRenderer.method_22974().method_3315();
            gameRenderer.method_22975().method_23213();
        }
    }

    private class_4588 fill(class_293 format, class_4588 consumer, Matrix4f matrix, float x, float y, Color color, float u, float v, int overlay, int light, class_4587.class_4665 entry, float nz) {
        if (format == class_290.field_1586) {
            return consumer.method_22918(matrix, x, y, 0.0f).method_22913(u, v).method_60803(light).method_22915(color.r, color.g, color.b, color.a);
        }
        if (format == class_290.field_1575) {
            return consumer.method_22918(matrix, x, y, 0.0f).method_22913(u, v).method_22915(color.r, color.g, color.b, color.a);
        }
        return consumer.method_22918(matrix, x, y, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_22913(u, v).method_22922(overlay).method_60803(light).method_60831(entry, 0.0f, 0.0f, nz);
    }
}

