/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.graphics.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import java.nio.ByteBuffer;
import mchorse.bbs_mod.graphics.texture.AnimatedTexture;
import mchorse.bbs_mod.graphics.texture.TextureFormat;
import mchorse.bbs_mod.utils.resources.Pixels;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.MemoryUtil;

@Environment(value=EnvType.CLIENT)
public class Texture {
    public int id;
    public int target = 3553;
    public int width;
    public int height;
    private boolean mipmap;
    private boolean clearable;
    private AnimatedTexture parent;
    private TextureFormat format = TextureFormat.RGBA_U8;
    private int filter;

    public static Pixels pixelsFromTexture(Texture texture) {
        if (!texture.isValid()) {
            return null;
        }
        ByteBuffer buffer = MemoryUtil.memAlloc((int)(texture.width * texture.height * 4));
        texture.bind();
        GL11.glGetTexImage((int)texture.target, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        texture.unbind();
        return new Pixels(buffer, texture.width, texture.height);
    }

    public static Texture textureFromPixels(Pixels pixels, int filter) {
        Texture texture = new Texture();
        texture.setFilter(filter);
        texture.uploadTexture(pixels);
        texture.unbind();
        return texture;
    }

    public Texture() {
        this.id = TextureUtil.generateTextureId();
        this.bind();
    }

    public void setParent(AnimatedTexture parent) {
        this.parent = parent;
    }

    public AnimatedTexture getParent() {
        return this.parent;
    }

    public void setClearable(boolean clearable) {
        this.clearable = clearable;
    }

    public boolean isClearable() {
        return this.clearable;
    }

    public TextureFormat getFormat() {
        return this.format;
    }

    public boolean isMipmap() {
        return this.mipmap;
    }

    public boolean isReallyMipmap() {
        return this.mipmap && this.getParameter(33085) > 0;
    }

    public boolean isValid() {
        return this.id >= 0;
    }

    public void bind() {
        GL11.glBindTexture((int)this.target, (int)this.id);
    }

    public void bind(int texture) {
        GlStateManager.glActiveTexture((int)texture);
        GL11.glBindTexture((int)this.target, (int)this.id);
    }

    public void unbind() {
        GL11.glBindTexture((int)this.target, (int)0);
    }

    public void unbind(int texture) {
        GlStateManager.glActiveTexture((int)texture);
        GL11.glBindTexture((int)this.target, (int)0);
    }

    public void setFormat(TextureFormat format) {
        this.format = format;
    }

    public int getFilter() {
        return this.filter;
    }

    public boolean isLinear() {
        return this.filter == 9729 || this.filter == 9985;
    }

    public int getParameter(int parameter) {
        return GL11.glGetTexParameteri((int)this.target, (int)parameter);
    }

    public void setFilterMipmap(boolean linear, boolean mipmap) {
        int filter = linear ? 9729 : 9728;
        this.setFilter(filter);
        if (!this.isMipmap()) {
            this.generateMipmap();
        }
        this.setParameter(33085, mipmap ? 4 : 0);
    }

    public void setFilter(int filter) {
        this.filter = filter;
        this.setParameter(10240, filter);
        this.setParameter(10241, filter);
    }

    public void setWrap(int mode) {
        this.setParameter(10242, mode);
        this.setParameter(10243, mode);
    }

    public void setParameter(int param, int value) {
        GL11.glTexParameteri((int)this.target, (int)param, (int)value);
    }

    public void delete() {
        GL11.glDeleteTextures((int)this.id);
        this.id = -1;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        GL11.glTexImage2D((int)this.target, (int)0, (int)this.format.internal, (int)width, (int)height, (int)0, (int)this.format.format, (int)this.format.type, (long)0L);
    }

    public void updateTexture(Pixels pixels) {
        this.updateTexture(this.target, pixels);
    }

    public void updateTexture(int target, Pixels pixels) {
        this.uploadTexture(target, 0, pixels.width, pixels.height, pixels.getBuffer());
    }

    public void uploadTexture(Pixels pixels) {
        this.uploadTexture(this.target, pixels);
    }

    public void uploadTexture(int target, Pixels pixels) {
        this.uploadTexture(target, 0, pixels);
    }

    public void uploadTexture(int target, int level, Pixels pixels) {
        GL11.glPixelStorei((int)3317, (int)1);
        this.setFormat(pixels.bits == 4 ? TextureFormat.RGBA_U8 : TextureFormat.RGB_U8);
        this.uploadTexture(target, level, pixels.width, pixels.height, pixels.getBuffer());
        pixels.delete();
    }

    public void uploadTexture(int target, int level, int w, int h, ByteBuffer buffer) {
        GL11.glPixelStorei((int)3314, (int)w);
        GL11.glPixelStorei((int)3316, (int)0);
        GL11.glPixelStorei((int)3315, (int)0);
        GL11.glTexImage2D((int)target, (int)level, (int)this.format.internal, (int)w, (int)h, (int)0, (int)this.format.format, (int)this.format.type, (ByteBuffer)buffer);
        if (level == 0) {
            this.width = w;
            this.height = h;
        }
    }

    public void generateMipmap() {
        this.mipmap = true;
        GL30.glGenerateMipmap((int)this.target);
    }
}

