/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.particles.components.appearance.colors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.ListType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.math.Constant;
import mchorse.bbs_mod.math.molang.MolangException;
import mchorse.bbs_mod.math.molang.MolangParser;
import mchorse.bbs_mod.math.molang.expressions.MolangExpression;
import mchorse.bbs_mod.math.molang.expressions.MolangValue;
import mchorse.bbs_mod.particles.components.appearance.colors.Gradient;
import mchorse.bbs_mod.particles.components.appearance.colors.Solid;
import mchorse.bbs_mod.particles.emitter.Particle;
import mchorse.bbs_mod.utils.colors.Color;
import mchorse.bbs_mod.utils.colors.Colors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class Tint {
    public static Solid parseColor(BaseType base, MolangParser parser) throws MolangException {
        MolangExpression r = MolangParser.ONE;
        MolangExpression g = MolangParser.ONE;
        MolangExpression b = MolangParser.ONE;
        MolangExpression a = MolangParser.ONE;
        if (base.isString()) {
            String hex = base.asString();
            if (hex.startsWith("#") && (hex.length() == 7 || hex.length() == 9)) {
                try {
                    int c = Colors.parseWithException(hex);
                    Color color = new Color().set(c, hex.length() == 9);
                    r = new MolangValue(parser, new Constant(color.r));
                    g = new MolangValue(parser, new Constant(color.g));
                    b = new MolangValue(parser, new Constant(color.b));
                    a = new MolangValue(parser, new Constant(color.a));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (base.isList()) {
            boolean alpha;
            ListType array = base.asList();
            boolean bl = alpha = array.size() == 4;
            if (array.size() == 3 || alpha) {
                r = parser.parseDataSilently(array.get(0), MolangParser.ONE);
                g = parser.parseDataSilently(array.get(1), MolangParser.ONE);
                b = parser.parseDataSilently(array.get(2), MolangParser.ONE);
                if (alpha) {
                    a = parser.parseDataSilently(array.get(3), MolangParser.ONE);
                }
            }
        }
        return new Solid(r, g, b, a);
    }

    public static Tint parseGradient(MapType color, MolangParser parser) throws MolangException {
        BaseType gradient = color.get("gradient");
        MolangExpression expression = MolangParser.ZERO;
        ArrayList<Gradient.ColorStop> colorStops = new ArrayList<Gradient.ColorStop>();
        boolean equal = true;
        if (gradient.isMap()) {
            for (Map.Entry<String, BaseType> entry : gradient.asMap()) {
                Solid stopColor = Tint.parseColor(entry.getValue(), parser);
                colorStops.add(new Gradient.ColorStop(Float.parseFloat(entry.getKey()), stopColor));
            }
            Collections.sort(colorStops, (a, b) -> a.stop > b.stop ? 1 : -1);
            equal = false;
        } else if (gradient.isList()) {
            ListType colors = gradient.asList();
            int i = 0;
            for (BaseType stop : colors) {
                colorStops.add(new Gradient.ColorStop((float)i / (float)(colors.size() - 1), Tint.parseColor(stop, parser)));
                ++i;
            }
        }
        if (color.has("interpolant")) {
            expression = parser.parseDataSilently(color.get("interpolant"));
        }
        return new Gradient(colorStops, expression, equal);
    }

    public abstract void compute(Particle var1);

    public abstract BaseType toData();
}

