/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.dashboard.panels;

import java.util.Collection;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.settings.values.core.ValueGroup;
import mchorse.bbs_mod.ui.ContentType;
import mchorse.bbs_mod.ui.Keys;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.dashboard.UIDashboard;
import mchorse.bbs_mod.ui.dashboard.panels.UICRUDDashboardPanel;
import mchorse.bbs_mod.ui.dashboard.panels.overlay.UICRUDOverlayPanel;
import mchorse.bbs_mod.ui.dashboard.panels.overlay.UIDataOverlayPanel;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIIcon;
import mchorse.bbs_mod.ui.utils.UIDataUtils;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.Timer;
import mchorse.bbs_mod.utils.interps.Interpolations;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class UIDataDashboardPanel<T extends ValueGroup>
extends UICRUDDashboardPanel {
    public UIIcon saveIcon;
    protected T data;
    private boolean openedBefore;
    private Timer savingTimer = new Timer(0L);

    public UIDataDashboardPanel(UIDashboard dashboard) {
        super(dashboard);
        this.saveIcon = new UIIcon(Icons.SAVED, b -> this.save());
        this.iconBar.add((IUIElement)this.saveIcon);
        UIElement savePlease = new UIElement().noCulling();
        savePlease.keys().register(Keys.SAVE, this.saveIcon::clickItself).active(() -> this.data != null);
        this.add((IUIElement)savePlease);
    }

    public T getData() {
        return this.data;
    }

    public abstract ContentType getType();

    @Override
    protected UICRUDOverlayPanel createOverlayPanel() {
        return new UIDataOverlayPanel(this.getTitle(), this, this::pickData);
    }

    @Override
    public void pickData(String id) {
        this.save();
        this.requestData(id);
    }

    public void requestData(String id) {
        this.getType().getRepository().load(id, data -> this.fill(data));
    }

    public void fill(T data) {
        this.data = data;
        this.saveIcon.setEnabled(data != null);
        this.editor.setVisible(data != null);
        this.overlay.dupe.setEnabled(data != null);
        this.overlay.rename.setEnabled(data != null);
        this.overlay.remove.setEnabled(data != null);
        this.fillData(data);
        this.savingTimer.mark((long)((Integer)BBSSettings.editorPeriodicSave.get()).intValue() * 1000L);
    }

    protected abstract void fillData(T var1);

    public void fillDefaultData(T data) {
    }

    public void fillNames(Collection<String> names) {
        String value = this.data == null ? null : ((BaseValue)this.data).getId();
        this.overlay.namesList.fill(names);
        this.overlay.namesList.setCurrentFile(value);
    }

    @Override
    public void resize() {
        super.resize();
        if (!this.openedBefore) {
            this.openOverlay.clickItself();
            this.openedBefore = true;
        }
    }

    @Override
    public void requestNames() {
        UIDataUtils.requestNames(this.getType(), this::fillNames);
    }

    public void save() {
        if (!this.update && this.data != null && this.editor.isEnabled()) {
            this.forceSave();
        }
    }

    public void forceSave() {
        this.getType().getRepository().save(((BaseValue)this.data).getId(), ((ValueGroup)this.data).toData().asMap());
    }

    @Override
    public void open() {
        super.open();
        int seconds = (Integer)BBSSettings.editorPeriodicSave.get();
        if (seconds > 0) {
            this.savingTimer.mark((long)seconds * 1000L);
        }
    }

    @Override
    public void close() {
        super.close();
        this.save();
    }

    @Override
    public void render(UIContext context) {
        if (this.data == null) {
            double ticks = (double)context.getTickTransition() % 15.0;
            double factor = Math.abs(ticks / 15.0 * 2.0 - 1.0);
            int x = this.openOverlay.area.x - 10 + (int)Interpolations.SINE_INOUT.interpolate(-10.0, 0.0, factor);
            int y = this.openOverlay.area.my();
            context.batcher.icon(Icons.ARROW_RIGHT, x, y, 0.5f, 0.5f);
        }
        super.render(context);
        if (!this.editor.isEnabled() && this.data != null) {
            this.renderLockedArea(context);
        }
        this.checkPeriodicSave(context);
    }

    private void checkPeriodicSave(UIContext context) {
        if (this.data == null) {
            return;
        }
        int seconds = (Integer)BBSSettings.editorPeriodicSave.get();
        if (seconds > 0 && this.savingTimer.check() && this.canSave(context)) {
            this.savingTimer.mark((long)seconds * 1000L);
            this.save();
            context.notifySuccess(UIKeys.PANELS_SAVED_NOTIFICATION.format(((BaseValue)this.data).getId()));
        }
    }

    protected boolean canSave(UIContext context) {
        return true;
    }
}

