/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.clips;

import mchorse.bbs_mod.camera.clips.modifiers.DragClip;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.film.IUIClipsDelegate;
import mchorse.bbs_mod.ui.film.clips.UIClip;
import mchorse.bbs_mod.ui.film.clips.widgets.UIBitToggle;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIToggle;
import mchorse.bbs_mod.ui.framework.elements.input.UITrackpad;
import mchorse.bbs_mod.ui.utils.UI;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIDragClip
extends UIClip<DragClip> {
    public UIToggle deterministic;
    public UITrackpad factor;
    public UITrackpad rate;
    public UIBitToggle active;

    public UIDragClip(DragClip clip, IUIClipsDelegate editor) {
        super(clip, editor);
    }

    @Override
    protected void registerUI() {
        super.registerUI();
        this.deterministic = new UIToggle(UIKeys.CAMERA_PANELS_DETERMINISTIC, b -> {
            ((DragClip)this.clip).deterministic.set(b.getValue());
            ((DragClip)this.clip).resetCache();
        });
        this.deterministic.tooltip(UIKeys.CAMERA_PANELS_DETERMINISTIC_TOOLTIP);
        this.factor = new UITrackpad(value -> ((DragClip)this.clip).factor.set(Float.valueOf(value.floatValue())));
        this.factor.limit(((DragClip)this.clip).factor).values(0.05f, 0.01f, 0.2f).increment(0.1f).tooltip(UIKeys.CAMERA_PANELS_FACTOR_TOOLTIP);
        this.rate = new UITrackpad(value -> ((DragClip)this.clip).rate.set(value.intValue()));
        this.rate.limit(((DragClip)this.clip).rate).tooltip(UIKeys.CAMERA_PANELS_RATE_TOOLTIP);
        this.active = new UIBitToggle(value -> {
            ((DragClip)this.clip).active.set(value);
            ((DragClip)this.clip).resetCache();
        }).all();
    }

    @Override
    protected void registerPanels() {
        super.registerPanels();
        this.panels.add((IUIElement)UI.column(UIClip.label(UIKeys.C_CLIP.get("bbs:drag")), this.deterministic).marginTop(12));
        this.panels.add(UI.column(UIClip.label(UIKeys.CAMERA_PANELS_FACTOR), this.factor).marginTop(6), this.rate, this.active);
    }

    @Override
    public void fillData() {
        super.fillData();
        this.deterministic.setValue((Boolean)((DragClip)this.clip).deterministic.get());
        this.factor.setValue(((Float)((DragClip)this.clip).factor.get()).floatValue());
        this.rate.setValue(((Integer)((DragClip)this.clip).rate.get()).intValue());
        this.active.setValue((Integer)((DragClip)this.clip).active.get());
    }
}

