/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Supplier;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.graphics.texture.Texture;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.utils.FontRenderer;
import mchorse.bbs_mod.ui.utils.Area;
import mchorse.bbs_mod.ui.utils.icons.Icon;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class Batcher2D {
    private static FontRenderer fontRenderer = new FontRenderer();
    private class_332 context;
    private FontRenderer font;

    public static FontRenderer getDefaultTextRenderer() {
        fontRenderer.setRenderer(class_310.method_1551().field_1772);
        return fontRenderer;
    }

    public Batcher2D(class_332 context) {
        this.context = context;
        this.font = Batcher2D.getDefaultTextRenderer();
    }

    public class_332 getContext() {
        return this.context;
    }

    public FontRenderer getFont() {
        return this.font;
    }

    public void clip(Area area, UIContext context) {
        this.clip(area.x, area.y, area.w, area.h, context);
    }

    public void clip(int x, int y, int w, int h, UIContext context) {
        this.clip(context.globalX(x), context.globalY(y), w, h, context.menu.width, context.menu.height);
    }

    public void clip(int x, int y, int w, int h, int sw, int sh) {
        this.context.method_44379(x, y, x + w, y + h);
    }

    public void unclip(UIContext context) {
        this.unclip(context.menu.width, context.menu.height);
    }

    public void unclip(int sw, int sh) {
        this.context.method_44380();
    }

    public void normalizedBox(float x1, float y1, float x2, float y2, int color) {
        float temp = x1;
        x1 = Math.min(x1, x2);
        x2 = Math.max(temp, x2);
        temp = y1;
        y1 = Math.min(y1, y2);
        y2 = Math.max(temp, y2);
        this.box(x1, y1, x2, y2, color);
    }

    public void box(float x1, float y1, float x2, float y2, int color) {
        this.box(x1, y1, x2 - x1, y2 - y1, color, color, color, color);
    }

    public void box(float x, float y, float w, float h, int color1, int color2, int color3, int color4) {
        Matrix4f matrix4f = this.context.method_51448().method_23760().method_23761();
        class_287 builder = new class_287(new class_9799(1536), class_293.class_5596.field_27382, class_290.field_1576);
        this.fillRect(builder, matrix4f, x, y, w, h, color1, color2, color3, color4);
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34540);
        class_286.method_43433((class_9801)builder.method_60800());
        builder = new class_287(new class_9799(1536), class_293.class_5596.field_27381, class_290.field_1576);
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34540);
        this.context.method_51452();
    }

    public void line(float x1, float y1, float x2, float y2, float thickness, int color) {
        Matrix4f matrix4f = this.context.method_51448().method_23760().method_23761();
        class_287 builder = new class_287(new class_9799(1536), class_293.class_5596.field_27382, class_290.field_1576);
        float dx = x2 - x1;
        float dy = y2 - y1;
        float len = (float)Math.sqrt(dx * dx + dy * dy);
        if (len <= 1.0E-4f) {
            this.box(x1 - thickness * 0.5f, y1 - thickness * 0.5f, x1 + thickness * 0.5f, y1 + thickness * 0.5f, color);
            return;
        }
        float nx = -dy / len;
        float ny = dx / len;
        float hw = thickness * 0.5f;
        float x1a = x1 + nx * hw;
        float y1a = y1 + ny * hw;
        float x1b = x1 - nx * hw;
        float y1b = y1 - ny * hw;
        float x2a = x2 + nx * hw;
        float y2a = y2 + ny * hw;
        float x2b = x2 - nx * hw;
        float y2b = y2 - ny * hw;
        builder.method_22918(matrix4f, x1a, y1a, 0.0f).method_39415(color);
        builder.method_22918(matrix4f, x1b, y1b, 0.0f).method_39415(color);
        builder.method_22918(matrix4f, x2b, y2b, 0.0f).method_39415(color);
        builder.method_22918(matrix4f, x2a, y2a, 0.0f).method_39415(color);
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34540);
        class_286.method_43433((class_9801)builder.method_60800());
        this.context.method_51452();
    }

    public void fillRect(class_287 builder, Matrix4f matrix4f, float x, float y, float w, float h, int color1, int color2, int color3, int color4) {
        builder.method_22918(matrix4f, x, y, 0.0f).method_39415(color1);
        builder.method_22918(matrix4f, x, y + h, 0.0f).method_39415(color3);
        builder.method_22918(matrix4f, x + w, y + h, 0.0f).method_39415(color4);
        builder.method_22918(matrix4f, x + w, y, 0.0f).method_39415(color2);
    }

    public void dropShadow(int left, int top, int right, int bottom, int offset, int opaque, int shadow) {
        right += offset;
        Matrix4f matrix4f = this.context.method_51448().method_23760().method_23761();
        class_287 builder = new class_287(new class_9799(1536), class_293.class_5596.field_27382, class_290.field_1576);
        builder.method_22918(matrix4f, (float)((left -= offset) + offset), (float)((top -= offset) + offset), 0.0f).method_39415(opaque);
        builder.method_22918(matrix4f, (float)(left + offset), (float)((bottom += offset) - offset), 0.0f).method_39415(opaque);
        builder.method_22918(matrix4f, (float)(right - offset), (float)(bottom - offset), 0.0f).method_39415(opaque);
        builder.method_22918(matrix4f, (float)(right - offset), (float)(top + offset), 0.0f).method_39415(opaque);
        builder.method_22918(matrix4f, (float)left, (float)top, 0.0f).method_39415(shadow);
        builder.method_22918(matrix4f, (float)(left + offset), (float)(top + offset), 0.0f).method_39415(opaque);
        builder.method_22918(matrix4f, (float)(right - offset), (float)(top + offset), 0.0f).method_39415(opaque);
        builder.method_22918(matrix4f, (float)right, (float)top, 0.0f).method_39415(shadow);
        builder.method_22918(matrix4f, (float)(left + offset), (float)(bottom - offset), 0.0f).method_39415(opaque);
        builder.method_22918(matrix4f, (float)left, (float)bottom, 0.0f).method_39415(shadow);
        builder.method_22918(matrix4f, (float)right, (float)bottom, 0.0f).method_39415(shadow);
        builder.method_22918(matrix4f, (float)(right - offset), (float)(bottom - offset), 0.0f).method_39415(opaque);
        builder.method_22918(matrix4f, (float)left, (float)top, 0.0f).method_39415(shadow);
        builder.method_22918(matrix4f, (float)left, (float)bottom, 0.0f).method_39415(shadow);
        builder.method_22918(matrix4f, (float)(left + offset), (float)(bottom - offset), 0.0f).method_39415(opaque);
        builder.method_22918(matrix4f, (float)(left + offset), (float)(top + offset), 0.0f).method_39415(opaque);
        builder.method_22918(matrix4f, (float)(right - offset), (float)(top + offset), 0.0f).method_39415(opaque);
        builder.method_22918(matrix4f, (float)(right - offset), (float)(bottom - offset), 0.0f).method_39415(opaque);
        builder.method_22918(matrix4f, (float)right, (float)bottom, 0.0f).method_39415(shadow);
        builder.method_22918(matrix4f, (float)right, (float)top, 0.0f).method_39415(shadow);
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34540);
        class_286.method_43433((class_9801)builder.method_60800());
    }

    public void gradientHBox(float x1, float y1, float x2, float y2, int leftColor, int rightColor) {
        this.box(x1, y1, x2 - x1, y2 - y1, leftColor, rightColor, leftColor, rightColor);
    }

    public void gradientVBox(float x1, float y1, float x2, float y2, int topColor, int bottomColor) {
        this.box(x1, y1, x2 - x1, y2 - y1, topColor, topColor, bottomColor, bottomColor);
    }

    public void dropCircleShadow(int x, int y, int radius, int segments, int opaque, int shadow) {
        Matrix4f matrix4f = this.context.method_51448().method_23760().method_23761();
        class_287 builder = new class_287(new class_9799(1536), class_293.class_5596.field_27381, class_290.field_1576);
        builder.method_22918(matrix4f, (float)x, (float)y, 0.0f).method_39415(opaque);
        for (int i = 0; i <= segments; ++i) {
            double a = (double)i / (double)segments * Math.PI * 2.0 - 1.5707963267948966;
            builder.method_22918(matrix4f, (float)((double)x - Math.cos(a) * (double)radius), (float)((double)y + Math.sin(a) * (double)radius), 0.0f).method_39415(shadow);
        }
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34540);
        class_286.method_43433((class_9801)builder.method_60800());
    }

    public void dropCircleShadow(int x, int y, int radius, int offset, int segments, int opaque, int shadow) {
        if (offset >= radius) {
            this.dropCircleShadow(x, y, radius, segments, opaque, shadow);
            return;
        }
        Matrix4f matrix4f = this.context.method_51448().method_23760().method_23761();
        class_287 builder = new class_287(new class_9799(1536), class_293.class_5596.field_27381, class_290.field_1576);
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34540);
        builder.method_22918(matrix4f, (float)x, (float)y, 0.0f).method_39415(opaque);
        for (int i = 0; i <= segments; ++i) {
            double a = (double)i / (double)segments * Math.PI * 2.0 - 1.5707963267948966;
            builder.method_22918(matrix4f, (float)((int)((double)x - Math.cos(a) * (double)offset)), (float)((int)((double)y + Math.sin(a) * (double)offset)), 0.0f).method_39415(opaque);
        }
        class_286.method_43433((class_9801)builder.method_60800());
        class_287 builder2 = new class_287(new class_9799(1536), class_293.class_5596.field_27379, class_290.field_1576);
        for (int i = 0; i < segments; ++i) {
            double alpha1 = (double)i / (double)segments * Math.PI * 2.0 - 1.5707963267948966;
            double alpha2 = (double)(i + 1) / (double)segments * Math.PI * 2.0 - 1.5707963267948966;
            builder2.method_22918(matrix4f, (float)((double)x - Math.cos(alpha2) * (double)offset), (float)((double)y + Math.sin(alpha2) * (double)offset), 0.0f).method_39415(opaque);
            builder2.method_22918(matrix4f, (float)((double)x - Math.cos(alpha1) * (double)offset), (float)((double)y + Math.sin(alpha1) * (double)offset), 0.0f).method_39415(opaque);
            builder2.method_22918(matrix4f, (float)((double)x - Math.cos(alpha1) * (double)radius), (float)((double)y + Math.sin(alpha1) * (double)radius), 0.0f).method_39415(shadow);
            builder2.method_22918(matrix4f, (float)((double)x - Math.cos(alpha2) * (double)offset), (float)((double)y + Math.sin(alpha2) * (double)offset), 0.0f).method_39415(opaque);
            builder2.method_22918(matrix4f, (float)((double)x - Math.cos(alpha1) * (double)radius), (float)((double)y + Math.sin(alpha1) * (double)radius), 0.0f).method_39415(shadow);
            builder2.method_22918(matrix4f, (float)((double)x - Math.cos(alpha2) * (double)radius), (float)((double)y + Math.sin(alpha2) * (double)radius), 0.0f).method_39415(shadow);
        }
        class_286.method_43433((class_9801)builder2.method_60800());
    }

    public void outlineCenter(float x, float y, float offset, int color) {
        this.outlineCenter(x, y, offset, color, 1);
    }

    public void outlineCenter(float x, float y, float offset, int color, int border) {
        this.outline(x - offset, y - offset, x + offset, y + offset, color, border);
    }

    public void outline(float x1, float y1, float x2, float y2, int color) {
        this.outline(x1, y1, x2, y2, color, 1);
    }

    public void outline(float x1, float y1, float x2, float y2, int color, int border) {
        this.box(x1, y1, x1 + (float)border, y2, color);
        this.box(x2 - (float)border, y1, x2, y2, color);
        this.box(x1 + (float)border, y1, x2 - (float)border, y1 + (float)border, color);
        this.box(x1 + (float)border, y2 - (float)border, x2 - (float)border, y2, color);
    }

    public void icon(Icon icon, float x, float y) {
        this.icon(icon, -1, x, y);
    }

    public void icon(Icon icon, int color, float x, float y) {
        this.icon(icon, color, x, y, 0.0f, 0.0f);
    }

    public void icon(Icon icon, float x, float y, float ax, float ay) {
        this.icon(icon, -1, x, y, ax, ay);
    }

    public void icon(Icon icon, int color, float x, float y, float ax, float ay) {
        if (icon.texture == null) {
            return;
        }
        this.texturedBox(BBSModClient.getTextures().getTexture(icon.texture), color, x -= (float)icon.w * ax, y -= (float)icon.h * ay, (float)icon.w, (float)icon.h, (float)icon.x, (float)icon.y, (float)(icon.x + icon.w), (float)(icon.y + icon.h), icon.textureW, icon.textureH);
    }

    public void iconArea(Icon icon, float x, float y, float w, float h) {
        this.iconArea(icon, -1, x, y, w, h);
    }

    public void iconArea(Icon icon, int color, float x, float y, float w, float h) {
        this.texturedArea(BBSModClient.getTextures().getTexture(icon.texture), color, x, y, w, h, icon.x, icon.y, icon.w, icon.h, icon.textureW, icon.textureH);
    }

    public void outlinedIcon(Icon icon, float x, float y, float ax, float ay) {
        this.outlinedIcon(icon, x, y, -1, ax, ay);
    }

    public void outlinedIcon(Icon icon, float x, float y, int color, float ax, float ay) {
        this.icon(icon, -16777216, x - 1.0f, y, ax, ay);
        this.icon(icon, -16777216, x + 1.0f, y, ax, ay);
        this.icon(icon, -16777216, x, y - 1.0f, ax, ay);
        this.icon(icon, -16777216, x, y + 1.0f, ax, ay);
        this.icon(icon, color, x, y, ax, ay);
    }

    public void fullTexturedBox(Texture texture, float x, float y, float w, float h) {
        this.fullTexturedBox(texture, -1, x, y, w, h);
    }

    public void fullTexturedBox(Texture texture, int color, float x, float y, float w, float h) {
        this.texturedBox(texture, color, x, y, w, h, 0.0f, 0.0f, w, h, (int)w, (int)h);
    }

    public void texturedBox(Texture texture, int color, float x, float y, float w, float h, float u1, float v1, float u2, float v2) {
        this.texturedBox(texture, color, x, y, w, h, u1, v1, u2, v2, texture.width, texture.height);
    }

    public void texturedBox(Texture texture, int color, float x, float y, float w, float h, float u, float v) {
        this.texturedBox(texture, color, x, y, w, h, u, v, u + w, v + h, texture.width, texture.height);
    }

    public void texturedBox(Texture texture, int color, float x, float y, float w, float h, float u1, float v1, float u2, float v2, int textureW, int textureH) {
        RenderSystem.setShaderTexture((int)0, (int)texture.id);
        Matrix4f matrix = this.context.method_51448().method_23760().method_23761();
        class_287 builder = new class_287(new class_9799(1536), class_293.class_5596.field_27379, class_290.field_1575);
        RenderSystem.setShader(class_757::method_34543);
        this.fillTexturedBox(builder, matrix, color, x, y, w, h, u1, v1, u2, v2, textureW, textureH);
        class_286.method_43433((class_9801)builder.method_60800());
    }

    public void texturedBox(int texture, int color, float x, float y, float w, float h, float u1, float v1, float u2, float v2, int textureW, int textureH) {
        this.texturedBox(class_757::method_34543, texture, color, x, y, w, h, u1, v1, u2, v2, textureW, textureH);
    }

    public void texturedBox(Supplier<class_5944> shader, int texture, int color, float x, float y, float w, float h, float u1, float v1, float u2, float v2, int textureW, int textureH) {
        RenderSystem.setShaderTexture((int)0, (int)texture);
        Matrix4f matrix = this.context.method_51448().method_23760().method_23761();
        class_287 builder = new class_287(new class_9799(1536), class_293.class_5596.field_27379, class_290.field_1575);
        RenderSystem.setShader(shader);
        this.fillTexturedBox(builder, matrix, color, x, y, w, h, u1, v1, u2, v2, textureW, textureH);
        class_286.method_43433((class_9801)builder.method_60800());
    }

    private void fillTexturedBox(class_287 builder, Matrix4f matrix, int color, float x, float y, float w, float h, float u1, float v1, float u2, float v2, int textureW, int textureH) {
        builder.method_22918(matrix, x, y + h, 0.0f).method_22913(u1 / (float)textureW, v2 / (float)textureH).method_39415(color);
        builder.method_22918(matrix, x + w, y + h, 0.0f).method_22913(u2 / (float)textureW, v2 / (float)textureH).method_39415(color);
        builder.method_22918(matrix, x + w, y, 0.0f).method_22913(u2 / (float)textureW, v1 / (float)textureH).method_39415(color);
        builder.method_22918(matrix, x, y + h, 0.0f).method_22913(u1 / (float)textureW, v2 / (float)textureH).method_39415(color);
        builder.method_22918(matrix, x + w, y, 0.0f).method_22913(u2 / (float)textureW, v1 / (float)textureH).method_39415(color);
        builder.method_22918(matrix, x, y, 0.0f).method_22913(u1 / (float)textureW, v1 / (float)textureH).method_39415(color);
    }

    public void texturedArea(Texture texture, int color, float x, float y, float w, float h, float u, float v, float tileW, float tileH, int tw, int th) {
        int countX = (int)((w - 1.0f) / tileW + 1.0f);
        int countY = (int)((h - 1.0f) / tileH + 1.0f);
        float fillerX = w - (float)(countX - 1) * tileW;
        float fillerY = h - (float)(countY - 1) * tileH;
        Matrix4f matrix = this.context.method_51448().method_23760().method_23761();
        class_287 builder = new class_287(new class_9799(1536), class_293.class_5596.field_27379, class_290.field_1575);
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture((int)0, (int)texture.id);
        int c = countX * countY;
        for (int i = 0; i < c; ++i) {
            float ix = i % countX;
            float iy = i / countX;
            float xx = x + ix * tileW;
            float yy = y + iy * tileH;
            float xw = ix == (float)(countX - 1) ? fillerX : tileW;
            float yh = iy == (float)(countY - 1) ? fillerY : tileH;
            this.fillTexturedBox(builder, matrix, color, xx, yy, xw, yh, u, v, u + xw, v + yh, tw, th);
        }
        class_286.method_43433((class_9801)builder.method_60800());
    }

    public void text(String label, float x, float y, int color) {
        this.text(label, x, y, color, false);
    }

    public void text(String label, float x, float y) {
        this.text(label, x, y, -1, false);
    }

    public void textShadow(String label, float x, float y) {
        this.text(label, x, y, -1, true);
    }

    public void textShadow(String label, float x, float y, int color) {
        this.text(label, x, y, color, true);
    }

    public void text(String label, float x, float y, int color, boolean shadow) {
        this.context.method_51433(this.font.getRenderer(), label, (int)x, (int)y, color, shadow);
        this.context.method_51452();
        RenderSystem.depthFunc((int)519);
    }

    public int wallText(String text, int x, int y, int color, int width) {
        return this.wallText(text, x, y, color, width, 12);
    }

    public int wallText(String text, int x, int y, int color, int width, int lineHeight) {
        return this.wallText(text, x, y, color, width, lineHeight, 0.0f, 0.0f);
    }

    public int wallText(String text, int x, int y, int color, int width, int lineHeight, float ax, float ay) {
        List<String> list = this.font.wrap(text, width);
        int h = lineHeight * (list.size() - 1) + this.font.getHeight();
        y = (int)((float)y - (float)h * ay);
        for (String string : list) {
            this.text(string.toString(), (int)((float)x + (float)(width - this.font.getWidth(string)) * ax), y, color, true);
            y += lineHeight;
        }
        return h;
    }

    public void textCard(String text, float x, float y) {
        this.textCard(text, x, y, -1, -2013265920);
    }

    public void textCard(String text, float x, float y, int color, int background) {
        this.textCard(text, x, y, color, background, 3.0f);
    }

    public void textCard(String text, float x, float y, int color, int background, float offset) {
        this.textCard(text, x, y, color, background, offset, true);
    }

    public void textCard(String text, float x, float y, int color, int background, float offset, boolean shadow) {
        int a = background >> 24 & 0xFF;
        if (a != 0) {
            this.box(x - offset, y - offset, x + (float)this.font.getWidth(text) + offset - 1.0f, y + (float)this.font.getHeight() + offset, background);
        }
        this.text(text, x, y, color, shadow);
    }

    public void flush() {
        this.context.method_51452();
    }
}

