/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.utils;

import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.utils.Batcher2D;
import mchorse.bbs_mod.ui.utils.Scroll;
import mchorse.bbs_mod.ui.utils.resizers.IResizer;
import mchorse.bbs_mod.utils.MathUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class Area
implements IResizer {
    public static final Area SHARED = new Area();
    public int x;
    public int y;
    public int w;
    public int h;
    public Scroll scroll;

    public Area() {
    }

    public Area(Area area) {
        this.copy(area);
    }

    public Area(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    public int getIndex(int x, int y, int size) {
        return MathUtils.gridIndex(x - this.x, y - this.y, size, this.w);
    }

    public int getRows(int count, int size) {
        return MathUtils.gridRows(count, size, this.w);
    }

    public boolean isInside(UIContext context) {
        return this.isInside(context.mouseX, context.mouseY);
    }

    public boolean isInside(int x, int y) {
        return MathUtils.isInside(this.x, this.x + this.w, x, x) && MathUtils.isInside(this.y, this.y + this.h, y, y);
    }

    public boolean intersects(Area area) {
        return MathUtils.isInside(this.x, this.x + this.w, area.x, area.x + area.w) && MathUtils.isInside(this.y, this.y + this.h, area.y, area.y + area.h);
    }

    public void clamp(Area area) {
        int x1 = area.x;
        int y1 = area.y;
        int x2 = area.ex();
        int y2 = area.ey();
        x1 = MathUtils.clamp(x1, this.x, this.ex());
        y1 = MathUtils.clamp(y1, this.y, this.ey());
        x2 = MathUtils.clamp(x2, this.x, this.ex());
        y2 = MathUtils.clamp(y2, this.y, this.ey());
        area.setPoints(x1, y1, x2, y2);
    }

    public void offset(int offset) {
        this.offsetX(offset);
        this.offsetY(offset);
    }

    public void offsetX(int offset) {
        this.x -= offset;
        this.w += offset * 2;
    }

    public void offsetY(int offset) {
        this.y -= offset;
        this.h += offset * 2;
    }

    public void set(int x, int y, int w, int h) {
        this.setPos(x, y);
        this.setSize(w, h);
    }

    public void setPos(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setSize(int w, int h) {
        this.w = w;
        this.h = h;
    }

    public void setPoints(int x1, int y1, int x2, int y2) {
        this.setPoints(x1, y1, x2, y2, 0);
    }

    public void setPoints(int x1, int y1, int x2, int y2, int offset) {
        int mx = Math.max(x1, x2);
        int my = Math.max(y1, y2);
        int nx = Math.min(x1, x2);
        int ny = Math.min(y1, y2);
        this.x = nx - offset;
        this.y = ny - offset;
        this.w = mx - nx + offset;
        this.h = my - ny + offset;
    }

    public void copy(Area area) {
        this.x = area.x;
        this.y = area.y;
        this.w = area.w;
        this.h = area.h;
    }

    public int x(float anchor) {
        return this.x + (int)((float)this.w * anchor);
    }

    public int x(float anchor, int value) {
        return this.x + (int)((float)(this.w - value) * anchor);
    }

    public int mx() {
        return this.x(0.5f);
    }

    public int mx(int value) {
        return this.x(0.5f, value);
    }

    public int ex() {
        return this.x + this.w;
    }

    public int y(float anchor) {
        return this.y + (int)((float)this.h * anchor);
    }

    public int y(float anchor, int value) {
        return this.y + (int)((float)(this.h - value) * anchor);
    }

    public int my() {
        return this.y(0.5f);
    }

    public int my(int value) {
        return this.y(0.5f, value);
    }

    public int ey() {
        return this.y + this.h;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Area) {
            Area area = (Area)obj;
            return this.x == area.x && this.y == area.y && this.w == area.w && this.h == area.h;
        }
        return super.equals(obj);
    }

    public void render(Batcher2D batcher, int color) {
        this.render(batcher, color, 0, 0, 0, 0);
    }

    public void render(Batcher2D batcher, int color, int offset) {
        this.render(batcher, color, offset, offset, offset, offset);
    }

    public void render(Batcher2D batcher, int color, int horizontal, int vertical) {
        this.render(batcher, color, horizontal, vertical, horizontal, vertical);
    }

    public void render(Batcher2D batcher, int color, int lx, int ty, int rx, int by) {
        batcher.box(this.x + lx, this.y + ty, this.ex() - rx, this.ey() - by, color);
    }

    @Override
    public void preApply(Area area) {
    }

    @Override
    public void apply(Area area) {
        area.copy(this);
    }

    @Override
    public void postApply(Area area) {
    }

    @Override
    public void add(UIElement parent, UIElement child) {
    }

    @Override
    public void remove(UIElement parent, UIElement child) {
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getW() {
        return this.w;
    }

    @Override
    public int getH() {
        return this.h;
    }

    public String toString() {
        return this.x + " " + this.y + " " + this.w + " " + this.h;
    }
}

