/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.utils;

import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.utils.Batcher2D;
import mchorse.bbs_mod.ui.utils.Area;
import mchorse.bbs_mod.ui.utils.ScrollDirection;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.colors.Colors;
import mchorse.bbs_mod.utils.interps.Lerps;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class Scroll {
    private static Area temporary = new Area();
    public int scrollItemSize;
    public int scrollSize;
    private double scroll;
    public boolean dragging;
    public int scrollSpeed = 10;
    public ScrollDirection direction = ScrollDirection.VERTICAL;
    public boolean opposite;
    public boolean cancelScrollEdge = false;
    public boolean scrollbar = true;
    public final Area area;
    private float scrollbarRatio;
    private double targetScroll;

    public static void bar(Batcher2D batcher, int x1, int y1, int x2, int y2, int color) {
        if (x2 - x1 == 0 || y2 - y1 == 0) {
            return;
        }
        batcher.dropShadow(x1, y1, x2, y2, 5, color, Colors.setA(color, 0.0f));
        batcher.box(x1, y1, x2, y2, -1118482);
        batcher.box(x1 + 1, y1 + 1, x2, y2, -10066330);
        batcher.box(x1 + 1, y1 + 1, x2 - 1, y2 - 1, -5592406);
        int dx = x2 - x1;
        int dy = y2 - y1;
        if (dx + dy < 30) {
            return;
        }
        int x = (x2 + x1) / 2;
        int y = (y2 + y1) / 2;
        if (dx > dy) {
            batcher.box(x - 3, y - 1, x - 2, y + 1, -7829368);
            batcher.box(x, y - 1, x + 1, y + 1, -7829368);
            batcher.box(x + 3, y - 1, x + 4, y + 1, -7829368);
        } else {
            batcher.box(x - 1, y - 3, x + 1, y - 2, -7829368);
            batcher.box(x - 1, y, x + 1, y + 1, -7829368);
            batcher.box(x - 1, y + 3, x + 1, y + 4, -7829368);
        }
    }

    public Scroll(Area area) {
        this.area = area;
        this.area.scroll = this;
    }

    public Scroll(Area area, int itemSize) {
        this(area);
        this.scrollItemSize = itemSize;
    }

    public Scroll(Area area, int itemSize, ScrollDirection direction) {
        this(area, itemSize);
        this.direction = direction;
    }

    public Scroll cancelScrolling() {
        this.cancelScrollEdge = true;
        return this;
    }

    public Scroll opposite() {
        this.opposite = true;
        return this;
    }

    public Scroll noScrollbar() {
        this.scrollbar = false;
        return this;
    }

    public int getScrollbarWidth() {
        return (Integer)BBSSettings.scrollbarWidth.get();
    }

    public void setSize(int items) {
        this.scrollSize = items * this.scrollItemSize;
    }

    public double getScroll() {
        return this.scroll;
    }

    public void setScroll(double x) {
        this.scroll = this.targetScroll = x;
        this.clamp();
    }

    public void scrollBy(double x) {
        this.scrollTo(this.targetScroll + x);
    }

    public void scrollTo(double x) {
        this.targetScroll = x;
        this.clamp();
    }

    public void scrollToEnd() {
        this.setScroll(2.147483647E9);
    }

    public void scrollIntoView(int x) {
        this.scrollIntoView(x, this.scrollItemSize, 0);
    }

    public void scrollIntoView(int x, int bottomOffset) {
        this.scrollIntoView(x, bottomOffset, 0);
    }

    public void scrollIntoView(int x, int bottomOffset, int topOffset) {
        if (this.scroll + (double)topOffset > (double)x) {
            this.scrollTo(x - topOffset);
        } else if ((double)x > this.scroll + (double)this.direction.getSide(this.area) - (double)bottomOffset) {
            this.scrollTo(x - this.direction.getSide(this.area) + bottomOffset);
        }
    }

    public void clamp() {
        int size = this.direction.getSide(this.area);
        if (this.scrollSize <= size) {
            this.targetScroll = 0.0;
            this.scroll = 0.0;
        } else {
            this.scroll = MathUtils.clamp(this.scroll, 0.0, (double)(this.scrollSize - size));
            this.targetScroll = MathUtils.clamp(this.targetScroll, 0.0, (double)(this.scrollSize - size));
        }
    }

    public void updateTarget() {
        this.scroll = this.targetScroll;
    }

    public void copy(Scroll scroll) {
        this.scroll = scroll.scroll;
        this.targetScroll = scroll.targetScroll;
        this.scrollSize = scroll.scrollSize;
    }

    public int getIndex(int x, int y) {
        int axis = this.direction.getScroll(this.area, this, x, y);
        int index = axis / this.scrollItemSize;
        if (axis < 0) {
            return -1;
        }
        if (axis > this.scrollSize) {
            return -2;
        }
        return index > this.scrollSize / this.scrollItemSize ? -1 : index;
    }

    public boolean hasScrollbar() {
        return this.scrollSize > this.direction.getSide(this.area);
    }

    public int getScrollbar() {
        int maxSize = this.direction.getSide(this.area);
        if (this.scrollSize < maxSize) {
            return 0;
        }
        float finalSize = (1.0f - (float)(this.scrollSize - maxSize) / (float)this.scrollSize) * (float)maxSize;
        return Math.max(4, (int)finalSize);
    }

    public Area getScrollArea() {
        int maxSize = this.direction.getSide(this.area);
        if (this.scrollSize < maxSize) {
            temporary.set(0, 0, 0, 0);
        } else {
            int width = this.getScrollbarWidth();
            if (this.direction == ScrollDirection.VERTICAL) {
                temporary.set(this.area.x + (this.opposite ? 0 : this.area.w - width), this.area.y, width, this.area.h);
            } else {
                temporary.set(this.area.x, this.area.y + (this.opposite ? 0 : this.area.h - width), this.area.w, width);
            }
        }
        return temporary;
    }

    public Area getScrollbarArea() {
        int maxSize = this.direction.getSide(this.area);
        if (this.scrollSize < maxSize) {
            temporary.set(0, 0, 0, 0);
        } else {
            int scrollbar = this.getScrollbarWidth();
            int h = this.getScrollbar();
            if (this.direction == ScrollDirection.HORIZONTAL) {
                int y = this.opposite ? this.area.y : this.area.ey() - scrollbar;
                int x = this.area.x + (int)(this.scroll / (double)(this.scrollSize - this.area.w) * (double)(this.area.w - h));
                temporary.set(x, y, h, scrollbar);
            } else {
                int x = this.opposite ? this.area.x : this.area.ex() - scrollbar;
                int y = this.area.y + (int)(this.scroll / (double)(this.scrollSize - this.area.h) * (double)(this.area.h - h));
                temporary.set(x, y, scrollbar, h);
            }
        }
        return temporary;
    }

    public boolean mouseClicked(UIContext context) {
        return context.mouseButton == 0 && this.mouseClicked(context.mouseX, context.mouseY);
    }

    public boolean mouseClicked(int x, int y) {
        boolean isInside;
        if (!this.scrollbar) {
            return false;
        }
        boolean bl = isInside = this.hasScrollbar() && this.getScrollArea().isInside(x, y);
        if (isInside) {
            this.dragging = true;
            Area area = this.getScrollbarArea();
            this.scrollbarRatio = area.isInside(x, y) ? (this.direction.getMouse(x, y) - (float)this.direction.getPosition(area, 0.0f)) / (float)this.direction.getSide(area) : 0.5f;
        }
        return isInside;
    }

    public boolean mouseScroll(UIContext context) {
        boolean canceled = this.mouseScroll(context.mouseX, context.mouseY, context.mouseWheel);
        if (canceled) {
            context.markUpdateScroll();
        }
        return canceled;
    }

    public boolean mouseScroll(int x, int y, double scroll) {
        scroll = -scroll;
        boolean isInside = this.area.isInside(x, y);
        double lastScroll = this.targetScroll;
        if (isInside) {
            if (class_310.field_1703) {
                this.scrollBy(scroll * (double)((Float)BBSSettings.scrollingSensitivity.get()).floatValue());
            } else if (scroll != 0.0) {
                this.scrollBy((int)(Math.copySign((double)this.scrollSpeed, scroll) * (double)((Float)BBSSettings.scrollingSensitivity.get()).floatValue()));
            }
        }
        return isInside && (this.cancelScrollEdge && this.scrollSize > this.direction.getSide(this.area) || lastScroll != this.targetScroll);
    }

    public void mouseReleased(UIContext context) {
        this.mouseReleased(context.mouseX, context.mouseY);
    }

    public void mouseReleased(int x, int y) {
        this.dragging = false;
    }

    public void drag(UIContext context) {
        this.drag(context.mouseX, context.mouseY);
    }

    public void drag(int x, int y) {
        if (((Boolean)BBSSettings.scrollingSmoothness.get()).booleanValue()) {
            float delta = class_310.method_1551().method_60646().method_60636();
            this.scroll = Lerps.lerp(this.scroll, this.targetScroll, (double)Math.min(1.0f, delta / 2.5f));
        } else {
            this.scroll = this.targetScroll;
        }
        if (this.dragging) {
            int scrollbar = this.getScrollbar();
            int h = this.direction.getSide(this.area) - scrollbar;
            float progress = (this.direction.getMouse(x, y) - ((float)this.direction.getPosition(this.area, 0.0f) + (float)scrollbar * this.scrollbarRatio)) / (float)h;
            float to = progress * (float)(this.scrollSize - this.direction.getSide(this.area));
            this.scrollTo(to);
        }
    }

    public void renderScrollbar(Batcher2D batcher) {
        if (!this.hasScrollbar()) {
            return;
        }
        int side = this.direction.getSide(this.area);
        int shadow = Colors.mulRGB(0x88000000 | (Integer)BBSSettings.primaryColor.get(), 0.75f);
        if (this.scrollbar) {
            Area scrollbar = this.getScrollbarArea();
            int color = (Integer)BBSSettings.scrollbarShadow.get();
            Scroll.bar(batcher, scrollbar.x, scrollbar.y, scrollbar.ex(), scrollbar.ey(), color);
        } else if (this.direction == ScrollDirection.VERTICAL) {
            if (this.scroll > 0.0) {
                batcher.gradientVBox(this.area.x, this.area.y, this.area.ex(), this.area.y + 20, shadow, 0);
            }
            if (this.scroll < (double)(this.scrollSize - side)) {
                batcher.gradientVBox(this.area.x, this.area.ey() - 20, this.area.ex(), this.area.ey(), 0, shadow);
            }
        } else if (this.direction == ScrollDirection.HORIZONTAL) {
            if (this.scroll > 0.0) {
                batcher.gradientHBox(this.area.x, this.area.y, this.area.x + 20, this.area.ey(), shadow, 0);
            }
            if (this.scroll < (double)(this.scrollSize - side)) {
                batcher.gradientHBox(this.area.ex() - 20, this.area.y, this.area.ex(), this.area.ey(), 0, shadow);
            }
        }
    }
}

