/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.minecraft.class_5481;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector4d;
import org.joml.Vector4f;

public class StringUtils {
    public static boolean isInteger(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isDigit(c) || i == 0 && c == '-') continue;
            return false;
        }
        return true;
    }

    public static String plainText(class_5481 text) {
        StringBuilder builder = new StringBuilder();
        text.accept((index, style, c) -> {
            builder.append((char)c);
            return true;
        });
        return builder.toString();
    }

    public static String createTimestampFilename() {
        return new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
    }

    public static String combinePaths(String a, String b) {
        return StringUtils.combinePaths(a, b, "/");
    }

    public static String combinePaths(String a, String b, String delimeter) {
        return a.isEmpty() ? b : (String)(a.endsWith(delimeter) ? a : a + delimeter) + b;
    }

    public static String leftPad(String input, int totalLength, String pad) {
        return StringUtils.repeat(pad, totalLength - input.length()) + input;
    }

    public static String rightPad(String input, int totalLength, String pad) {
        return input + StringUtils.repeat(pad, totalLength - input.length());
    }

    public static String repeat(String string, int total) {
        if (total <= 0 || string.isEmpty()) {
            return "";
        }
        int length = string.length();
        if (total < length) {
            return string.substring(0, total);
        }
        StringBuilder builder = new StringBuilder();
        while (total >= 0) {
            builder.append(total < length ? string.substring(0, total) : string);
            total -= length;
        }
        return builder.toString();
    }

    public static int countMatches(String string, String match) {
        int c = 0;
        int i = 0;
        while (i != -1) {
            i = string.indexOf(match, i + 1);
            ++c;
        }
        return c;
    }

    public static int parseHex(String string) {
        return StringUtils.parseHex(string.toCharArray());
    }

    public static int parseHex(char[] chars) {
        int result = 0;
        int length = chars.length;
        if (length > 8) {
            throw new NumberFormatException("Given string \"" + new String(chars) + "\" is longer than 8 symbols...");
        }
        for (int i = 0; i < length; ++i) {
            char letter = chars[length - 1 - i];
            int value = StringUtils.hexCharToInt(letter);
            if (value < 0) {
                throw new NumberFormatException("Given string \"" + new String(chars) + "\" isn't a hex number...");
            }
            result |= value << i * 4;
        }
        return result;
    }

    public static int hexCharToInt(char character) {
        if (character >= '0' && character <= '9') {
            return character - 48;
        }
        if (character >= 'a' && character <= 'f') {
            return character - 97 + 10;
        }
        if (character >= 'A' && character <= 'F') {
            return character - 65 + 10;
        }
        return -1;
    }

    public static String removeExtension(String path) {
        int lastDot = path.lastIndexOf(46);
        return lastDot >= 0 ? path.substring(0, lastDot) : path;
    }

    public static String extension(String path) {
        int lastDot = path.lastIndexOf(46);
        return lastDot >= 0 ? path.substring(lastDot + 1) : "";
    }

    public static String replaceExtension(String path, String extension) {
        path = StringUtils.removeExtension((String)path);
        path = (String)path + "." + extension;
        return path;
    }

    public static String fileName(String path) {
        int lastSlash = path.endsWith("/") ? path.lastIndexOf(47, path.length() - 2) : path.lastIndexOf(47);
        return lastSlash >= 0 ? path.substring(lastSlash + 1) : path;
    }

    public static String parentPath(String path) {
        int lastSlash = path.endsWith("/") ? path.lastIndexOf(47, path.length() - 2) : path.lastIndexOf(47);
        return lastSlash >= 0 ? path.substring(0, lastSlash) : "";
    }

    public static String processColoredText(String text) {
        if (!text.contains("[")) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        int c = text.length();
        for (int i = 0; i < c; ++i) {
            char character = text.charAt(i);
            if (character == '\\' && i < c - 1 && text.charAt(i + 1) == '[') {
                builder.append('[');
                ++i;
                continue;
            }
            builder.append(character == '[' ? "\u00a7" : Character.valueOf(character));
        }
        return builder.toString();
    }

    public static String findCommonPrefix(List<String> strings) {
        if (strings == null || strings.isEmpty()) {
            return "";
        }
        String shortest = strings.get(0);
        for (String s : strings) {
            if (s.length() >= shortest.length()) continue;
            shortest = s;
        }
        for (int i = 0; i < shortest.length(); ++i) {
            char currentChar = shortest.charAt(i);
            for (String s : strings) {
                if (s.charAt(i) == currentChar) continue;
                return shortest.substring(0, i);
            }
        }
        return shortest;
    }

    public static String vector4fToString(Vector4f vector) {
        return "(" + vector.x + ", " + vector.y + ", " + vector.z + ", " + vector.w + ")";
    }

    public static String vector3fToString(Vector3f vector) {
        return "(" + vector.x + ", " + vector.y + ", " + vector.z + ")";
    }

    public static String vector4dToString(Vector4d vector) {
        return "(" + vector.x + ", " + vector.y + ", " + vector.z + ", " + vector.w + ")";
    }

    public static String vector3dToString(Vector3d vector) {
        return "(" + vector.x + ", " + vector.y + ", " + vector.z + ")";
    }
}

