/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.presets;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.data.DataToString;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.utils.IOUtils;

public abstract class DataManager {
    private MapType data = new MapType();

    public void clear() {
        this.data = new MapType();
    }

    public MapType getData(String group) {
        if (this.data.has(group)) {
            return this.data.getMap(group);
        }
        MapType newData = new MapType();
        try (InputStream stream2 = BBSMod.getProvider().getAsset(this.getFile(group));){
            newData = DataToString.mapFromString(IOUtils.readText(stream2));
        }
        catch (FileNotFoundException stream2) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.data.put(group, newData);
        return newData;
    }

    public void saveData(String group, String key, MapType pose) {
        if (group.isEmpty()) {
            System.err.println("Can't save empty pose group!");
            return;
        }
        MapType newPoses = this.data.getMap(group);
        newPoses.put(key, pose);
        File file = BBSMod.getProvider().getFile(this.getFile(group));
        if (file != null) {
            file.getParentFile().mkdirs();
            DataToString.writeSilently(file, newPoses, true);
        }
    }

    protected abstract Link getFile(String var1);
}

