/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.audio;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mchorse.bbs_mod.BBSMod;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public class AudioCacheManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_CACHE_FILES = 30;
    private static AudioCacheManager INSTANCE;
    private final File cacheDir = BBSMod.getAudioCacheFolder();
    private final Map<String, File> cachedFiles = new HashMap<String, File>();

    private AudioCacheManager() {
        if (!this.cacheDir.exists() && !this.cacheDir.mkdirs()) {
            LOGGER.error("Failed to create audio cache directory: " + this.cacheDir.getAbsolutePath());
        }
    }

    public static AudioCacheManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AudioCacheManager();
        }
        return INSTANCE;
    }

    public File createTempCacheFile(String soundPath) throws IOException {
        String flattenedPath;
        String fileName;
        File cacheFile;
        if (this.cachedFiles.size() >= 30) {
            this.cleanupExcessCache();
        }
        if ((cacheFile = new File(this.cacheDir, fileName = (flattenedPath = soundPath.replace("/", "_").replace("\\", "_")).endsWith(".ogg") ? "preview_" + flattenedPath : "preview_" + flattenedPath + ".ogg")).exists() && !cacheFile.delete()) {
            LOGGER.warn("Failed to delete existing cache file: " + cacheFile.getAbsolutePath());
        }
        this.cachedFiles.put(soundPath, cacheFile);
        return cacheFile;
    }

    public File getCachedFile(String soundPath) {
        File cachedFile = this.cachedFiles.get(soundPath);
        if (cachedFile != null && cachedFile.exists()) {
            return cachedFile;
        }
        if (cachedFile != null) {
            this.cachedFiles.remove(soundPath);
        }
        return null;
    }

    public void clearAllCache() {
        File[] files;
        int deletedCount = 0;
        int failedCount = 0;
        if (this.cacheDir.exists() && this.cacheDir.isDirectory() && (files = this.cacheDir.listFiles()) != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                if (file.delete()) {
                    ++deletedCount;
                    continue;
                }
                ++failedCount;
                LOGGER.warn("Failed to delete cache file: " + file.getAbsolutePath());
            }
        }
        this.cachedFiles.clear();
        if (deletedCount > 0 || failedCount > 0) {
            LOGGER.info("Cleared audio cache - deleted: {}, failed: {}", (Object)deletedCount, (Object)failedCount);
        }
    }

    private void cleanupExcessCache() {
        this.clearAllCache();
    }

    public void cleanupInvalidCache() {
        Iterator<Map.Entry<String, File>> iterator = this.cachedFiles.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, File> entry = iterator.next();
            File file = entry.getValue();
            if (file.exists()) continue;
            iterator.remove();
        }
    }
}

