/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.camera.clips.misc;

import java.util.HashMap;
import java.util.Map;
import mchorse.bbs_mod.camera.clips.CameraClip;
import mchorse.bbs_mod.camera.data.Position;
import mchorse.bbs_mod.camera.values.ValueChannels;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.settings.values.core.ValueString;
import mchorse.bbs_mod.utils.clips.Clip;
import mchorse.bbs_mod.utils.clips.ClipContext;
import mchorse.bbs_mod.utils.keyframes.KeyframeChannel;

public class CurveClip
extends CameraClip {
    public static final String SHADER_CURVES_PREFIX = "curve.";
    public final ValueChannels channels = new ValueChannels("channels");

    public static Map<String, Double> getValues(ClipContext context) {
        return context.clipData.get("curve_data", HashMap::new);
    }

    public CurveClip() {
        this.add(this.channels);
        this.channels.addChannel("sun_rotation");
    }

    @Override
    protected void applyClip(ClipContext context, Position position) {
        Map<String, Double> values = CurveClip.getValues(context);
        for (KeyframeChannel<Double> channel : this.channels.getChannels()) {
            if (channel.isEmpty()) continue;
            values.put(channel.getId(), channel.interpolate((float)context.relativeTick + context.transition));
        }
    }

    @Override
    protected Clip create() {
        return new CurveClip();
    }

    @Override
    public void fromData(BaseType data) {
        MapType map;
        if (data.isMap() && (map = data.asMap()).has("key") && map.has("channel")) {
            ValueString key = new ValueString("key", "sun_rotation");
            key.fromData(map.get("key"));
            KeyframeChannel<Double> channel = this.channels.addChannel((String)key.get());
            channel.fromData(map.get("channel"));
        }
        super.fromData(data);
    }
}

