/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.cubic.render;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mchorse.bbs_mod.client.BBSRendering;
import mchorse.bbs_mod.cubic.data.model.Model;
import mchorse.bbs_mod.cubic.data.model.ModelCube;
import mchorse.bbs_mod.cubic.data.model.ModelData;
import mchorse.bbs_mod.cubic.data.model.ModelGroup;
import mchorse.bbs_mod.cubic.data.model.ModelMesh;
import mchorse.bbs_mod.cubic.data.model.ModelQuad;
import mchorse.bbs_mod.cubic.data.model.ModelVertex;
import mchorse.bbs_mod.cubic.render.CubicCubeRenderer;
import mchorse.bbs_mod.cubic.render.ICubicRenderer;
import mchorse.bbs_mod.cubic.render.vao.ModelVAO;
import mchorse.bbs_mod.cubic.render.vao.ModelVAOData;
import mchorse.bbs_mod.utils.CollectionUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import net.minecraft.class_4587;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class CubicVAOBuilderRenderer
implements ICubicRenderer {
    private static final Vector3f v1 = new Vector3f();
    private static final Vector3f v2 = new Vector3f();
    private static final Vector3f v3 = new Vector3f();
    private static final Vector3f n1 = new Vector3f();
    private static final Vector3f n2 = new Vector3f();
    private static final Vector3f n3 = new Vector3f();
    private static final Vector2f u1 = new Vector2f();
    private static final Vector2f u2 = new Vector2f();
    private static final Vector2f u3 = new Vector2f();
    private Map<ModelGroup, ModelVAO> model;
    private ModelVertex modelVertex = new ModelVertex();
    private Vector3f normal = new Vector3f();
    private Vector4f vertex = new Vector4f();

    public CubicVAOBuilderRenderer(Map<ModelGroup, ModelVAO> model) {
        this.model = model;
    }

    @Override
    public void applyGroupTransformations(class_4587 stack, ModelGroup group) {
    }

    @Override
    public boolean renderGroup(class_287 builder, class_4587 stack, ModelGroup group, Model model) {
        ArrayList<Float> vertices = new ArrayList<Float>();
        ArrayList<Float> normals = new ArrayList<Float>();
        ArrayList<Float> uvs = new ArrayList<Float>();
        for (ModelCube cube : group.cubes) {
            this.renderCube(vertices, normals, uvs, stack, group, cube);
        }
        for (ModelMesh mesh : group.meshes) {
            this.renderMesh(vertices, normals, uvs, stack, model, group, mesh);
        }
        if (!vertices.isEmpty()) {
            float[] v = CollectionUtils.toArray(vertices);
            float[] n = CollectionUtils.toArray(normals);
            float[] u = CollectionUtils.toArray(uvs);
            float[] t = BBSRendering.calculateTangents(v, n, u);
            this.model.put(group, new ModelVAO(new ModelVAOData(v, n, t, u)));
        }
        return false;
    }

    private void renderCube(List<Float> vertices, List<Float> normals, List<Float> uvs, class_4587 stack, ModelGroup group, ModelCube cube) {
        stack.method_22903();
        CubicCubeRenderer.moveToPivot(stack, cube.pivot);
        CubicCubeRenderer.rotate(stack, cube.rotate);
        CubicCubeRenderer.moveBackFromPivot(stack, cube.pivot);
        for (ModelQuad quad : cube.quads) {
            this.normal.set(quad.normal.x, quad.normal.y, quad.normal.z);
            stack.method_23760().method_23762().transform(this.normal);
            if (quad.vertices.size() != 4) continue;
            this.writeVertex(vertices, normals, uvs, stack, group, quad.vertices.get(0), this.normal);
            this.writeVertex(vertices, normals, uvs, stack, group, quad.vertices.get(1), this.normal);
            this.writeVertex(vertices, normals, uvs, stack, group, quad.vertices.get(2), this.normal);
            this.writeVertex(vertices, normals, uvs, stack, group, quad.vertices.get(0), this.normal);
            this.writeVertex(vertices, normals, uvs, stack, group, quad.vertices.get(2), this.normal);
            this.writeVertex(vertices, normals, uvs, stack, group, quad.vertices.get(3), this.normal);
        }
        stack.method_22909();
    }

    private void renderMesh(List<Float> vertices, List<Float> normals, List<Float> uvs, class_4587 stack, Model model, ModelGroup group, ModelMesh mesh) {
        stack.method_22903();
        CubicCubeRenderer.moveToPivot(stack, mesh.origin);
        CubicCubeRenderer.rotate(stack, mesh.rotate);
        CubicCubeRenderer.moveBackFromPivot(stack, mesh.origin);
        ModelData baseData = mesh.baseData;
        int c = baseData.vertices.size() / 3;
        for (int i = 0; i < c; ++i) {
            v1.set((Vector3fc)baseData.vertices.get(i * 3));
            v2.set((Vector3fc)baseData.vertices.get(i * 3 + 1));
            v3.set((Vector3fc)baseData.vertices.get(i * 3 + 2));
            n1.set((Vector3fc)baseData.normals.get(i * 3));
            n2.set((Vector3fc)baseData.normals.get(i * 3 + 1));
            n3.set((Vector3fc)baseData.normals.get(i * 3 + 2));
            u1.set((Vector2fc)baseData.uvs.get(i * 3));
            u2.set((Vector2fc)baseData.uvs.get(i * 3 + 1));
            u3.set((Vector2fc)baseData.uvs.get(i * 3 + 2));
            this.normal.set(CubicVAOBuilderRenderer.n1.x, CubicVAOBuilderRenderer.n1.y, CubicVAOBuilderRenderer.n1.z);
            stack.method_23760().method_23762().transform(this.normal);
            this.modelVertex.set(v1, u1, model);
            this.writeVertex(vertices, normals, uvs, stack, group, this.modelVertex, this.normal);
            this.normal.set(CubicVAOBuilderRenderer.n2.x, CubicVAOBuilderRenderer.n2.y, CubicVAOBuilderRenderer.n2.z);
            stack.method_23760().method_23762().transform(this.normal);
            this.modelVertex.set(v2, u2, model);
            this.writeVertex(vertices, normals, uvs, stack, group, this.modelVertex, this.normal);
            this.normal.set(CubicVAOBuilderRenderer.n3.x, CubicVAOBuilderRenderer.n3.y, CubicVAOBuilderRenderer.n3.z);
            stack.method_23760().method_23762().transform(this.normal);
            this.modelVertex.set(v3, u3, model);
            this.writeVertex(vertices, normals, uvs, stack, group, this.modelVertex, this.normal);
        }
        stack.method_22909();
    }

    private void writeVertex(List<Float> vertices, List<Float> normals, List<Float> uvs, class_4587 stack, ModelGroup group, ModelVertex vertex, Vector3f normal) {
        this.vertex.set(vertex.vertex.x, vertex.vertex.y, vertex.vertex.z, 1.0f);
        stack.method_23760().method_23761().transform(this.vertex);
        vertices.add(Float.valueOf(this.vertex.x));
        vertices.add(Float.valueOf(this.vertex.y));
        vertices.add(Float.valueOf(this.vertex.z));
        normals.add(Float.valueOf(normal.x));
        normals.add(Float.valueOf(normal.y));
        normals.add(Float.valueOf(normal.z));
        uvs.add(Float.valueOf(vertex.uv.x));
        uvs.add(Float.valueOf(vertex.uv.y));
    }
}

