/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public enum KeyType {
    BYTE(0){

        @Override
        public int read(DataInputStream stream) throws IOException {
            return stream.readByte() & 0xFF;
        }

        @Override
        public void write(DataOutputStream stream, int value) throws IOException {
            stream.writeByte(value);
        }
    }
    ,
    SHORT(1){

        @Override
        public int read(DataInputStream stream) throws IOException {
            return stream.readShort() & 0xFFFF;
        }

        @Override
        public void write(DataOutputStream stream, int value) throws IOException {
            stream.writeShort(value);
        }
    }
    ,
    INT(2){

        @Override
        public int read(DataInputStream stream) throws IOException {
            return stream.readInt();
        }

        @Override
        public void write(DataOutputStream stream, int value) throws IOException {
            stream.writeInt(value);
        }
    };

    public final byte type;

    public static KeyType from(byte type) {
        switch (type) {
            case 1: {
                return SHORT;
            }
            case 2: {
                return INT;
            }
        }
        return BYTE;
    }

    private KeyType(byte type) {
        this.type = type;
    }

    public abstract int read(DataInputStream var1) throws IOException;

    public abstract void write(DataOutputStream var1, int var2) throws IOException;
}

