/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.forms.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.client.BBSRendering;
import mchorse.bbs_mod.client.BBSShaders;
import mchorse.bbs_mod.client.renderer.entity.ActorEntityRenderer;
import mchorse.bbs_mod.cubic.ModelInstance;
import mchorse.bbs_mod.cubic.animation.ActionsConfig;
import mchorse.bbs_mod.cubic.animation.Animator;
import mchorse.bbs_mod.cubic.animation.IAnimator;
import mchorse.bbs_mod.cubic.animation.ProceduralAnimator;
import mchorse.bbs_mod.cubic.data.model.ModelGroup;
import mchorse.bbs_mod.cubic.model.ArmorSlot;
import mchorse.bbs_mod.cubic.model.ArmorType;
import mchorse.bbs_mod.cubic.model.bobj.BOBJModel;
import mchorse.bbs_mod.forms.CustomVertexConsumerProvider;
import mchorse.bbs_mod.forms.FormUtilsClient;
import mchorse.bbs_mod.forms.ITickable;
import mchorse.bbs_mod.forms.entities.IEntity;
import mchorse.bbs_mod.forms.entities.StubEntity;
import mchorse.bbs_mod.forms.forms.BodyPart;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.forms.forms.ModelForm;
import mchorse.bbs_mod.forms.renderers.FormRenderType;
import mchorse.bbs_mod.forms.renderers.FormRenderer;
import mchorse.bbs_mod.forms.renderers.FormRenderingContext;
import mchorse.bbs_mod.obj.shapes.ShapeKeys;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.settings.values.core.ValuePose;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.utils.StencilMap;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.MatrixStackUtils;
import mchorse.bbs_mod.utils.StringUtils;
import mchorse.bbs_mod.utils.colors.Color;
import mchorse.bbs_mod.utils.joml.Vectors;
import mchorse.bbs_mod.utils.pose.Pose;
import mchorse.bbs_mod.utils.pose.PoseTransform;
import mchorse.bbs_mod.utils.pose.Transform;
import mchorse.bbs_mod.utils.resources.LinkUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5944;
import net.minecraft.class_742;
import net.minecraft.class_757;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class ModelFormRenderer
extends FormRenderer<ModelForm>
implements ITickable {
    private static Matrix4f uiMatrix = new Matrix4f();
    private Map<String, Matrix4f> bones = new HashMap<String, Matrix4f>();
    private ActionsConfig lastConfigs;
    private IAnimator animator;
    private ModelInstance lastModel;
    private IEntity entity = new StubEntity();

    @Override
    protected void applyTransforms(class_4587 stack, float transition) {
        super.applyTransforms(stack, transition);
        ModelInstance model = this.getModel();
        if (model != null) {
            stack.method_22905(model.scale.x, model.scale.y, model.scale.z);
        }
    }

    @Override
    protected void applyTransforms(Matrix4f matrix, float transition) {
        super.applyTransforms(matrix, transition);
        ModelInstance model = this.getModel();
        if (model != null) {
            matrix.scale(model.scale.x, model.scale.y, model.scale.z);
        }
    }

    public static Matrix4f getUIMatrix(UIContext context, int x1, int y1, int x2, int y2) {
        float scale = (float)(y2 - y1) / 2.5f;
        int x = x1 + (x2 - x1) / 2;
        float y = (float)y1 + (float)(y2 - y1) * 0.85f;
        float angle = MathUtils.toRad(context.mouseX - (x1 + x2) / 2) + (float)Math.PI;
        if (((Boolean)BBSSettings.freezeModels.get()).booleanValue()) {
            angle = -2.7488937f;
        }
        uiMatrix.identity();
        uiMatrix.translate((float)x, y, 40.0f);
        uiMatrix.scale(scale, -scale, scale);
        uiMatrix.rotateX(0.3926991f);
        uiMatrix.rotateY(angle);
        return uiMatrix;
    }

    public static ModelInstance getModel(ModelForm form) {
        return BBSModClient.getModels().getModel((String)form.model.get());
    }

    public ModelFormRenderer(ModelForm form) {
        super(form);
    }

    public IAnimator getAnimator() {
        return this.animator;
    }

    public ModelInstance getModel() {
        return ModelFormRenderer.getModel((ModelForm)this.form);
    }

    public Pose getPose() {
        Pose pose = ((Pose)((ModelForm)this.form).pose.get()).copy();
        Pose overlay = (Pose)((ModelForm)this.form).poseOverlay.get();
        this.applyPose(pose, overlay);
        for (ValuePose newPose : ((ModelForm)this.form).additionalOverlays) {
            this.applyPose(pose, (Pose)newPose.get());
        }
        return pose;
    }

    private void applyPose(Pose targetPose, Pose pose) {
        for (Map.Entry<String, PoseTransform> entry : pose.transforms.entrySet()) {
            PoseTransform poseTransform = targetPose.get(entry.getKey());
            PoseTransform value = entry.getValue();
            if (value.fix != 0.0f) {
                poseTransform.translate.lerp((Vector3fc)value.translate, value.fix);
                poseTransform.scale.lerp((Vector3fc)value.scale, value.fix);
                poseTransform.rotate.lerp((Vector3fc)value.rotate, value.fix);
                poseTransform.rotate2.lerp((Vector3fc)value.rotate2, value.fix);
                poseTransform.pivot.lerp((Vector3fc)value.pivot, value.fix);
            } else {
                poseTransform.translate.add((Vector3fc)value.translate);
                poseTransform.scale.add((Vector3fc)value.scale).sub(1.0f, 1.0f, 1.0f);
                poseTransform.rotate.add((Vector3fc)value.rotate);
                poseTransform.rotate2.add((Vector3fc)value.rotate2);
                poseTransform.pivot.add((Vector3fc)value.pivot);
            }
            poseTransform.color.copy(value.color);
            poseTransform.lighting = value.lighting;
            if (value.texture == null) continue;
            poseTransform.texture = LinkUtils.copy(value.texture);
        }
    }

    public void resetAnimator() {
        this.animator = null;
        this.lastModel = null;
    }

    public void ensureAnimator(float transition) {
        ModelInstance model = this.getModel();
        ActionsConfig actionsConfig = (ActionsConfig)((ModelForm)this.form).actions.get();
        if (model == null || this.lastModel == model) {
            if (this.animator != null && !Objects.equals(actionsConfig, this.lastConfigs)) {
                this.animator.setup(model, actionsConfig, true);
                this.lastConfigs = new ActionsConfig();
                this.lastConfigs.copy(actionsConfig);
            }
            return;
        }
        this.animator = model.procedural ? new ProceduralAnimator() : new Animator();
        this.animator.setup(model, actionsConfig, false);
        this.lastConfigs = new ActionsConfig();
        this.lastConfigs.copy(actionsConfig);
        this.lastModel = model;
    }

    @Override
    public List<String> getBones() {
        ModelInstance model = this.getModel();
        return model == null ? Collections.emptyList() : new ArrayList<String>(model.model.getAllGroupKeys());
    }

    @Override
    public void renderInUI(UIContext context, int x1, int y1, int x2, int y2) {
        context.batcher.flush();
        this.ensureAnimator(context.getTransition());
        ModelInstance model = this.getModel();
        if (this.animator != null && model != null) {
            class_4587 stack = context.batcher.getContext().method_51448();
            stack.method_22903();
            Matrix4f uiMatrix = ModelFormRenderer.getUIMatrix(context, x1, y1, x2, y2);
            this.applyTransforms(uiMatrix, context.getTransition());
            Link link = (Link)((ModelForm)this.form).texture.get();
            Link texture = link == null ? model.texture : link;
            Color color = (Color)((ModelForm)this.form).color.get();
            float scale = ((Float)((ModelForm)this.form).uiScale.get()).floatValue() * model.uiScale;
            model.model.resetPose();
            this.animator.applyActions(null, model, context.getTransition());
            model.model.applyPose(this.getPose());
            MatrixStackUtils.multiply(stack, uiMatrix);
            stack.method_22905(scale, scale, scale);
            BBSModClient.getTextures().bindTexture(texture);
            RenderSystem.depthFunc((int)515);
            Supplier<class_5944> mainShader = BBSRendering.isIrisShadersEnabled() && BBSRendering.isRenderingWorld() || !model.isVAORendered() ? class_757::method_34507 : BBSShaders::getModel;
            this.renderModel(this.entity, mainShader, stack, model, class_765.method_23687((int)15, (int)15), class_4608.field_21444, color, true, null, context.getTransition());
            stack.method_22903();
            stack.method_23760().method_23762().getScale(Vectors.EMPTY_3F);
            stack.method_23760().method_23762().scale(1.0f / Vectors.EMPTY_3F.x, -1.0f / Vectors.EMPTY_3F.y, 1.0f / Vectors.EMPTY_3F.z);
            this.renderBodyParts(new FormRenderingContext().set(FormRenderType.ENTITY, this.entity, stack, class_765.method_23687((int)15, (int)15), class_4608.field_21444, context.getTransition()).inUI());
            stack.method_22909();
            stack.method_22909();
            RenderSystem.depthFunc((int)519);
        }
    }

    private void renderModel(IEntity target, Supplier<class_5944> program, class_4587 stack, ModelInstance model, int light, int overlay, Color color, boolean ui, StencilMap stencilMap, float transition) {
        Link link;
        if (!model.culling) {
            RenderSystem.disableCull();
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_757 gameRenderer = class_310.method_1551().field_1773;
        gameRenderer.method_22974().method_3316();
        gameRenderer.method_22975().method_23209();
        class_4587 newStack = new class_4587();
        MatrixStackUtils.multiply(newStack, stack.method_23760().method_23761());
        newStack.method_23760().method_23762().set((Matrix3fc)stack.method_23760().method_23762());
        if (ui) {
            newStack.method_23760().method_23762().getScale(Vectors.EMPTY_3F);
            newStack.method_23760().method_23762().scale(1.0f / Vectors.EMPTY_3F.x, -1.0f / Vectors.EMPTY_3F.y, 1.0f / Vectors.EMPTY_3F.z);
        }
        Link defaultTexture = (link = (Link)((ModelForm)this.form).texture.get()) == null ? model.texture : link;
        model.render(newStack, program, color, light, overlay, stencilMap, (ShapeKeys)((ModelForm)this.form).shapeKeys.get(), defaultTexture);
        gameRenderer.method_22974().method_3315();
        gameRenderer.method_22975().method_23213();
        RenderSystem.disableBlend();
        if (!model.culling) {
            RenderSystem.enableCull();
        }
        this.captureMatrices(model, null);
        if (stencilMap == null) {
            this.renderItems(target, model, stack, class_1304.field_6173, class_811.field_4320, model.itemsMain, color, overlay, light);
            this.renderItems(target, model, stack, class_1304.field_6171, class_811.field_4323, model.itemsOff, color, overlay, light);
            for (Map.Entry<ArmorType, ArmorSlot> entry : model.armorSlots.entrySet()) {
                this.renderArmor(target, stack, entry.getKey(), entry.getValue(), color, overlay, light);
            }
        }
    }

    private void renderArmor(IEntity target, class_4587 stack, ArmorType type, ArmorSlot armorSlot, Color color, int overlay, int light) {
        Matrix4f matrix = this.bones.get(armorSlot.group);
        if (matrix != null) {
            CustomVertexConsumerProvider consumers = FormUtilsClient.getProvider();
            stack.method_22903();
            MatrixStackUtils.multiply(stack, matrix);
            MatrixStackUtils.applyTransform(stack, armorSlot.transform);
            stack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
            CustomVertexConsumerProvider.hijackVertexFormat(l -> RenderSystem.enableBlend());
            ActorEntityRenderer.armorRenderer.renderArmorSlot(stack, (class_4597)consumers, target, type.slot, type, light);
            consumers.method_22993();
            CustomVertexConsumerProvider.clearRunnables();
            stack.method_22909();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
        }
    }

    private void renderItems(IEntity target, ModelInstance model, class_4587 stack, class_1304 slot, class_811 mode, List<ArmorSlot> items, Color color, int overlay, int light) {
        class_1799 itemStack = target.getEquipmentStack(slot);
        if (itemStack != null && itemStack.method_7960()) {
            return;
        }
        for (ArmorSlot armorSlot : items) {
            Matrix4f matrix = this.bones.get(armorSlot.group);
            if (matrix == null) continue;
            CustomVertexConsumerProvider consumers = FormUtilsClient.getProvider();
            stack.method_22903();
            MatrixStackUtils.multiply(stack, matrix);
            stack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
            stack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
            stack.method_46416(0.0f, 0.125f, 0.0f);
            MatrixStackUtils.applyTransform(stack, armorSlot.transform);
            CustomVertexConsumerProvider.hijackVertexFormat(l -> RenderSystem.enableBlend());
            consumers.setSubstitute(BBSRendering.getColorConsumer(color));
            if (model.model instanceof BOBJModel) {
                stack.method_22903();
                stack.method_22905(0.0f, 0.0f, 0.0f);
                class_310.method_1551().method_1480().method_23177(null, new class_1799((class_1935)class_1802.field_8780), mode, mode == class_811.field_4323, stack, (class_4597)consumers, target.getWorld(), light, overlay, 0);
                consumers.method_22993();
                stack.method_22909();
            }
            class_310.method_1551().method_1480().method_23177(null, itemStack, mode, mode == class_811.field_4323, stack, (class_4597)consumers, target.getWorld(), light, overlay, 0);
            consumers.method_22993();
            consumers.setSubstitute(null);
            CustomVertexConsumerProvider.clearRunnables();
            stack.method_22909();
            RenderSystem.enableDepthTest();
        }
    }

    @Override
    public boolean renderArm(class_4587 matrices, int light, class_742 player, class_1268 hand) {
        ModelInstance model = this.getModel();
        if (this.animator != null && model != null) {
            ArmorSlot slot;
            ArmorSlot armorSlot = slot = hand == class_1268.field_5808 ? model.fpMain : model.fpOffhand;
            if (slot == null) {
                return false;
            }
            Link link = (Link)((ModelForm)this.form).texture.get();
            Link texture = link == null ? model.texture : link;
            Color color = ((Color)((ModelForm)this.form).color.get()).copy();
            Iterator<ModelGroup> iterator = model.getModel().getAllGroups().iterator();
            while (iterator.hasNext()) {
                ModelGroup group;
                ModelGroup g = group = iterator.next();
                boolean visible = false;
                while (g != null) {
                    if (g.id.equals(slot.group)) {
                        visible = true;
                        break;
                    }
                    g = g.parent;
                }
                group.visible = visible;
            }
            model.model.resetPose();
            matrices.method_22903();
            matrices.method_22907(class_7833.field_40716.rotation((float)Math.PI));
            MatrixStackUtils.applyTransform(matrices, slot.transform);
            BBSModClient.getTextures().bindTexture(texture);
            Supplier<class_5944> mainShader = BBSRendering.isIrisShadersEnabled() && BBSRendering.isRenderingWorld() || !model.isVAORendered() ? class_757::method_34507 : BBSShaders::getModel;
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            this.renderModel(this.entity, mainShader, matrices, model, light, class_4608.field_21444, color, false, null, 0.0f);
            for (ModelGroup group : model.getModel().getAllGroups()) {
                group.visible = true;
            }
            matrices.method_22909();
            return true;
        }
        return super.renderArm(matrices, light, player, hand);
    }

    @Override
    public void render3D(FormRenderingContext context) {
        this.ensureAnimator(context.getTransition());
        ModelInstance model = this.getModel();
        if (this.animator != null && model != null) {
            Link link = (Link)((ModelForm)this.form).texture.get();
            Link texture = link == null ? model.texture : link;
            Color color = ((Color)((ModelForm)this.form).color.get()).copy();
            color.mul(context.color);
            model.model.resetPose();
            this.animator.applyActions(context.entity, model, context.getTransition());
            model.model.applyPose(this.getPose());
            context.stack.method_22907(class_7833.field_40716.rotation((float)Math.PI));
            BBSModClient.getTextures().bindTexture(texture);
            Supplier<class_5944> mainShader = BBSRendering.isIrisShadersEnabled() && BBSRendering.isRenderingWorld() || !model.isVAORendered() ? class_757::method_34507 : BBSShaders::getModel;
            Supplier<class_5944> shader = this.getShader(context, mainShader, BBSShaders::getPickerModelsProgram);
            this.renderModel(context.entity, shader, context.stack, model, context.light, context.overlay, color, false, context.stencilMap, context.getTransition());
        }
    }

    @Override
    protected void updateStencilMap(FormRenderingContext context) {
        ModelInstance model = this.getModel();
        if (model == null || model.model == null || context.stencilMap == null) {
            return;
        }
        model.fillStencilMap(context.stencilMap, (ModelForm)this.form);
    }

    private void captureMatrices(ModelInstance model, String target) {
        model.captureMatrices(this.bones, target);
    }

    @Override
    public void renderBodyParts(FormRenderingContext context) {
        context.stack.method_22903();
        for (BodyPart part : ((ModelForm)this.form).parts.getAllTyped()) {
            Matrix4f matrix = this.bones.get(part.bone.get());
            context.stack.method_22903();
            if (matrix != null) {
                MatrixStackUtils.multiply(context.stack, matrix);
            } else {
                context.stack.method_22907(class_7833.field_40716.rotation((float)Math.PI));
            }
            this.renderBodyPart(part, context);
            context.stack.method_22909();
        }
        this.bones.clear();
        context.stack.method_22909();
    }

    @Override
    public void collectMatrices(IEntity entity, String target, class_4587 stack, Map<String, Matrix4f> matrices, String prefix, float transition) {
        ModelInstance model = this.getModel();
        stack.method_22903();
        this.applyTransforms(stack, transition);
        matrices.put(prefix, new Matrix4f((Matrix4fc)stack.method_23760().method_23761()));
        if (this.animator != null && model != null) {
            String string;
            model.model.resetPose();
            Object localTarget = target;
            if (target != null && !prefix.isEmpty() && ((String)localTarget).startsWith(string = prefix + "/") && ((String)localTarget).indexOf(47, ((String)localTarget).length()) == -1) {
                localTarget = ((String)localTarget).substring(string.length());
            }
            this.animator.applyActions(entity, model, transition);
            model.model.applyPose(this.getPose());
            stack.method_22907(class_7833.field_40716.rotation((float)Math.PI));
            this.captureMatrices(model, (String)localTarget);
        }
        for (Map.Entry entry : this.bones.entrySet()) {
            stack.method_22903();
            MatrixStackUtils.multiply(stack, (Matrix4f)entry.getValue());
            matrices.put(StringUtils.combinePaths(prefix, (String)entry.getKey()), new Matrix4f((Matrix4fc)stack.method_23760().method_23761()));
            stack.method_22909();
        }
        int i = 0;
        for (BodyPart part : ((ModelForm)this.form).parts.getAllTyped()) {
            Form form = part.getForm();
            if (form != null) {
                Matrix4f matrix = this.bones.get(part.bone.get());
                stack.method_22903();
                if (matrix != null) {
                    MatrixStackUtils.multiply(stack, matrix);
                } else {
                    stack.method_22907(class_7833.field_40716.rotation((float)Math.PI));
                }
                MatrixStackUtils.applyTransform(stack, (Transform)part.transform.get());
                FormUtilsClient.getRenderer(form).collectMatrices((Boolean)part.useTarget.get() != false ? entity : part.getEntity(), target, stack, matrices, StringUtils.combinePaths(prefix, String.valueOf(i)), transition);
                stack.method_22909();
            }
            ++i;
        }
        stack.method_22909();
        this.bones.clear();
    }

    @Override
    public void tick(IEntity entity) {
        this.ensureAnimator(0.0f);
        if (this.animator != null) {
            this.animator.update(entity);
        }
    }
}

