/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.forms.sections;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.data.DataToString;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.forms.FormCategories;
import mchorse.bbs_mod.forms.categories.FormCategory;
import mchorse.bbs_mod.forms.categories.RecentFormCategory;
import mchorse.bbs_mod.forms.categories.UserFormCategory;
import mchorse.bbs_mod.forms.sections.FormSection;
import mchorse.bbs_mod.l10n.keys.IKey;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UserFormSection
extends FormSection {
    public List<UserFormCategory> categories = new ArrayList<UserFormCategory>();

    public static File getUserCategoriesFile(int index) {
        return BBSMod.getSettingsPath("forms/" + index + ".json");
    }

    public UserFormSection(FormCategories parent) {
        super(parent);
    }

    @Override
    public void initiate() {
        this.categories.clear();
        File folder = UserFormSection.getUserCategoriesFile(0).getParentFile();
        if (folder.isDirectory()) {
            this.loadNewCategories();
        }
    }

    private void loadNewCategories() {
        File file;
        for (int i = 0; i < 420 && (file = UserFormSection.getUserCategoriesFile(i)).isFile(); ++i) {
            UserFormCategory category = new UserFormCategory(IKey.EMPTY, this.parent.visibility.get(UUID.randomUUID().toString()), this);
            try {
                MapType data = (MapType)DataToString.read(file);
                category.fromData(data);
                this.categories.add(category);
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to load user form category: " + file.getAbsolutePath());
                e.printStackTrace();
            }
        }
    }

    @Override
    public List<FormCategory> getCategories() {
        ArrayList<FormCategory> categoryList = new ArrayList<FormCategory>();
        for (UserFormCategory category : this.categories) {
            categoryList.add(category);
        }
        return categoryList;
    }

    public void writeUserCategories() {
        for (int i = 0; i < this.categories.size(); ++i) {
            this.writeUserCategory(i, this.categories.get(i));
        }
    }

    public void writeUserCategories(UserFormCategory formCategory) {
        int index = this.categories.indexOf(formCategory);
        if (formCategory != null) {
            this.writeUserCategory(index, formCategory);
        }
    }

    private void writeUserCategory(int index, FormCategory category) {
        File file = UserFormSection.getUserCategoriesFile(index);
        file.getParentFile().mkdirs();
        try {
            DataToString.write(file, category.toData(), true);
        }
        catch (Exception e) {
            System.err.println("Failed to save user category: " + file.getAbsolutePath());
            e.printStackTrace();
        }
    }

    public void addUserCategory(UserFormCategory category) {
        FormCategory formCat;
        int index = 0;
        Iterator<UserFormCategory> iterator = this.categories.iterator();
        while (iterator.hasNext() && ((formCat = (FormCategory)iterator.next()) instanceof RecentFormCategory || formCat instanceof UserFormCategory)) {
            ++index;
        }
        this.categories.add(index, category);
        this.parent.markDirty();
        this.writeUserCategories();
    }

    public void removeUserCategory(UserFormCategory category) {
        File lastFile = UserFormSection.getUserCategoriesFile(this.categories.size() - 1);
        if (lastFile.isFile()) {
            lastFile.delete();
        }
        this.categories.remove(category);
        this.parent.markDirty();
        this.parent.visibility.remove(category.visible.getId());
        this.writeUserCategories();
    }
}

