/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.settings.ui;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.settings.ui.UIValueFactory;
import mchorse.bbs_mod.settings.ui.UIVideoSettingsOverlayPanel;
import mchorse.bbs_mod.settings.value.ValueKeyCombo;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.settings.values.core.ValueLink;
import mchorse.bbs_mod.settings.values.core.ValueString;
import mchorse.bbs_mod.settings.values.numeric.ValueBoolean;
import mchorse.bbs_mod.settings.values.numeric.ValueDouble;
import mchorse.bbs_mod.settings.values.numeric.ValueFloat;
import mchorse.bbs_mod.settings.values.numeric.ValueInt;
import mchorse.bbs_mod.settings.values.ui.ValueLanguage;
import mchorse.bbs_mod.settings.values.ui.ValueVideoSettings;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIButton;
import mchorse.bbs_mod.ui.framework.elements.buttons.UICirculate;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIToggle;
import mchorse.bbs_mod.ui.framework.elements.input.UIColor;
import mchorse.bbs_mod.ui.framework.elements.input.UIKeybind;
import mchorse.bbs_mod.ui.framework.elements.input.UITexturePicker;
import mchorse.bbs_mod.ui.framework.elements.input.UITrackpad;
import mchorse.bbs_mod.ui.framework.elements.input.text.UITextbox;
import mchorse.bbs_mod.ui.framework.elements.overlay.UILabelOverlayPanel;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlay;
import mchorse.bbs_mod.ui.framework.elements.utils.UILabel;
import mchorse.bbs_mod.ui.framework.elements.utils.UIText;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.ui.utils.keys.KeyCombo;
import mchorse.bbs_mod.utils.FFMpegUtils;
import mchorse.bbs_mod.utils.OS;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIValueMap {
    private static Map<Class<? extends BaseValue>, IUIValueFactory<? extends BaseValue>> factories = new HashMap<Class<? extends BaseValue>, IUIValueFactory<? extends BaseValue>>();

    public static <T extends BaseValue> void register(Class<T> clazz, IUIValueFactory<T> factory) {
        factories.put(clazz, factory);
    }

    public static <T extends BaseValue> List<UIElement> create(T value, UIElement element) {
        IUIValueFactory<? extends BaseValue> factory = factories.get(value.getClass());
        return factory == null ? Collections.emptyList() : factory.create(value, element);
    }

    static {
        UIValueMap.register(ValueBoolean.class, (value, ui) -> {
            UIToggle toggle = UIValueFactory.booleanUI(value, null);
            toggle.resetFlex();
            return Arrays.asList(toggle);
        });
        UIValueMap.register(ValueDouble.class, (value, ui) -> {
            UITrackpad trackpad = UIValueFactory.doubleUI(value, null);
            trackpad.w(90);
            return Arrays.asList(UIValueFactory.column(trackpad, value));
        });
        UIValueMap.register(ValueFloat.class, (value, ui) -> {
            UITrackpad trackpad = UIValueFactory.floatUI(value, null);
            trackpad.w(90);
            return Arrays.asList(UIValueFactory.column(trackpad, value));
        });
        UIValueMap.register(ValueInt.class, (value, ui) -> {
            if (value.getSubtype() == ValueInt.Subtype.COLOR || value.getSubtype() == ValueInt.Subtype.COLOR_ALPHA) {
                UIColor color = UIValueFactory.colorUI(value, null);
                color.w(90);
                return Arrays.asList(UIValueFactory.column(color, value));
            }
            if (value.getSubtype() == ValueInt.Subtype.MODES) {
                UICirculate button = new UICirculate(null);
                for (IKey key : value.getLabels()) {
                    button.addLabel(key);
                }
                button.callback = b -> value.set(button.getValue());
                button.setValue((Integer)value.get());
                button.w(90);
                return Arrays.asList(UIValueFactory.column(button, value));
            }
            UITrackpad trackpad = UIValueFactory.intUI(value, null);
            trackpad.w(90);
            return Arrays.asList(UIValueFactory.column(trackpad, value));
        });
        UIValueMap.register(ValueLanguage.class, (value, ui) -> {
            UIButton button = new UIButton(UIKeys.LANGUAGE_PICK, b -> {
                List labels = BBSModClient.getL10n().getSupportedLanguageLabels();
                UILabelOverlayPanel<String> panel = new UILabelOverlayPanel<String>(UIKeys.LANGUAGE_PICK_TITLE, labels, str -> value.set((String)str.value));
                panel.set((String)value.get());
                UIOverlay.addOverlay(ui.getContext(), panel);
            });
            button.w(90);
            UIText credits = new UIText().text(UIKeys.LANGUAGE_CREDITS).updates();
            return Arrays.asList(UIValueFactory.column(button, value), credits.marginBottom(8));
        });
        UIValueMap.register(ValueLink.class, (value, ui) -> {
            UIButton pick = new UIButton(UIKeys.TEXTURE_PICK_TEXTURE, button -> UITexturePicker.open(ui.getContext(), (Link)value.get(), value::set));
            pick.w(90);
            return Arrays.asList(UIValueFactory.column(pick, value));
        });
        UIValueMap.register(ValueString.class, (value, ui) -> {
            UITextbox textbox = UIValueFactory.stringUI(value, null);
            textbox.w(90);
            if (value == BBSSettings.videoEncoderPath && OS.CURRENT == OS.WINDOWS) {
                textbox.context(menu -> menu.action(Icons.SEARCH, UIKeys.GENERAL_FFMPEG_FIND, () -> textbox.getContext().replaceContextMenu(submenu -> {
                    File[] files = File.listRoots();
                    File file = files.length == 0 ? new File("C:\\") : files[0];
                    Optional<Path> ffmpeg = FFMpegUtils.findFFMpeg(file.toPath());
                    if (ffmpeg.isPresent()) {
                        Path path = ffmpeg.get();
                        String pathString = path.toAbsolutePath().toString();
                        submenu.action(Icons.VIDEO_CAMERA, IKey.constant(pathString), () -> {
                            textbox.setText(pathString);
                            value.set(pathString);
                        });
                    }
                })));
            }
            return Arrays.asList(UIValueFactory.column(textbox, value));
        });
        UIValueMap.register(ValueKeyCombo.class, (value, ui) -> {
            UILabel label = UI.label(((KeyCombo)value.get()).label, 0).labelAnchor(0.0f, 0.5f);
            UIKeybind keybind = new UIKeybind(value::set).mouse().escape();
            keybind.setKeyCombo((KeyCombo)value.get());
            keybind.w(100);
            return Arrays.asList(UI.row(label, keybind).tooltip(((KeyCombo)value.get()).label));
        });
        UIValueMap.register(ValueVideoSettings.class, (value, ui) -> {
            UIButton button = new UIButton(UIKeys.VIDEO_SETTINGS_EDIT, b -> UIOverlay.addOverlay(ui.getContext(), new UIVideoSettingsOverlayPanel((ValueVideoSettings)value)));
            return Arrays.asList(button);
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static interface IUIValueFactory<T extends BaseValue> {
        public List<UIElement> create(T var1, UIElement var2);
    }
}

