/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.clips;

import mchorse.bbs_mod.camera.clips.modifiers.OrbitClip;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.film.IUIClipsDelegate;
import mchorse.bbs_mod.ui.film.UIFilmPanel;
import mchorse.bbs_mod.ui.film.clips.UIClip;
import mchorse.bbs_mod.ui.film.clips.modules.UIPointModule;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIButton;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIToggle;
import mchorse.bbs_mod.ui.framework.elements.input.UITrackpad;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIAnchorKeyframeFactory;
import mchorse.bbs_mod.ui.utils.UI;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIOrbitClip
extends UIClip<OrbitClip> {
    public UIButton selector;
    public UIToggle absolute;
    public UIToggle copy;
    public UITrackpad yaw;
    public UITrackpad pitch;
    public UIPointModule offset;
    public UITrackpad distance;

    public UIOrbitClip(OrbitClip clip, IUIClipsDelegate editor) {
        super(clip, editor);
    }

    @Override
    protected void registerUI() {
        super.registerUI();
        this.selector = new UIButton(UIKeys.CAMERA_PANELS_TARGET_TITLE, b -> {
            UIFilmPanel panel = this.getParent(UIFilmPanel.class);
            if (panel != null) {
                UIAnchorKeyframeFactory.displayActors(this.getContext(), panel.getController().getEntities(), (Integer)((OrbitClip)this.clip).selector.get(), i -> ((OrbitClip)this.clip).selector.set(i));
            }
        });
        this.selector.tooltip(UIKeys.CAMERA_PANELS_TARGET_TOOLTIP);
        this.absolute = new UIToggle(UIKeys.CAMERA_PANELS_ABSOLUTE, false, b -> ((OrbitClip)this.clip).absolute.set(b.getValue()));
        this.copy = new UIToggle(UIKeys.CAMERA_PANELS_COPY_ENTITY, false, b -> ((OrbitClip)this.clip).copy.set(b.getValue()));
        this.copy.tooltip(UIKeys.CAMERA_PANELS_COPY_ENTITY_TOOLTIP);
        this.yaw = new UITrackpad(value -> ((OrbitClip)this.clip).yaw.set(Float.valueOf(value.floatValue())));
        this.yaw.tooltip(UIKeys.CAMERA_PANELS_YAW);
        this.pitch = new UITrackpad(value -> ((OrbitClip)this.clip).pitch.set(Float.valueOf(value.floatValue())));
        this.pitch.tooltip(UIKeys.CAMERA_PANELS_PITCH);
        this.offset = new UIPointModule(this.editor, UIKeys.CAMERA_PANELS_OFFSET).contextMenu();
        this.distance = new UITrackpad(value -> ((OrbitClip)this.clip).distance.set(Float.valueOf(value.floatValue())));
    }

    @Override
    protected void registerPanels() {
        super.registerPanels();
        this.panels.add(UIClip.label(UIKeys.CAMERA_PANELS_TARGET).marginTop(12), this.selector);
        this.panels.add(this.absolute, this.copy);
        this.panels.add((IUIElement)UI.column(UIClip.label(UIKeys.CAMERA_PANELS_DISTANCE), this.distance).marginTop(12));
        this.panels.add((IUIElement)UI.column(UIClip.label(UIKeys.CAMERA_PANELS_ANGLE), UI.row(5, 0, 20, this.yaw, this.pitch)).marginTop(12));
        this.panels.add((IUIElement)this.offset.marginTop(12));
    }

    @Override
    public void fillData() {
        super.fillData();
        this.absolute.setValue((Boolean)((OrbitClip)this.clip).absolute.get());
        this.copy.setValue((Boolean)((OrbitClip)this.clip).copy.get());
        this.yaw.setValue(((Float)((OrbitClip)this.clip).yaw.get()).floatValue());
        this.pitch.setValue(((Float)((OrbitClip)this.clip).pitch.get()).floatValue());
        this.offset.fill(((OrbitClip)this.clip).offset);
        this.distance.setValue(((Float)((OrbitClip)this.clip).distance.get()).floatValue());
    }
}

