/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.forms.editors.panels;

import mchorse.bbs_mod.forms.forms.LabelForm;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.forms.editors.forms.UIForm;
import mchorse.bbs_mod.ui.forms.editors.panels.UIFormPanel;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIToggle;
import mchorse.bbs_mod.ui.framework.elements.input.UIColor;
import mchorse.bbs_mod.ui.framework.elements.input.UITrackpad;
import mchorse.bbs_mod.ui.framework.elements.input.text.UITextbox;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.utils.colors.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UILabelFormPanel
extends UIFormPanel<LabelForm> {
    public UITextbox text = new UITextbox(10000, t -> ((LabelForm)this.form).text.set(t));
    public UIToggle billboard = new UIToggle(UIKeys.FORMS_EDITORS_BILLBOARD_TITLE, b -> ((LabelForm)this.form).billboard.set(b.getValue()));
    public UIColor color = new UIColor(c -> ((LabelForm)this.form).color.set(Color.rgba(c))).withAlpha();
    public UITrackpad max = new UITrackpad(value -> ((LabelForm)this.form).max.set(value.intValue()));
    public UITrackpad anchorX;
    public UITrackpad anchorY;
    public UIToggle anchorLines;
    public UITrackpad shadowX;
    public UITrackpad shadowY;
    public UIColor shadowColor;
    public UIColor background;
    public UITrackpad offset;

    public UILabelFormPanel(UIForm editor) {
        super(editor);
        this.max.limit(-1.0, 2.147483647E9, true).increment(10.0);
        this.anchorX = new UITrackpad(value -> ((LabelForm)this.form).anchorX.set(Float.valueOf(value.floatValue())));
        this.anchorX.values(0.01f);
        this.anchorY = new UITrackpad(value -> ((LabelForm)this.form).anchorY.set(Float.valueOf(value.floatValue())));
        this.anchorY.values(0.01f);
        this.anchorLines = new UIToggle(UIKeys.FORMS_EDITORS_LABEL_ANCHOR_LINES, value -> ((LabelForm)this.form).anchorLines.set(value.getValue()));
        this.shadowX = new UITrackpad(value -> ((LabelForm)this.form).shadowX.set(Float.valueOf(value.floatValue())));
        this.shadowX.limit(-100.0, 100.0).values(0.1f, 0.01f, 0.5).increment(0.1f);
        this.shadowY = new UITrackpad(value -> ((LabelForm)this.form).shadowY.set(Float.valueOf(value.floatValue())));
        this.shadowY.limit(-100.0, 100.0).values(0.1f, 0.01f, 0.5).increment(0.1f);
        this.shadowColor = new UIColor(value -> ((LabelForm)this.form).shadowColor.set(Color.rgba(value))).withAlpha();
        this.background = new UIColor(value -> ((LabelForm)this.form).background.set(Color.rgba(value))).withAlpha();
        this.offset = new UITrackpad(value -> ((LabelForm)this.form).offset.set(Float.valueOf(value.floatValue())));
        this.options.add(UI.label(UIKeys.FORMS_EDITORS_LABEL_LABEL), this.text, this.billboard, this.color, this.max);
        this.options.add(UI.label(UIKeys.FORMS_EDITORS_LABEL_ANCHOR).marginTop(8), UI.row(this.anchorX, this.anchorY), this.anchorLines);
        this.options.add(UI.label(UIKeys.FORMS_EDITORS_LABEL_SHADOW_OFFSET).marginTop(8), this.shadowX, this.shadowY);
        this.options.add(UI.label(UIKeys.FORMS_EDITORS_LABEL_SHADOW_COLOR).marginTop(8), this.shadowColor);
        this.options.add(UI.label(UIKeys.FORMS_EDITORS_LABEL_BACKGROUND).marginTop(8), this.background, this.offset);
    }

    @Override
    public void startEdit(LabelForm form) {
        super.startEdit(form);
        this.text.setText((String)form.text.get());
        this.billboard.setValue((Boolean)form.billboard.get());
        this.color.setColor(((Color)form.color.get()).getARGBColor());
        this.max.setValue(((Integer)form.max.get()).intValue());
        this.anchorX.setValue(((Float)form.anchorX.get()).floatValue());
        this.anchorY.setValue(((Float)form.anchorY.get()).floatValue());
        this.anchorLines.setValue((Boolean)form.anchorLines.get());
        this.shadowX.setValue(((Float)form.shadowX.get()).floatValue());
        this.shadowY.setValue(((Float)form.shadowY.get()).floatValue());
        this.shadowColor.setColor(((Color)form.shadowColor.get()).getARGBColor());
        this.background.setColor(((Color)form.background.get()).getARGBColor());
        this.offset.setValue(((Float)form.offset.get()).floatValue());
    }

    @Override
    public void finishEdit() {
        super.finishEdit();
        this.color.picker.removeFromParent();
        this.shadowColor.picker.removeFromParent();
        this.background.picker.removeFromParent();
    }
}

