/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.overlay;

import java.util.HashMap;
import java.util.Map;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlayPanel;
import mchorse.bbs_mod.ui.framework.elements.utils.EventPropagation;
import mchorse.bbs_mod.ui.utils.UIUtils;
import mchorse.bbs_mod.ui.utils.resizers.Flex;
import mchorse.bbs_mod.utils.colors.Colors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Vector2i;

@Environment(value=EnvType.CLIENT)
public class UIOverlay
extends UIElement {
    private static final Map<String, Vector2i> offsets = new HashMap<String, Vector2i>();
    private int background = -2013265920;

    public static UIOverlay addOverlay(UIContext context, UIOverlayPanel panel) {
        UIOverlay overlay = new UIOverlay();
        panel.relative(overlay).xy(0.5f, 0.5f).wh(0.5f, 0.5f).anchor(0.5f).bounds(overlay, 0);
        UIOverlay.setupPanel(context, overlay, panel);
        return overlay;
    }

    public static UIOverlay addOverlay(UIContext context, UIOverlayPanel panel, float w, float h) {
        UIOverlay overlay = new UIOverlay();
        panel.relative(overlay).xy(0.5f, 0.5f).wh(w, h).anchor(0.5f).bounds(overlay, 0);
        UIOverlay.setupPanel(context, overlay, panel);
        return overlay;
    }

    public static UIOverlay addOverlay(UIContext context, UIOverlayPanel panel, int w, int h) {
        UIOverlay overlay = new UIOverlay();
        panel.relative(overlay).xy(0.5f, 0.5f).wh(w, h).anchor(0.5f).bounds(overlay, 0);
        UIOverlay.setupPanel(context, overlay, panel);
        return overlay;
    }

    public static UIOverlay addOverlay(UIContext context, UIOverlayPanel panel, int w, float h) {
        UIOverlay overlay = new UIOverlay();
        panel.relative(overlay).xy(0.5f, 0.5f).w(w).h(h).anchor(0.5f).bounds(overlay, 0);
        UIOverlay.setupPanel(context, overlay, panel);
        return overlay;
    }

    public static UIOverlay addOverlayLeft(UIContext context, UIOverlayPanel panel, int w) {
        return UIOverlay.addOverlayLeft(context, panel, w, 10);
    }

    public static UIOverlay addOverlayLeft(UIContext context, UIOverlayPanel panel, int w, int padding) {
        UIOverlay overlay = new UIOverlay();
        panel.relative(overlay).x(padding).y(padding).w(w).h(1.0f, -padding * 2).anchor(0.0f, 0.0f).bounds(overlay, 0);
        UIOverlay.setupPanel(context, overlay, panel);
        return overlay;
    }

    public static UIOverlay addOverlayRight(UIContext context, UIOverlayPanel panel, int w) {
        return UIOverlay.addOverlayRight(context, panel, w, 10);
    }

    public static UIOverlay addOverlayRight(UIContext context, UIOverlayPanel panel, int w, int padding) {
        UIOverlay overlay = new UIOverlay();
        panel.relative(overlay).x(1.0f, -padding).y(padding).w(w).h(1.0f, -padding * 2).anchor(1.0f, 0.0f).bounds(overlay, 0);
        UIOverlay.setupPanel(context, overlay, panel);
        return overlay;
    }

    public static void setupPanel(UIContext context, UIOverlay overlay, UIOverlayPanel panel) {
        if (panel.hasParent()) {
            return;
        }
        Flex flex = panel.getFlex();
        Vector2i offset = offsets.get(panel.getClass().getSimpleName());
        panel.setInitialOffset(flex.x.offset, flex.y.offset);
        if (offset != null) {
            flex.x.offset = offset.x;
            flex.y.offset = offset.y;
        }
        overlay.full(context.menu.overlay);
        context.menu.overlay.add((IUIElement)overlay);
        overlay.add((IUIElement)panel);
        context.menu.overlay.resize();
    }

    public static boolean has(UIContext context) {
        return !context.menu.getRoot().getChildren(UIOverlayPanel.class).isEmpty();
    }

    public UIOverlay() {
        this.eventPropagataion(EventPropagation.BLOCK).markContainer();
    }

    public UIOverlay background(int background) {
        this.background = background;
        return this;
    }

    public UIOverlay noBackground() {
        return this.background(0);
    }

    public void closeItself() {
        this.removeFromParent();
        UIUtils.playClick();
        for (UIOverlayPanel element : this.getChildren(UIOverlayPanel.class)) {
            element.removeFromParent();
            element.onClose();
            Vector2i offset = new Vector2i(element.getFlex().x.offset, element.getFlex().y.offset);
            offsets.put(element.getClass().getSimpleName(), offset);
        }
    }

    @Override
    protected boolean subMouseClicked(UIContext context) {
        this.closeItself();
        return super.subMouseClicked(context);
    }

    @Override
    public void render(UIContext context) {
        if (Colors.getA(this.background) > 0.0f) {
            this.area.render(context.batcher, this.background);
        }
        super.render(context);
    }
}

