/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.utils.keys;

import java.util.HashMap;
import java.util.Map;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.utils.OS;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class KeyCodes {
    private static final Map<Character, Character> CYRILLIC_TO_QWERTY;

    public static String cyrillicToQwerty(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        StringBuilder out = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            out.append(CYRILLIC_TO_QWERTY.getOrDefault(Character.valueOf(ch), Character.valueOf(ch)));
        }
        return out.toString();
    }

    public static String getName(int keyCode) {
        if (keyCode == 0) {
            return "N/A";
        }
        if (keyCode < 0) {
            switch (keyCode) {
                case 0: {
                    return "LMB";
                }
                case -1: {
                    return "RMB";
                }
                case -2: {
                    return "MMB";
                }
            }
            return "Mouse " + (-keyCode + 1);
        }
        if (((Boolean)BBSSettings.forceQwerty.get()).booleanValue()) {
            switch (keyCode) {
                case 48: {
                    return "0";
                }
                case 49: {
                    return "1";
                }
                case 50: {
                    return "2";
                }
                case 51: {
                    return "3";
                }
                case 52: {
                    return "4";
                }
                case 53: {
                    return "5";
                }
                case 54: {
                    return "6";
                }
                case 55: {
                    return "7";
                }
                case 56: {
                    return "8";
                }
                case 57: {
                    return "9";
                }
                case 65: {
                    return "A";
                }
                case 66: {
                    return "B";
                }
                case 67: {
                    return "C";
                }
                case 68: {
                    return "D";
                }
                case 69: {
                    return "E";
                }
                case 70: {
                    return "F";
                }
                case 71: {
                    return "G";
                }
                case 72: {
                    return "H";
                }
                case 73: {
                    return "I";
                }
                case 74: {
                    return "J";
                }
                case 75: {
                    return "K";
                }
                case 76: {
                    return "L";
                }
                case 77: {
                    return "M";
                }
                case 78: {
                    return "N";
                }
                case 79: {
                    return "O";
                }
                case 80: {
                    return "P";
                }
                case 81: {
                    return "Q";
                }
                case 82: {
                    return "R";
                }
                case 83: {
                    return "S";
                }
                case 84: {
                    return "T";
                }
                case 85: {
                    return "U";
                }
                case 86: {
                    return "V";
                }
                case 87: {
                    return "W";
                }
                case 88: {
                    return "X";
                }
                case 89: {
                    return "Y";
                }
                case 90: {
                    return "Z";
                }
            }
        }
        switch (keyCode) {
            case 32: {
                return "Space";
            }
            case 256: {
                return "Escape";
            }
            case 257: {
                return "Enter";
            }
            case 258: {
                return "Tab";
            }
            case 259: {
                return "Backspace";
            }
            case 260: {
                return "Insert";
            }
            case 261: {
                return "Delete";
            }
            case 262: {
                return "Right";
            }
            case 263: {
                return "Left";
            }
            case 264: {
                return "Down";
            }
            case 265: {
                return "Up";
            }
            case 266: {
                return "Page up";
            }
            case 267: {
                return "Page down";
            }
            case 268: {
                return "Home";
            }
            case 269: {
                return "End";
            }
            case 280: {
                return "Capslock";
            }
            case 281: {
                return "Scrolllock";
            }
            case 282: {
                return "Numlock";
            }
            case 283: {
                return "Printscreen";
            }
            case 284: {
                return "Pause";
            }
            case 340: {
                return "Shift";
            }
            case 341: {
                return "Ctrl";
            }
            case 342: {
                return "Alt";
            }
            case 343: {
                return OS.CURRENT == OS.MACOS ? "Cmd" : "Win";
            }
            case 344: {
                return "R.Shift";
            }
            case 345: {
                return "R.Ctrl";
            }
            case 346: {
                return "R.Alt";
            }
            case 347: {
                return "R." + (OS.CURRENT == OS.MACOS ? "Cmd" : "Win");
            }
        }
        Object name = GLFW.glfwGetKeyName((int)keyCode, (int)0);
        if (keyCode >= 320 && keyCode <= 336) {
            switch (keyCode) {
                case 335: {
                    name = "Enter";
                    break;
                }
                case 336: {
                    name = "=";
                }
            }
            return "Num " + (String)name;
        }
        if (name == null) {
            if (keyCode >= 290 && keyCode <= 308) {
                return "F" + (keyCode - 289);
            }
            name = "Key " + keyCode;
        }
        return ((String)name).length() == 1 ? ((String)name).toUpperCase() : name;
    }

    static {
        int i;
        CYRILLIC_TO_QWERTY = new HashMap<Character, Character>();
        String ruLower = "\u0451\u0439\u0446\u0443\u043a\u0435\u043d\u0433\u0448\u0449\u0437\u0445\u044a\u0444\u044b\u0432\u0430\u043f\u0440\u043e\u043b\u0434\u0436\u044d\u044f\u0447\u0441\u043c\u0438\u0442\u044c\u0431\u044e";
        String enLower = "`qwertyuiop[]asdfghjkl;'zxcvbnm,.";
        String ruUpper = "\u0401\u0419\u0426\u0423\u041a\u0415\u041d\u0413\u0428\u0429\u0417\u0425\u042a\u0424\u042b\u0412\u0410\u041f\u0420\u041e\u041b\u0414\u0416\u042d\u042f\u0427\u0421\u041c\u0418\u0422\u042c\u0411\u042e";
        String enUpper = "~QWERTYUIOP{}ASDFGHJKL:\"ZXCVBNM<>";
        for (i = 0; i < ruLower.length(); ++i) {
            CYRILLIC_TO_QWERTY.put(Character.valueOf(ruLower.charAt(i)), Character.valueOf(enLower.charAt(i)));
        }
        for (i = 0; i < ruUpper.length(); ++i) {
            CYRILLIC_TO_QWERTY.put(Character.valueOf(ruUpper.charAt(i)), Character.valueOf(enUpper.charAt(i)));
        }
    }
}

