/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.utils.keys;

import java.util.ArrayList;
import java.util.List;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.input.UIKeybinds;
import mchorse.bbs_mod.ui.utils.keys.KeyAction;
import mchorse.bbs_mod.ui.utils.keys.KeyCombo;
import mchorse.bbs_mod.ui.utils.keys.Keybind;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class KeybindManager {
    public List<Keybind> keybinds = new ArrayList<Keybind>();
    public boolean focus = true;

    public Keybind register(KeyCombo combo, Runnable callback) {
        Keybind keybind = new Keybind(combo, callback);
        this.keybinds.add(keybind);
        return keybind;
    }

    public KeybindManager ignoreFocus() {
        this.focus = false;
        return this;
    }

    public void add(UIContext context, boolean inside) {
        if (this.focus && context.isFocused()) {
            return;
        }
        UIKeybinds keybinds = context.keybinds;
        if (!keybinds.hasParent()) {
            return;
        }
        for (Keybind keybind : this.keybinds) {
            if (!keybind.isActive() || keybind.inside && !inside) continue;
            keybinds.addKeybind(keybind);
        }
    }

    public boolean check(UIContext context, boolean inside) {
        if (context.getKeyAction() == KeyAction.RELEASED || this.focus && context.isFocused()) {
            return false;
        }
        return this.checkKeybinds(context, inside, false);
    }

    public boolean checkMouse(UIContext context, boolean inside) {
        if (this.focus && context.isFocused()) {
            return false;
        }
        return this.checkKeybinds(context, inside, true);
    }

    private boolean checkKeybinds(UIContext context, boolean inside, boolean mouse) {
        int keyCode = context.getKeyCode();
        int size = this.keybinds.size();
        int index = -1;
        int score = 0;
        for (int i = 0; i < size; ++i) {
            boolean condition;
            Keybind keybind = this.keybinds.get(i);
            if (keybind.callback == null || !keybind.isActive()) continue;
            boolean bl = condition = mouse ? keybind.checkMouse(context.mouseButton, inside) : keybind.check(keyCode, context.getKeyAction(), inside);
            if (!condition) continue;
            int keybindScore = keybind.getScore();
            if (index != -1 && keybindScore <= score) continue;
            index = i;
            score = keybindScore;
        }
        if (index >= 0) {
            this.keybinds.get((int)index).callback.run();
            return true;
        }
        return false;
    }
}

