/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class EnumUtils {
    public static <T> T getValue(int ordinal, T[] values, T defaultValue) {
        if (ordinal < 0 || ordinal >= values.length) {
            return defaultValue;
        }
        return values[ordinal];
    }

    public static List<String> getKeys(Class<? extends Enum> clazz) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Enum e : clazz.getEnumConstants()) {
            keys.add(e.name().toLowerCase());
        }
        return keys;
    }

    public static <T> List<String> getKeys(Class<T> clazz, Function<T, String> function) {
        ArrayList<String> keys = new ArrayList<String>();
        if (function == null) {
            return keys;
        }
        for (T e : clazz.getEnumConstants()) {
            keys.add(function.apply(e));
        }
        return keys;
    }
}

