/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.keyframes;

import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.interps.Lerps;

public class BezierUtils {
    public static double get(double aValue, double bValue, float aTick, float bTick, float aRx, float aRy, float bLx, float bLy, float x) {
        if (x <= 0.0f) {
            return aValue;
        }
        if (x >= 1.0f) {
            return bValue;
        }
        double w = bTick - aTick;
        double h = bValue - aValue;
        if (h == 0.0) {
            h = 1.0E-5;
        }
        double x1 = (double)aRx / w;
        double y1 = (double)aRy / h;
        double x2 = (w - (double)bLx) / w;
        double y2 = (h + (double)bLy) / h;
        double e = 5.0E-4;
        e = h == 0.0 ? e : Math.max(Math.min(e, 1.0 / h * e), 1.0E-5);
        x1 = MathUtils.clamp(x1, 0.0, 1.0);
        x2 = MathUtils.clamp(x2, 0.0, 1.0);
        return Lerps.bezier(0.0, y1, y2, 1.0, Lerps.bezierX(x1, x2, (double)x, e)) * h + aValue;
    }
}

