/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.keyframes;

import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.interps.IInterp;
import mchorse.bbs_mod.utils.keyframes.Keyframe;
import mchorse.bbs_mod.utils.keyframes.KeyframeChannel;
import mchorse.bbs_mod.utils.keyframes.factories.IKeyframeFactory;

public class KeyframeSegment<T> {
    public Keyframe<T> a;
    public Keyframe<T> b;
    public Keyframe<T> preA;
    public Keyframe<T> postB;
    public float duration;
    public float offset;
    public float x;

    public KeyframeSegment() {
    }

    public KeyframeSegment(Keyframe<T> a, Keyframe<T> b) {
        this.fill(a, b);
    }

    public void setup(Keyframe<T> a, Keyframe<T> b, float ticks) {
        this.fill(a, b);
        this.setup(ticks);
    }

    public void fill(Keyframe<T> a, Keyframe<T> b) {
        this.a = a;
        this.b = b;
        KeyframeChannel channel = (KeyframeChannel)a.getParent();
        int index = channel.getKeyframes().indexOf(a);
        if (index >= 0) {
            Keyframe preA = channel.get(index - 1);
            Keyframe postB = channel.get(index + 2);
            this.preA = preA == null ? a : preA;
            this.postB = postB == null ? b : postB;
        } else {
            this.preA = a;
            this.postB = b;
        }
    }

    public void setup(float ticks) {
        float forcedDuration = this.a.getDuration();
        this.duration = forcedDuration > 0.0f ? forcedDuration : this.b.getTick() - this.a.getTick();
        this.offset = ticks - this.a.getTick();
        this.x = MathUtils.clamp(this.duration == 0.0f ? 0.0f : this.offset / this.duration, 0.0f, 1.0f);
    }

    public T createInterpolated() {
        IKeyframeFactory<T> factory = this.a.getFactory();
        if (this.isSame()) {
            return factory.copy(this.a.getValue());
        }
        return (T)factory.copy(factory.interpolate((T)this.preA, (T)this.a, (T)this.b, (T)this.postB, (IInterp)this.a.getInterpolation(), this.x));
    }

    public boolean isSame() {
        return this.a == this.b;
    }

    public Keyframe<T> getClosest() {
        return this.x > 0.5f ? this.b : this.a;
    }
}

