/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.resources;

import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.StringType;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.utils.resources.IWritableLink;
import mchorse.bbs_mod.utils.resources.MultiLink;

public class LinkUtils {
    public static Link create(String path) {
        return path.isEmpty() ? null : Link.create(path);
    }

    public static Link create(String domain, String path) {
        return new Link(domain, path);
    }

    public static Link create(BaseType data) {
        MultiLink location = MultiLink.from(data);
        if (location != null) {
            return location;
        }
        if (BaseType.isString(data)) {
            return LinkUtils.create(data.asString());
        }
        return null;
    }

    public static BaseType toData(Link link) {
        if (link instanceof IWritableLink) {
            return ((IWritableLink)((Object)link)).toData();
        }
        if (link != null) {
            return new StringType(link.toString());
        }
        return null;
    }

    public static Link copy(Link link) {
        if (link instanceof IWritableLink) {
            return ((IWritableLink)((Object)link)).copy();
        }
        if (link != null) {
            return LinkUtils.create(link.toString());
        }
        return null;
    }
}

