/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.audio;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import mchorse.bbs_mod.audio.Wave;
import mchorse.bbs_mod.audio.Waveform;
import mchorse.bbs_mod.resources.Link;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.openal.AL10;
import org.lwjgl.system.MemoryUtil;

@Environment(value=EnvType.CLIENT)
public class SoundBuffer {
    private final Link id;
    private int buffer;
    private float duration;
    private Waveform waveform;

    public SoundBuffer(Link id, Wave wave, Waveform waveform) {
        this.id = id;
        this.buffer = AL10.alGenBuffers();
        ByteBuffer buffer = MemoryUtil.memAlloc((int)wave.data.length);
        buffer.put(wave.data);
        buffer.flip();
        AL10.alBufferData((int)this.buffer, (int)wave.getALFormat(), (ByteBuffer)buffer, (int)wave.sampleRate);
        MemoryUtil.memFree((Buffer)buffer);
        this.duration = wave.getDuration();
        this.waveform = waveform;
    }

    public Link getId() {
        return this.id;
    }

    public int getBuffer() {
        return this.buffer;
    }

    public float getDuration() {
        return this.duration;
    }

    public Waveform getWaveform() {
        return this.waveform;
    }

    public void delete() {
        AL10.alDeleteBuffers((int)this.buffer);
        this.buffer = -1;
        if (this.waveform != null) {
            this.waveform.delete();
        }
    }
}

