/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.cubic.animation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mchorse.bbs_mod.cubic.animation.ActionConfig;
import mchorse.bbs_mod.data.IMapSerializable;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.MapType;

public class ActionsConfig
implements IMapSerializable {
    private static Map<String, ActionConfig> a = new HashMap<String, ActionConfig>();
    private static Map<String, ActionConfig> b = new HashMap<String, ActionConfig>();
    public Map<String, ActionConfig> actions = new HashMap<String, ActionConfig>();

    public static void removeDefaultActions(Map<String, ActionConfig> map) {
        Iterator<Map.Entry<String, ActionConfig>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ActionConfig> entry = it.next();
            String key = entry.getKey();
            ActionConfig config = entry.getValue();
            if (!config.isDefault(key)) continue;
            it.remove();
        }
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof ActionsConfig) {
            ActionsConfig config = (ActionsConfig)obj;
            a.clear();
            a.putAll(this.actions);
            b.clear();
            b.putAll(config.actions);
            ActionsConfig.removeDefaultActions(a);
            ActionsConfig.removeDefaultActions(b);
            return a.equals(b);
        }
        return false;
    }

    public void copy(ActionsConfig config) {
        this.actions.clear();
        for (Map.Entry<String, ActionConfig> entry : config.actions.entrySet()) {
            this.actions.put(entry.getKey(), entry.getValue().copy());
        }
    }

    public ActionConfig getConfig(String key) {
        ActionConfig output = this.actions.get(key);
        return output == null ? new ActionConfig(key) : output;
    }

    @Override
    public void toData(MapType data) {
        for (Map.Entry<String, ActionConfig> entry : this.actions.entrySet()) {
            if (entry.getValue().isDefault()) {
                if (entry.getValue().name.equals(entry.getKey())) continue;
                data.putString(entry.getKey(), entry.getValue().name);
                continue;
            }
            data.put(entry.getKey(), entry.getValue().toData());
        }
    }

    @Override
    public void fromData(MapType data) {
        this.actions.clear();
        for (Map.Entry<String, BaseType> entry : data) {
            ActionConfig action;
            if (entry.getValue().isMap()) {
                action = new ActionConfig();
                action.fromData(entry.getValue().asMap());
                this.actions.put(entry.getKey(), action);
                continue;
            }
            if (!entry.getValue().isString()) continue;
            action = new ActionConfig();
            action.name = entry.getValue().asString();
            this.actions.put(entry.getKey(), action);
        }
    }
}

