/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.cubic.data.model;

import java.util.ArrayList;
import java.util.List;
import mchorse.bbs_mod.cubic.data.model.ModelQuad;
import mchorse.bbs_mod.cubic.data.model.ModelUV;
import mchorse.bbs_mod.data.DataStorageUtils;
import mchorse.bbs_mod.data.IMapSerializable;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.utils.Quad;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ModelCube
implements IMapSerializable {
    public List<ModelQuad> quads = new ArrayList<ModelQuad>();
    public Vector3f origin = new Vector3f();
    public Vector3f size = new Vector3f();
    public Vector3f pivot = new Vector3f();
    public Vector3f rotate = new Vector3f();
    public float inflate;
    public ModelUV front;
    public ModelUV right;
    public ModelUV back;
    public ModelUV left;
    public ModelUV top;
    public ModelUV bottom;

    public void setupBoxUV(Vector2f boxUV, boolean mirror) {
        float tmp;
        float w = (float)Math.floor(this.size.x);
        float h = (float)Math.floor(this.size.y);
        float d = (float)Math.floor(this.size.z);
        float tMinX = boxUV.x + d;
        float tMinY = boxUV.y + d;
        float tMaxX = tMinX + w;
        float tMaxY = tMinY + h;
        if (mirror) {
            tmp = tMaxX;
            tMaxX = tMinX;
            tMinX = tmp;
        }
        this.front = ModelUV.fromXY(tMinX, tMinY, tMaxX, tMaxY);
        tMinX = boxUV.x;
        tMinY = boxUV.y + d;
        tMaxX = tMinX + d;
        tMaxY = tMinY + h;
        if (mirror) {
            tMinX = boxUV.x + d + w;
            tMinY = boxUV.y + d;
            tMaxX = tMinX + d;
            tMaxY = tMinY + h;
            tmp = tMinX;
            tMinX = tMaxX;
            tMaxX = tmp;
        }
        this.right = ModelUV.fromXY(tMinX, tMinY, tMaxX, tMaxY);
        tMinX = boxUV.x + d * 2.0f + w;
        tMinY = boxUV.y + d;
        tMaxX = tMinX + w;
        tMaxY = tMinY + h;
        if (mirror) {
            tmp = tMaxX;
            tMaxX = tMinX;
            tMinX = tmp;
        }
        this.back = ModelUV.fromXY(tMinX, tMinY, tMaxX, tMaxY);
        tMinX = boxUV.x + d + w;
        tMinY = boxUV.y + d;
        tMaxX = tMinX + d;
        tMaxY = tMinY + h;
        if (mirror) {
            tMinX = boxUV.x;
            tMinY = boxUV.y + d;
            tMaxX = tMinX + d;
            tMaxY = tMinY + h;
            tmp = tMinX;
            tMinX = tMaxX;
            tMaxX = tmp;
        }
        this.left = ModelUV.fromXY(tMinX, tMinY, tMaxX, tMaxY);
        tMinX = boxUV.x + d;
        tMinY = boxUV.y;
        tMaxX = tMinX + w;
        tMaxY = tMinY + d;
        if (mirror) {
            tmp = tMaxX;
            tMaxX = tMinX;
            tMinX = tmp;
        }
        this.top = ModelUV.fromXY(tMaxX, tMaxY, tMinX, tMinY);
        tMinX = boxUV.x + d + w;
        tMinY = boxUV.y + d;
        tMaxX = tMinX + w;
        tMaxY = boxUV.y;
        if (mirror) {
            tmp = tMaxX;
            tMaxX = tMinX;
            tMinX = tmp;
        }
        this.bottom = ModelUV.fromXY(tMaxX, tMaxY, tMinX, tMinY);
    }

    public void generateQuads(int textureWidth, int textureHeight) {
        Quad quad;
        float tw = 1.0f / (float)textureWidth;
        float th = 1.0f / (float)textureHeight;
        float minX = (this.origin.x - this.inflate) / 16.0f;
        float minY = (this.origin.y - this.inflate) / 16.0f;
        float minZ = (this.origin.z - this.inflate) / 16.0f;
        float maxX = (this.origin.x + this.size.x + this.inflate) / 16.0f;
        float maxY = (this.origin.y + this.size.y + this.inflate) / 16.0f;
        float maxZ = (this.origin.z + this.size.z + this.inflate) / 16.0f;
        this.quads.clear();
        if (this.front != null) {
            quad = this.front.createQuad();
            this.quads.add(new ModelQuad().vertex(maxX, minY, minZ, quad.p4.x * tw, quad.p4.y * th).vertex(minX, minY, minZ, quad.p3.x * tw, quad.p3.y * th).vertex(minX, maxY, minZ, quad.p2.x * tw, quad.p2.y * th).vertex(maxX, maxY, minZ, quad.p1.x * tw, quad.p1.y * th).normal(0.0f, 0.0f, -1.0f));
        }
        if (this.right != null) {
            quad = this.right.createQuad();
            this.quads.add(new ModelQuad().vertex(maxX, minY, maxZ, quad.p4.x * tw, quad.p4.y * th).vertex(maxX, minY, minZ, quad.p3.x * tw, quad.p3.y * th).vertex(maxX, maxY, minZ, quad.p2.x * tw, quad.p2.y * th).vertex(maxX, maxY, maxZ, quad.p1.x * tw, quad.p1.y * th).normal(1.0f, 0.0f, 0.0f));
        }
        if (this.back != null) {
            quad = this.back.createQuad();
            this.quads.add(new ModelQuad().vertex(minX, minY, maxZ, quad.p4.x * tw, quad.p4.y * th).vertex(maxX, minY, maxZ, quad.p3.x * tw, quad.p3.y * th).vertex(maxX, maxY, maxZ, quad.p2.x * tw, quad.p2.y * th).vertex(minX, maxY, maxZ, quad.p1.x * tw, quad.p1.y * th).normal(0.0f, 0.0f, 1.0f));
        }
        if (this.left != null) {
            quad = this.left.createQuad();
            this.quads.add(new ModelQuad().vertex(minX, minY, minZ, quad.p4.x * tw, quad.p4.y * th).vertex(minX, minY, maxZ, quad.p3.x * tw, quad.p3.y * th).vertex(minX, maxY, maxZ, quad.p2.x * tw, quad.p2.y * th).vertex(minX, maxY, minZ, quad.p1.x * tw, quad.p1.y * th).normal(-1.0f, 0.0f, 0.0f));
        }
        if (this.top != null) {
            quad = this.top.createQuad();
            this.quads.add(new ModelQuad().vertex(maxX, maxY, minZ, quad.p2.x * tw, quad.p2.y * th).vertex(minX, maxY, minZ, quad.p1.x * tw, quad.p1.y * th).vertex(minX, maxY, maxZ, quad.p4.x * tw, quad.p4.y * th).vertex(maxX, maxY, maxZ, quad.p3.x * tw, quad.p3.y * th).normal(0.0f, 1.0f, 0.0f));
        }
        if (this.bottom != null) {
            quad = this.bottom.createQuad();
            this.quads.add(new ModelQuad().vertex(minX, minY, minZ, quad.p4.x * tw, quad.p4.y * th).vertex(maxX, minY, minZ, quad.p3.x * tw, quad.p3.y * th).vertex(maxX, minY, maxZ, quad.p2.x * tw, quad.p2.y * th).vertex(minX, minY, maxZ, quad.p1.x * tw, quad.p1.y * th).normal(0.0f, -1.0f, 0.0f));
        }
    }

    @Override
    public void toData(MapType data) {
        data.put("from", DataStorageUtils.vector3fToData(this.origin));
        data.put("size", DataStorageUtils.vector3fToData(this.size));
        data.put("origin", DataStorageUtils.vector3fToData(this.pivot));
        if (this.inflate != 0.0f) {
            data.putFloat("offset", this.inflate);
        }
        if (this.rotate.x != 0.0f || this.rotate.y != 0.0f || this.rotate.z != 0.0f) {
            data.put("rotate", DataStorageUtils.vector3fToData(this.rotate));
        }
        MapType uvs = new MapType();
        this.saveUVSide(uvs, "front", this.front);
        this.saveUVSide(uvs, "back", this.back);
        this.saveUVSide(uvs, "right", this.right);
        this.saveUVSide(uvs, "left", this.left);
        this.saveUVSide(uvs, "top", this.top);
        this.saveUVSide(uvs, "bottom", this.bottom);
        if (uvs.size() > 0) {
            data.put("uvs", uvs);
        }
    }

    private void saveUVSide(MapType data, String key, ModelUV side) {
        if (side != null) {
            data.put(key, side.toData());
        }
    }

    @Override
    public void fromData(MapType data) {
        this.origin.set((Vector3fc)DataStorageUtils.vector3fFromData(data.getList("from")));
        this.size.set((Vector3fc)DataStorageUtils.vector3fFromData(data.getList("size")));
        this.pivot.set((Vector3fc)DataStorageUtils.vector3fFromData(data.getList("origin")));
        if (data.has("offset")) {
            this.inflate = data.getFloat("offset");
        }
        if (data.has("rotate")) {
            this.rotate.set((Vector3fc)DataStorageUtils.vector3fFromData(data.getList("rotate")));
        }
        if (data.has("uvs")) {
            this.parseUV(data.get("uvs"));
        }
    }

    private void parseUV(BaseType data) {
        if (data instanceof MapType) {
            MapType sides = (MapType)data;
            if (sides.has("front")) {
                this.front = this.parseUVSide(sides, "front");
            }
            if (sides.has("back")) {
                this.back = this.parseUVSide(sides, "back");
            }
            if (sides.has("right")) {
                this.right = this.parseUVSide(sides, "right");
            }
            if (sides.has("left")) {
                this.left = this.parseUVSide(sides, "left");
            }
            if (sides.has("top")) {
                this.top = this.parseUVSide(sides, "top");
            }
            if (sides.has("bottom")) {
                this.bottom = this.parseUVSide(sides, "bottom");
            }
        }
    }

    private ModelUV parseUVSide(MapType uvs, String name) {
        ModelUV uv = new ModelUV();
        uv.fromData(uvs.getList(name));
        return uv;
    }
}

