/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.cubic.render.vao;

import java.util.ArrayList;
import java.util.List;
import mchorse.bbs_mod.cubic.render.vao.ModelVAOData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4588;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class StructureVAOCollector
implements class_4588 {
    private final List<Float> positions = new ArrayList<Float>();
    private final List<Float> normals = new ArrayList<Float>();
    private final List<Float> texCoords = new ArrayList<Float>();
    private final List<Float> tangents = new ArrayList<Float>();
    private final Vtx[] quad = new Vtx[4];
    private int quadIndex = 0;
    private boolean hasCurrent = false;
    private float vx;
    private float vy;
    private float vz;
    private float vnx;
    private float vny;
    private float vnz;
    private float vu;
    private float vv;

    public StructureVAOCollector() {
        for (int i = 0; i < 4; ++i) {
            this.quad[i] = new Vtx();
        }
    }

    public class_4588 method_22912(float x, float y, float z) {
        if (this.hasCurrent) {
            this.finalizeCurrent();
        }
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.hasCurrent = true;
        return this;
    }

    public class_4588 method_22918(Matrix4f matrix, float x, float y, float z) {
        if (this.hasCurrent) {
            this.finalizeCurrent();
        }
        Vector4f v = new Vector4f(x, y, z, 1.0f);
        v.mul((Matrix4fc)matrix);
        this.vx = v.x;
        this.vy = v.y;
        this.vz = v.z;
        this.hasCurrent = true;
        return this;
    }

    public class_4588 method_1336(int red, int green, int blue, int alpha) {
        return this;
    }

    public class_4588 method_22913(float u, float v) {
        this.vu = u;
        this.vv = v;
        return this;
    }

    public class_4588 method_60796(int u, int v) {
        return this;
    }

    public class_4588 method_22921(int u, int v) {
        return this;
    }

    public class_4588 method_22914(float x, float y, float z) {
        this.vnx = x;
        this.vny = y;
        this.vnz = z;
        return this;
    }

    private void finalizeCurrent() {
        Vtx v = this.quad[this.quadIndex];
        v.x = this.vx;
        v.y = this.vy;
        v.z = this.vz;
        v.nx = this.vnx;
        v.ny = this.vny;
        v.nz = this.vnz;
        v.u = this.vu;
        v.v = this.vv;
        ++this.quadIndex;
        this.hasCurrent = false;
        if (this.quadIndex == 4) {
            this.emitTriangle(this.quad[0], this.quad[1], this.quad[2]);
            this.emitTriangle(this.quad[0], this.quad[2], this.quad[3]);
            this.quadIndex = 0;
        }
    }

    private void emitTriangle(Vtx a, Vtx b, Vtx c) {
        this.positions.add(Float.valueOf(a.x));
        this.positions.add(Float.valueOf(a.y));
        this.positions.add(Float.valueOf(a.z));
        this.positions.add(Float.valueOf(b.x));
        this.positions.add(Float.valueOf(b.y));
        this.positions.add(Float.valueOf(b.z));
        this.positions.add(Float.valueOf(c.x));
        this.positions.add(Float.valueOf(c.y));
        this.positions.add(Float.valueOf(c.z));
        this.normals.add(Float.valueOf(a.nx));
        this.normals.add(Float.valueOf(a.ny));
        this.normals.add(Float.valueOf(a.nz));
        this.normals.add(Float.valueOf(b.nx));
        this.normals.add(Float.valueOf(b.ny));
        this.normals.add(Float.valueOf(b.nz));
        this.normals.add(Float.valueOf(c.nx));
        this.normals.add(Float.valueOf(c.ny));
        this.normals.add(Float.valueOf(c.nz));
        this.texCoords.add(Float.valueOf(a.u));
        this.texCoords.add(Float.valueOf(a.v));
        this.texCoords.add(Float.valueOf(b.u));
        this.texCoords.add(Float.valueOf(b.v));
        this.texCoords.add(Float.valueOf(c.u));
        this.texCoords.add(Float.valueOf(c.v));
        float[] t = this.computeTriangleTangent(a, b, c);
        this.tangents.add(Float.valueOf(t[0]));
        this.tangents.add(Float.valueOf(t[1]));
        this.tangents.add(Float.valueOf(t[2]));
        this.tangents.add(Float.valueOf(1.0f));
        this.tangents.add(Float.valueOf(t[0]));
        this.tangents.add(Float.valueOf(t[1]));
        this.tangents.add(Float.valueOf(t[2]));
        this.tangents.add(Float.valueOf(1.0f));
        this.tangents.add(Float.valueOf(t[0]));
        this.tangents.add(Float.valueOf(t[1]));
        this.tangents.add(Float.valueOf(t[2]));
        this.tangents.add(Float.valueOf(1.0f));
    }

    private float[] computeTriangleTangent(Vtx a, Vtx b, Vtx c) {
        float x1 = b.x - a.x;
        float y1 = b.y - a.y;
        float z1 = b.z - a.z;
        float x2 = c.x - a.x;
        float y2 = c.y - a.y;
        float z2 = c.z - a.z;
        float u1 = b.u - a.u;
        float v2 = c.v - a.v;
        float u2 = c.u - a.u;
        float v1 = b.v - a.v;
        float denom = u1 * v2 - u2 * v1;
        if (Math.abs(denom) < 1.0E-8f) {
            float len = (float)Math.sqrt(x1 * x1 + y1 * y1 + z1 * z1);
            if (len < 1.0E-8f) {
                return new float[]{1.0f, 0.0f, 0.0f};
            }
            return new float[]{x1 / len, y1 / len, z1 / len};
        }
        float f = 1.0f / denom;
        float tx = f * (v2 * x1 - v1 * x2);
        float ty = f * (v2 * y1 - v1 * y2);
        float tz = f * (v2 * z1 - v1 * z2);
        float len = (float)Math.sqrt(tx * tx + ty * ty + tz * tz);
        if (len < 1.0E-8f) {
            return new float[]{1.0f, 0.0f, 0.0f};
        }
        return new float[]{tx / len, ty / len, tz / len};
    }

    public void fixedColor(int red, int green, int blue, int alpha) {
    }

    public void unfixColor() {
    }

    public ModelVAOData toData() {
        if (this.hasCurrent) {
            this.finalizeCurrent();
        }
        float[] v = StructureVAOCollector.toArray(this.positions);
        float[] n = StructureVAOCollector.toArray(this.normals);
        float[] t = StructureVAOCollector.toArray(this.tangents);
        float[] uv = StructureVAOCollector.toArray(this.texCoords);
        return new ModelVAOData(v, n, t, uv);
    }

    private static float[] toArray(List<Float> list) {
        float[] arr = new float[list.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = list.get(i).floatValue();
        }
        return arr;
    }

    @Environment(value=EnvType.CLIENT)
    private static class Vtx {
        float x;
        float y;
        float z;
        float nx;
        float ny;
        float nz;
        float u;
        float v;

        private Vtx() {
        }
    }
}

