/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.data;

import mchorse.bbs_mod.data.DataToString;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.ByteType;
import mchorse.bbs_mod.data.types.DoubleType;
import mchorse.bbs_mod.data.types.FloatType;
import mchorse.bbs_mod.data.types.IntType;
import mchorse.bbs_mod.data.types.ListType;
import mchorse.bbs_mod.data.types.LongType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.data.types.ShortType;
import mchorse.bbs_mod.data.types.StringType;

public class DataParser {
    private String string;
    private int index;

    public static BaseType parse(String string) {
        boolean isMap;
        if ((string = string.trim()).isEmpty()) {
            return null;
        }
        char first = string.charAt(0);
        int size = string.length();
        boolean bl = isMap = first == '{';
        if (isMap || first == '[') {
            int opposite = isMap ? 125 : 93;
            String excerpt = string.substring(1, string.lastIndexOf(opposite));
            return isMap ? DataParser.parseMap(excerpt) : DataParser.parseList(excerpt);
        }
        if (first == '\"') {
            char previous = first;
            for (int i = 1; i < size; ++i) {
                char current = string.charAt(i);
                if (current == '\"' && (previous != '\\' || i == size - 1)) {
                    return new StringType(DataToString.unescape(string.substring(1, i)));
                }
                previous = current;
            }
        }
        return DataParser.parseNumeric(string, size);
    }

    /*
     * Loose catch block
     */
    public static BaseType parseNumeric(String string, int size) {
        block12: {
            if (string.equals("null")) {
                return new ByteType(0);
            }
            boolean aTrue = string.equalsIgnoreCase("true");
            if (aTrue || string.equalsIgnoreCase("false")) {
                return new ByteType(aTrue);
            }
            char last = string.charAt(size - 1);
            if (last == 'b' || last == 'B') {
                return new ByteType((byte)Integer.parseInt(string.substring(0, size - 1)));
            }
            if (last == 's' || last == 'S') {
                return new ShortType((short)Integer.parseInt(string.substring(0, size - 1)));
            }
            if (last == 'f' || last == 'F') {
                return new FloatType(Float.parseFloat(string.substring(0, size - 1)));
            }
            if (last == 'l' || last == 'L') {
                return new LongType(Long.parseLong(string.substring(0, size - 1)));
            }
            if (last == 'd' || last == 'D') {
                return new DoubleType(Double.parseDouble(string.substring(0, size - 1)));
            }
            if (!Character.isDigit(last) || !string.contains(".")) break block12;
            return new DoubleType(Double.parseDouble(string));
            {
                catch (Exception exception) {
                    return null;
                }
            }
        }
        try {
            return new IntType(Integer.parseInt(string));
        }
        catch (Exception e) {
            return new LongType(Long.parseLong(string));
        }
    }

    private static BaseType parseMap(String string) {
        MapType map = new MapType();
        if (string.trim().isEmpty()) {
            return map;
        }
        DataParser parser = new DataParser(string);
        while (true) {
            String key = parser.parseKey();
            String value = parser.parseValue();
            if (value == null) break;
            BaseType type = DataParser.parse(value);
            if (type == null) {
                throw new IllegalStateException("Something went wrong with parsing a map: " + value);
            }
            map.put(key.trim(), type);
        }
        return map;
    }

    private static BaseType parseList(String string) {
        String value;
        ListType list = new ListType();
        if (string.trim().isEmpty()) {
            return list;
        }
        DataParser parser = new DataParser(string);
        while ((value = parser.parseValue()) != null) {
            BaseType type = DataParser.parse(value);
            if (type == null) {
                throw new IllegalStateException("Something went wrong with parsing a list: " + value);
            }
            list.add(type);
        }
        return list;
    }

    public DataParser(String string) {
        this(string, 0);
    }

    public DataParser(String string, int index) {
        this.string = string;
        this.index = index;
    }

    public String parseKey() {
        String s = this.parseUntil(':');
        if (s != null && (s = s.trim()).startsWith("\"") && s.endsWith("\"")) {
            s = DataToString.unescape(s.substring(1, s.length() - 1));
        }
        return s;
    }

    public String parseValue() {
        return this.parseUntil(',');
    }

    public String parseUntil(char stop) {
        int size = this.string.length();
        if (this.index >= size) {
            return null;
        }
        int nesting = 0;
        boolean string = false;
        int previous = 0;
        for (int i = this.index; i < size; ++i) {
            char current = this.string.charAt(i);
            if (current == '\"') {
                if (string && previous == 92) {
                    previous = current;
                    continue;
                }
                boolean bl = string = !string;
            }
            if (string) {
                if (current == '\\' && previous == 92) {
                    previous = 0;
                    continue;
                }
                previous = current;
                continue;
            }
            if (current == '{' || current == '[') {
                ++nesting;
            } else if (current == '}' || current == ']') {
                --nesting;
            }
            if (nesting == 0 && current == stop) {
                return this.setAndReturn(i, 1);
            }
            previous = current;
        }
        return this.setAndReturn(size, 0);
    }

    private String setAndReturn(int i, int offset) {
        String result = this.string.substring(this.index, i);
        this.index = i + offset;
        return result;
    }
}

