/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.film;

import com.mojang.blaze3d.systems.RenderSystem;
import io.netty.util.collection.IntObjectMap;
import mchorse.bbs_mod.film.replays.Replay;
import mchorse.bbs_mod.forms.entities.IEntity;
import mchorse.bbs_mod.ui.framework.elements.utils.StencilMap;
import mchorse.bbs_mod.utils.MatrixStackUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

@Environment(value=EnvType.CLIENT)
public class FilmControllerContext {
    public static final FilmControllerContext instance = new FilmControllerContext();
    public IntObjectMap<IEntity> entities;
    public IEntity entity;
    public Replay replay;
    public class_4184 camera;
    public class_4587 stack;
    public class_4597 consumers;
    public StencilMap map;
    public float transition;
    public int color;
    public float shadowRadius;
    public String bone;
    public boolean local;
    public String bone2;
    public boolean local2;
    public String nameTag = "";
    public boolean relative;

    private FilmControllerContext() {
    }

    private void reset() {
        this.map = null;
        this.shadowRadius = 0.0f;
        this.color = -1;
        this.bone = null;
        this.local = false;
        this.nameTag = "";
        this.relative = false;
    }

    public FilmControllerContext setup(IntObjectMap<IEntity> entities, IEntity entity, Replay replay, WorldRenderContext context) {
        this.reset();
        this.entities = entities;
        this.entity = entity;
        this.replay = replay;
        this.camera = context.camera();
        this.stack = context.matrixStack();
        if (this.stack == null) {
            this.stack = new class_4587();
            MatrixStackUtils.multiply(this.stack, RenderSystem.getModelViewMatrix());
        }
        this.consumers = context.consumers();
        this.transition = context.tickCounter().method_60637(false);
        return this;
    }

    public FilmControllerContext setup(IntObjectMap<IEntity> entities, IEntity entity, Replay replay, class_4184 camera, class_4587 stack, class_4597 consumers, float transition) {
        this.reset();
        this.entities = entities;
        this.entity = entity;
        this.replay = replay;
        this.camera = camera;
        this.stack = stack;
        this.consumers = consumers;
        this.transition = transition;
        return this;
    }

    public FilmControllerContext transition(float transition) {
        this.transition = transition;
        return this;
    }

    public FilmControllerContext stencil(StencilMap map) {
        this.map = map;
        return this;
    }

    public FilmControllerContext shadow(boolean shadow, float shadowRadius) {
        this.shadowRadius = shadow ? shadowRadius : 0.0f;
        return this;
    }

    public FilmControllerContext shadow(float shadowRadius) {
        this.shadowRadius = shadowRadius;
        return this;
    }

    public FilmControllerContext color(int overlayColor) {
        this.color = overlayColor;
        return this;
    }

    public FilmControllerContext bone(String bone, boolean local) {
        this.bone = bone;
        this.local = local;
        return this;
    }

    public FilmControllerContext bone2(String bone, boolean local) {
        this.bone2 = bone;
        this.local2 = local;
        return this;
    }

    public FilmControllerContext nameTag(String nameTag) {
        this.nameTag = nameTag;
        return this;
    }

    public FilmControllerContext relative(boolean relative) {
        this.relative = relative;
        return this;
    }
}

