/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.forms.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.client.BBSRendering;
import mchorse.bbs_mod.client.BBSShaders;
import mchorse.bbs_mod.forms.forms.BillboardForm;
import mchorse.bbs_mod.forms.renderers.FormRenderer;
import mchorse.bbs_mod.forms.renderers.FormRenderingContext;
import mchorse.bbs_mod.forms.renderers.ModelFormRenderer;
import mchorse.bbs_mod.graphics.texture.Texture;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.MatrixStackUtils;
import mchorse.bbs_mod.utils.Quad;
import mchorse.bbs_mod.utils.colors.Color;
import mchorse.bbs_mod.utils.joml.Vectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class BillboardFormRenderer
extends FormRenderer<BillboardForm> {
    private static final Quad quad = new Quad();
    private static final Quad uvQuad = new Quad();
    private static final Matrix4f matrix = new Matrix4f();

    public BillboardFormRenderer(BillboardForm form) {
        super(form);
    }

    @Override
    public void renderInUI(UIContext context, int x1, int y1, int x2, int y2) {
        class_4587 stack = context.batcher.getContext().method_51448();
        stack.method_22903();
        Matrix4f uiMatrix = ModelFormRenderer.getUIMatrix(context, x1, y1, x2, y2);
        this.applyTransforms(uiMatrix, context.getTransition());
        MatrixStackUtils.multiply(stack, uiMatrix);
        stack.method_46416(0.0f, 1.0f, 0.0f);
        stack.method_22905(1.5f, 1.5f, 1.5f);
        stack.method_22905(((Float)((BillboardForm)this.form).uiScale.get()).floatValue(), ((Float)((BillboardForm)this.form).uiScale.get()).floatValue(), ((Float)((BillboardForm)this.form).uiScale.get()).floatValue());
        class_293 format = class_290.field_1580;
        this.renderModel(format, class_757::method_34508, stack, class_4608.field_21444, 0xF000F0, -1, context.getTransition());
        stack.method_22909();
    }

    @Override
    public void render3D(FormRenderingContext context) {
        boolean shading = (Boolean)((BillboardForm)this.form).shading.get();
        if (BBSRendering.isIrisShadersEnabled()) {
            shading = true;
        }
        class_293 format = shading ? class_290.field_1580 : class_290.field_1575;
        Supplier<class_5944> shader = this.getShader(context, shading ? class_757::method_34508 : class_757::method_34543, shading ? BBSShaders::getPickerBillboardProgram : BBSShaders::getPickerBillboardNoShadingProgram);
        this.renderModel(format, shader, context.stack, context.overlay, context.light, context.color, context.getTransition());
    }

    private void renderModel(class_293 format, Supplier<class_5944> shader, class_4587 matrices, int overlay, int light, int overlayColor, float transition) {
        Link t = (Link)((BillboardForm)this.form).texture.get();
        if (t == null) {
            return;
        }
        Texture texture = BBSModClient.getTextures().getTexture(t);
        float w = texture.width;
        float h = texture.height;
        float ow = w;
        float oh = h;
        Vector4f crop = (Vector4f)((BillboardForm)this.form).crop.get();
        float uvTLx = crop.x / w;
        float uvTLy = crop.y / h;
        float uvBRx = 1.0f - crop.z / w;
        float uvBRy = 1.0f - crop.w / h;
        BillboardFormRenderer.uvQuad.p1.set(uvTLx, uvTLy, 0.0f);
        BillboardFormRenderer.uvQuad.p2.set(uvBRx, uvTLy, 0.0f);
        BillboardFormRenderer.uvQuad.p3.set(uvTLx, uvBRy, 0.0f);
        BillboardFormRenderer.uvQuad.p4.set(uvBRx, uvBRy, 0.0f);
        float uvFinalTLx = uvTLx;
        float uvFinalTLy = uvTLy;
        float uvFinalBRx = uvBRx;
        float uvFinalBRy = uvBRy;
        if (((Boolean)((BillboardForm)this.form).resizeCrop.get()).booleanValue()) {
            uvFinalTLy = 0.0f;
            uvFinalTLx = 0.0f;
            uvFinalBRy = 1.0f;
            uvFinalBRx = 1.0f;
            w = w - crop.x - crop.z;
            h = h - crop.y - crop.w;
        }
        float ratioX = w > h ? h / w : 1.0f;
        float ratioY = h > w ? w / h : 1.0f;
        float TLx = (uvFinalTLx - 0.5f) * ratioY;
        float TLy = -(uvFinalTLy - 0.5f) * ratioX;
        float BRx = (uvFinalBRx - 0.5f) * ratioY;
        float BRy = -(uvFinalBRy - 0.5f) * ratioX;
        BillboardFormRenderer.quad.p1.set(TLx, TLy, 0.0f);
        BillboardFormRenderer.quad.p2.set(BRx, TLy, 0.0f);
        BillboardFormRenderer.quad.p3.set(TLx, BRy, 0.0f);
        BillboardFormRenderer.quad.p4.set(BRx, BRy, 0.0f);
        float offsetX = ((Float)((BillboardForm)this.form).offsetX.get()).floatValue();
        float offsetY = ((Float)((BillboardForm)this.form).offsetY.get()).floatValue();
        float rotation = ((Float)((BillboardForm)this.form).rotation.get()).floatValue();
        if (offsetX != 0.0f || offsetY != 0.0f || rotation != 0.0f) {
            float centerX = (crop.x + (ow - crop.z)) / 2.0f / ow;
            float centerY = (crop.y + (oh - crop.w)) / 2.0f / ow;
            matrix.identity().translate(centerX, centerY, 0.0f).rotateZ(MathUtils.toRad(rotation)).translate(offsetX / ow, offsetY / oh, 0.0f).translate(-centerX, -centerY, 0.0f);
            uvQuad.transform(matrix);
        }
        this.renderQuad(format, texture, shader, matrices, overlay, light, overlayColor, transition);
    }

    private void renderQuad(class_293 format, Texture texture, Supplier<class_5944> shader, class_4587 matrices, int overlay, int light, int overlayColor, float transition) {
        class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27379, format);
        Color color = ((Color)((BillboardForm)this.form).color.get()).copy();
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_4587.class_4665 entry = matrices.method_23760();
        color.mul(overlayColor);
        if (((Boolean)((BillboardForm)this.form).billboard.get()).booleanValue()) {
            Matrix4f modelMatrix = matrices.method_23760().method_23761();
            Vector3f scale = Vectors.TEMP_3F;
            modelMatrix.getScale(scale);
            modelMatrix.m00(1.0f).m01(0.0f).m02(0.0f);
            modelMatrix.m10(0.0f).m11(1.0f).m12(0.0f);
            modelMatrix.m20(0.0f).m21(0.0f).m22(1.0f);
            modelMatrix.scale((Vector3fc)scale);
            matrices.method_23760().method_23762().identity();
        }
        class_757 gameRenderer = class_310.method_1551().field_1773;
        if (format == class_290.field_1580) {
            gameRenderer.method_22974().method_3316();
            gameRenderer.method_22975().method_23209();
        }
        BBSModClient.getTextures().bindTexture(texture);
        RenderSystem.setShader(shader);
        texture.bind();
        texture.setFilterMipmap((Boolean)((BillboardForm)this.form).linear.get(), (Boolean)((BillboardForm)this.form).mipmap.get());
        this.fill(format, (class_4588)builder, matrix, BillboardFormRenderer.quad.p3.x, BillboardFormRenderer.quad.p3.y, color, BillboardFormRenderer.uvQuad.p3.x, BillboardFormRenderer.uvQuad.p3.y, overlay, light, entry, 1.0f);
        this.fill(format, (class_4588)builder, matrix, BillboardFormRenderer.quad.p2.x, BillboardFormRenderer.quad.p2.y, color, BillboardFormRenderer.uvQuad.p2.x, BillboardFormRenderer.uvQuad.p2.y, overlay, light, entry, 1.0f);
        this.fill(format, (class_4588)builder, matrix, BillboardFormRenderer.quad.p1.x, BillboardFormRenderer.quad.p1.y, color, BillboardFormRenderer.uvQuad.p1.x, BillboardFormRenderer.uvQuad.p1.y, overlay, light, entry, 1.0f);
        this.fill(format, (class_4588)builder, matrix, BillboardFormRenderer.quad.p3.x, BillboardFormRenderer.quad.p3.y, color, BillboardFormRenderer.uvQuad.p3.x, BillboardFormRenderer.uvQuad.p3.y, overlay, light, entry, 1.0f);
        this.fill(format, (class_4588)builder, matrix, BillboardFormRenderer.quad.p4.x, BillboardFormRenderer.quad.p4.y, color, BillboardFormRenderer.uvQuad.p4.x, BillboardFormRenderer.uvQuad.p4.y, overlay, light, entry, 1.0f);
        this.fill(format, (class_4588)builder, matrix, BillboardFormRenderer.quad.p2.x, BillboardFormRenderer.quad.p2.y, color, BillboardFormRenderer.uvQuad.p2.x, BillboardFormRenderer.uvQuad.p2.y, overlay, light, entry, 1.0f);
        this.fill(format, (class_4588)builder, matrix, BillboardFormRenderer.quad.p1.x, BillboardFormRenderer.quad.p1.y, color, BillboardFormRenderer.uvQuad.p1.x, BillboardFormRenderer.uvQuad.p1.y, overlay, light, entry, -1.0f);
        this.fill(format, (class_4588)builder, matrix, BillboardFormRenderer.quad.p2.x, BillboardFormRenderer.quad.p2.y, color, BillboardFormRenderer.uvQuad.p2.x, BillboardFormRenderer.uvQuad.p2.y, overlay, light, entry, -1.0f);
        this.fill(format, (class_4588)builder, matrix, BillboardFormRenderer.quad.p3.x, BillboardFormRenderer.quad.p3.y, color, BillboardFormRenderer.uvQuad.p3.x, BillboardFormRenderer.uvQuad.p3.y, overlay, light, entry, -1.0f);
        this.fill(format, (class_4588)builder, matrix, BillboardFormRenderer.quad.p2.x, BillboardFormRenderer.quad.p2.y, color, BillboardFormRenderer.uvQuad.p2.x, BillboardFormRenderer.uvQuad.p2.y, overlay, light, entry, -1.0f);
        this.fill(format, (class_4588)builder, matrix, BillboardFormRenderer.quad.p4.x, BillboardFormRenderer.quad.p4.y, color, BillboardFormRenderer.uvQuad.p4.x, BillboardFormRenderer.uvQuad.p4.y, overlay, light, entry, -1.0f);
        this.fill(format, (class_4588)builder, matrix, BillboardFormRenderer.quad.p3.x, BillboardFormRenderer.quad.p3.y, color, BillboardFormRenderer.uvQuad.p3.x, BillboardFormRenderer.uvQuad.p3.y, overlay, light, entry, -1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableBlend();
        class_286.method_43433((class_9801)builder.method_60800());
        texture.setFilterMipmap(false, false);
        if (format == class_290.field_1580) {
            gameRenderer.method_22974().method_3315();
            gameRenderer.method_22975().method_23213();
        }
    }

    private class_4588 fill(class_293 format, class_4588 consumer, Matrix4f matrix, float x, float y, Color color, float u, float v, int overlay, int light, class_4587.class_4665 entry, float nz) {
        if (format == class_290.field_1586) {
            return consumer.method_22918(matrix, x, y, 0.0f).method_22913(u, v).method_60803(light).method_22915(color.r, color.g, color.b, color.a);
        }
        if (format == class_290.field_1575) {
            return consumer.method_22918(matrix, x, y, 0.0f).method_22913(u, v).method_22915(color.r, color.g, color.b, color.a);
        }
        return consumer.method_22918(matrix, x, y, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_22913(u, v).method_22922(overlay).method_60803(light).method_60831(entry, 0.0f, 0.0f, nz);
    }
}

