/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.forms.renderers;

import java.util.function.Supplier;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.client.BBSRendering;
import mchorse.bbs_mod.client.BBSShaders;
import mchorse.bbs_mod.forms.ITickable;
import mchorse.bbs_mod.forms.entities.IEntity;
import mchorse.bbs_mod.forms.forms.ParticleForm;
import mchorse.bbs_mod.forms.renderers.FormRenderer;
import mchorse.bbs_mod.forms.renderers.FormRenderingContext;
import mchorse.bbs_mod.particles.ParticleScheme;
import mchorse.bbs_mod.particles.emitter.ParticleEmitter;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.utils.MatrixStackUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class ParticleFormRenderer
extends FormRenderer<ParticleForm>
implements ITickable {
    public static long lastUpdate = 0L;
    private ParticleEmitter emitter;
    private boolean checked;
    private boolean restart;
    private long lastParticleUpdate = lastUpdate;

    public ParticleFormRenderer(ParticleForm form) {
        super(form);
    }

    public ParticleEmitter getEmitter() {
        return this.emitter;
    }

    public void ensureEmitter(class_1937 world, float transition) {
        if (this.lastParticleUpdate < lastUpdate) {
            this.lastParticleUpdate = lastUpdate;
            this.checked = false;
        }
        if (!this.checked) {
            ParticleScheme scheme = (ParticleScheme)BBSModClient.getParticles().load((String)((ParticleForm)this.form).effect.get());
            if (scheme != null) {
                this.emitter = new ParticleEmitter();
                this.emitter.setScheme(scheme);
                this.emitter.setWorld(world);
            }
            this.checked = true;
        }
        if (this.emitter != null && !BBSRendering.isIrisShadowPass()) {
            boolean lastPaused = this.emitter.paused;
            this.emitter.paused = (Boolean)((ParticleForm)this.form).paused.get();
            if (lastPaused != this.emitter.paused && !this.emitter.paused && this.emitter.age > 0 && !this.restart) {
                this.restart = true;
            }
        }
    }

    @Override
    public void renderInUI(UIContext context, int x1, int y1, int x2, int y2) {
        this.ensureEmitter((class_1937)class_310.method_1551().field_1687, context.getTransition());
        ParticleEmitter emitter = this.emitter;
        if (emitter != null && emitter.scheme != null) {
            class_4587 stack = context.batcher.getContext().method_51448();
            int scale = (y2 - y1) / 2;
            stack.method_22903();
            stack.method_46416((float)(x2 + x1) / 2.0f, (float)(y2 + y1) / 2.0f, 40.0f);
            MatrixStackUtils.scaleStack(stack, scale, -scale, scale);
            this.updateTexture(context.getTransition());
            emitter.lastGlobal.set(0.0, 0.0, 0.0);
            emitter.rotation.identity();
            emitter.renderUI(stack, context.getTransition());
            stack.method_22909();
        }
    }

    @Override
    public void render3D(FormRenderingContext context) {
        this.ensureEmitter((class_1937)class_310.method_1551().field_1687, context.transition);
        ParticleEmitter emitter = this.emitter;
        if (emitter != null) {
            emitter.setUserVariables(((Float)((ParticleForm)this.form).user1.get()).floatValue(), ((Float)((ParticleForm)this.form).user2.get()).floatValue(), ((Float)((ParticleForm)this.form).user3.get()).floatValue(), ((Float)((ParticleForm)this.form).user4.get()).floatValue(), ((Float)((ParticleForm)this.form).user5.get()).floatValue(), ((Float)((ParticleForm)this.form).user6.get()).floatValue());
            this.updateTexture(context.getTransition());
            class_757 gameRenderer = class_310.method_1551().field_1773;
            gameRenderer.method_22974().method_3316();
            gameRenderer.method_22975().method_23209();
            if (context.modelRenderer) {
                emitter.lastGlobal.set(0.0, 0.0, 0.0);
                emitter.rotation.identity();
                emitter.setupCameraProperties(context.camera);
                emitter.cX = 0.0;
                emitter.cY = 0.0;
                emitter.cZ = 0.0;
                if (!BBSRendering.isIrisShadowPass()) {
                    boolean shadersEnabled = BBSRendering.isIrisShadersEnabled();
                    class_293 format = shadersEnabled ? class_290.field_1580 : class_290.field_1584;
                    Supplier<class_5944> shader = shadersEnabled ? this.getShader(context, class_757::method_34508, BBSShaders::getPickerBillboardProgram) : this.getShader(context, class_757::method_34546, BBSShaders::getPickerParticlesProgram);
                    Matrix4f currentMatrix = new Matrix4f((Matrix4fc)context.stack.method_23760().method_23761());
                    Matrix4f inverseViewTransform = new Matrix4f().translate((float)context.camera.position.x, (float)context.camera.position.y, (float)context.camera.position.z).mul((Matrix4fc)new Matrix4f((Matrix4fc)context.camera.view).invert());
                    Matrix4f localMatrix = new Matrix4f((Matrix4fc)inverseViewTransform).mul((Matrix4fc)currentMatrix);
                    context.stack.method_22903();
                    context.stack.method_34426();
                    context.stack.method_34425(localMatrix);
                    emitter.render(format, shader, context.stack, context.overlay, context.getTransition());
                    context.stack.method_22909();
                }
            } else {
                class_4184 camera = class_310.method_1551().field_1773.method_19418();
                Matrix4f positionMatrix = new Matrix4f((Matrix4fc)context.stack.method_23760().method_23761());
                Quaternionf cameraRotation = camera.method_23767();
                Quaternionf inverseCameraRotation = new Quaternionf((Quaternionfc)cameraRotation).conjugate();
                Matrix4f inverseViewRotation = new Matrix4f().rotation((Quaternionfc)inverseCameraRotation);
                Matrix4f worldMatrix = new Matrix4f((Matrix4fc)inverseViewRotation).mul((Matrix4fc)positionMatrix);
                Vector3f worldSpaceOffset = worldMatrix.getTranslation(new Vector3f());
                Vector3d worldPosition = new Vector3d((double)worldSpaceOffset.x + camera.method_19326().field_1352, (double)worldSpaceOffset.y + camera.method_19326().field_1351, (double)worldSpaceOffset.z + camera.method_19326().field_1350);
                emitter.lastGlobal.set((Vector3dc)worldPosition);
                emitter.rotation.set((Matrix4fc)worldMatrix);
                if (!BBSRendering.isIrisShadowPass()) {
                    boolean shadersEnabled = BBSRendering.isIrisShadersEnabled();
                    class_293 format = shadersEnabled ? class_290.field_1580 : class_290.field_1584;
                    Supplier<class_5944> shader = shadersEnabled ? this.getShader(context, class_757::method_34508, BBSShaders::getPickerBillboardProgram) : this.getShader(context, class_757::method_34546, BBSShaders::getPickerParticlesProgram);
                    emitter.setupCameraProperties(camera);
                    context.stack.method_22903();
                    context.stack.method_34426();
                    context.stack.method_34425(new Matrix4f((Matrix4fc)inverseViewRotation).invert());
                    emitter.render(format, shader, context.stack, context.overlay, context.getTransition());
                    context.stack.method_22909();
                }
            }
            gameRenderer.method_22974().method_3315();
            gameRenderer.method_22975().method_23213();
        }
    }

    private void updateTexture(float transition) {
        if (this.emitter != null) {
            this.emitter.texture = (Link)((ParticleForm)this.form).texture.get();
        }
    }

    @Override
    public void tick(IEntity entity) {
        this.ensureEmitter(entity.getWorld(), 0.0f);
        if (this.emitter != null) {
            if (this.restart) {
                this.emitter.stop();
                this.emitter.start();
                this.restart = false;
            }
            this.emitter.update();
        }
    }
}

