/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.forms.states;

import java.util.ArrayList;
import mchorse.bbs_mod.forms.states.AnimationState;
import mchorse.bbs_mod.settings.values.core.ValueList;
import mchorse.bbs_mod.utils.CollectionUtils;

public class AnimationStates
extends ValueList<AnimationState> {
    public AnimationStates(String id) {
        super(id);
    }

    public AnimationState getById(String triggerId) {
        for (AnimationState state : this.list) {
            if (!((String)state.id.get()).equals(triggerId) && !((String)state.customId.get()).equals(triggerId)) continue;
            return state;
        }
        return null;
    }

    public AnimationState getMain() {
        for (AnimationState state : this.list) {
            if (!((Boolean)state.main.get()).booleanValue()) continue;
            return state;
        }
        return null;
    }

    public AnimationState getMainRandom() {
        ArrayList<AnimationState> states = new ArrayList<AnimationState>();
        for (AnimationState state : this.list) {
            if (!((Boolean)state.main.get()).booleanValue()) continue;
            states.add(state);
        }
        if (!states.isEmpty()) {
            int index = (int)(Math.random() * (double)states.size());
            return (AnimationState)CollectionUtils.getSafe(states, index);
        }
        return null;
    }

    public AnimationState addState() {
        this.preNotify(1);
        AnimationState state = this.create(String.valueOf(this.list.size()));
        this.add(state);
        this.postNotify(1);
        return state;
    }

    public void removeState(int index) {
        this.preNotify(1);
        if (this.list.remove(index) != null) {
            this.sync();
        }
        this.postNotify(1);
    }

    public void cleanUp() {
        for (AnimationState state : this.list) {
            state.properties.cleanUp();
        }
    }

    @Override
    protected AnimationState create(String id) {
        return new AnimationState(id);
    }
}

