/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.graphics;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import mchorse.bbs_mod.graphics.Framebuffer;
import mchorse.bbs_mod.resources.Link;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class FramebufferManager {
    public final Map<Link, Framebuffer> framebuffers = new HashMap<Link, Framebuffer>();

    public Framebuffer getFramebuffer(Link key, Consumer<Framebuffer> setup) {
        Framebuffer framebuffer = this.framebuffers.get(key);
        if (framebuffer == null) {
            framebuffer = new Framebuffer();
            setup.accept(framebuffer);
            this.framebuffers.put(key, framebuffer);
        }
        return framebuffer;
    }

    public void delete() {
        for (Framebuffer framebuffer : this.framebuffers.values()) {
            framebuffer.delete();
        }
        this.framebuffers.clear();
    }
}

