/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.particles.components.appearance;

import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.ListType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.math.molang.MolangException;
import mchorse.bbs_mod.math.molang.MolangParser;
import mchorse.bbs_mod.math.molang.expressions.MolangExpression;
import mchorse.bbs_mod.particles.components.IComponentParticleRender;
import mchorse.bbs_mod.particles.components.ParticleComponentBase;
import mchorse.bbs_mod.particles.components.appearance.CameraFacing;
import mchorse.bbs_mod.particles.emitter.Particle;
import mchorse.bbs_mod.particles.emitter.ParticleEmitter;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.interps.Lerps;
import mchorse.bbs_mod.utils.joml.Matrices;
import mchorse.bbs_mod.utils.joml.Vectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_761;
import net.minecraft.class_765;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class ParticleComponentAppearanceBillboard
extends ParticleComponentBase
implements IComponentParticleRender {
    public MolangExpression sizeW = MolangParser.ZERO;
    public MolangExpression sizeH = MolangParser.ZERO;
    public CameraFacing facing = CameraFacing.LOOKAT_XYZ;
    public int textureWidth = 128;
    public int textureHeight = 128;
    public MolangExpression uvX = MolangParser.ZERO;
    public MolangExpression uvY = MolangParser.ZERO;
    public MolangExpression uvW = MolangParser.ZERO;
    public MolangExpression uvH = MolangParser.ZERO;
    public boolean flipbook = false;
    public float stepX;
    public float stepY;
    public float fps;
    public MolangExpression maxFrame = MolangParser.ZERO;
    public boolean stretchFPS = false;
    public boolean loop = false;
    private float w;
    private float h;
    private float u1;
    private float v1;
    private float u2;
    private float v2;
    private int light;
    private Matrix4f transform = new Matrix4f();
    private Matrix4f rotation = new Matrix4f();
    private Vector4f[] vertices = new Vector4f[]{new Vector4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector4f(0.0f, 0.0f, 0.0f, 1.0f)};
    private Vector3f vector = new Vector3f();
    private Vector3f n = new Vector3f();

    @Override
    protected void toData(MapType data) {
        ListType uvs;
        ListType size = new ListType();
        MapType uv = new MapType();
        size.add(this.sizeW.toData());
        size.add(this.sizeH.toData());
        uv.putInt("texture_width", this.textureWidth);
        uv.putInt("texture_height", this.textureHeight);
        if (!this.flipbook && !MolangExpression.isZero(this.uvX) || !MolangExpression.isZero(this.uvY)) {
            uvs = new ListType();
            uvs.add(this.uvX.toData());
            uvs.add(this.uvY.toData());
            uv.put("uv", uvs);
        }
        if (!this.flipbook && !MolangExpression.isZero(this.uvW) || !MolangExpression.isZero(this.uvH)) {
            uvs = new ListType();
            uvs.add(this.uvW.toData());
            uvs.add(this.uvH.toData());
            uv.put("uv_size", uvs);
        }
        if (this.flipbook) {
            MapType flipbook = new MapType();
            if (!MolangExpression.isZero(this.uvX) || !MolangExpression.isZero(this.uvY)) {
                ListType base = new ListType();
                base.add(this.uvX.toData());
                base.add(this.uvY.toData());
                flipbook.put("base_UV", base);
            }
            if (!MolangExpression.isZero(this.uvW) || !MolangExpression.isZero(this.uvH)) {
                ListType uvSize = new ListType();
                uvSize.add(this.uvW.toData());
                uvSize.add(this.uvH.toData());
                flipbook.put("size_UV", uvSize);
            }
            if (this.stepX != 0.0f || this.stepY != 0.0f) {
                ListType step = new ListType();
                step.addFloat(this.stepX);
                step.addFloat(this.stepY);
                flipbook.put("step_UV", step);
            }
            if (this.fps != 0.0f) {
                flipbook.putFloat("frames_per_second", this.fps);
            }
            if (!MolangExpression.isZero(this.maxFrame)) {
                flipbook.put("max_frame", this.maxFrame.toData());
            }
            if (this.stretchFPS) {
                flipbook.putBool("stretch_to_lifetime", true);
            }
            if (this.loop) {
                flipbook.putBool("loop", true);
            }
            uv.put("flipbook", flipbook);
        }
        data.put("size", size);
        data.putString("facing_camera_mode", this.facing.id);
        data.put("uv", uv);
    }

    @Override
    public ParticleComponentBase fromData(BaseType data, MolangParser parser) throws MolangException {
        ListType size;
        if (!data.isMap()) {
            return super.fromData(data, parser);
        }
        MapType map = data.asMap();
        if (map.has("size", 1) && (size = map.getList("size")).size() >= 2) {
            this.sizeW = parser.parseDataSilently(size.get(0), MolangParser.ONE);
            this.sizeH = parser.parseDataSilently(size.get(1), MolangParser.ONE);
        }
        if (map.has("facing_camera_mode")) {
            this.facing = CameraFacing.fromString(map.getString("facing_camera_mode"));
        }
        if (map.has("uv", 0)) {
            this.parseUv(map.getMap("uv"), parser);
        }
        return super.fromData(map, parser);
    }

    private void parseUv(MapType data, MolangParser parser) throws MolangException {
        ListType uv;
        if (data.has("texture_width")) {
            this.textureWidth = data.getInt("texture_width");
        }
        if (data.has("texture_height")) {
            this.textureHeight = data.getInt("texture_height");
        }
        if (data.has("uv", 1) && (uv = data.getList("uv")).size() >= 2) {
            this.uvX = parser.parseDataSilently(uv.get(0));
            this.uvY = parser.parseDataSilently(uv.get(1));
        }
        if (data.has("uv_size", 1) && (uv = data.getList("uv_size")).size() >= 2) {
            this.uvW = parser.parseDataSilently(uv.get(0), MolangParser.ONE);
            this.uvH = parser.parseDataSilently(uv.get(1), MolangParser.ONE);
        }
        if (data.has("flipbook", 0)) {
            this.flipbook = true;
            this.parseFlipbook(data.getMap("flipbook"), parser);
        }
    }

    private void parseFlipbook(MapType flipbook, MolangParser parser) throws MolangException {
        ListType uv;
        if (flipbook.has("base_UV", 1) && (uv = flipbook.getList("base_UV")).size() >= 2) {
            this.uvX = parser.parseDataSilently(uv.get(0));
            this.uvY = parser.parseDataSilently(uv.get(1));
        }
        if (flipbook.has("size_UV", 1) && (uv = flipbook.getList("size_UV")).size() >= 2) {
            this.uvW = parser.parseDataSilently(uv.get(0));
            this.uvH = parser.parseDataSilently(uv.get(1));
        }
        if (flipbook.has("step_UV", 1) && (uv = flipbook.getList("step_UV")).size() >= 2) {
            this.stepX = uv.getFloat(0);
            this.stepY = uv.getFloat(1);
        }
        if (flipbook.has("frames_per_second")) {
            this.fps = flipbook.getFloat("frames_per_second");
        }
        if (flipbook.has("max_frame")) {
            this.maxFrame = parser.parseDataSilently(flipbook.get("max_frame"));
        }
        if (flipbook.has("stretch_to_lifetime")) {
            this.stretchFPS = flipbook.getBool("stretch_to_lifetime");
        }
        if (flipbook.has("loop")) {
            this.loop = flipbook.getBool("loop");
        }
    }

    @Override
    public void preRender(ParticleEmitter emitter, float transition) {
    }

    @Override
    public void render(ParticleEmitter emitter, class_293 format, Particle particle, class_287 builder, Matrix4f matrix, int overlay, float transition) {
        boolean lookAt;
        boolean staticSpace;
        this.calculateUVs(particle, emitter, transition);
        double px = Lerps.lerp(particle.prevPosition.x, particle.position.x, (double)transition);
        double py = Lerps.lerp(particle.prevPosition.y, particle.position.y, (double)transition);
        double pz = Lerps.lerp(particle.prevPosition.z, particle.position.z, (double)transition);
        float angle = Lerps.lerp(particle.prevRotation, particle.rotation, transition);
        float scale = 1.0f;
        boolean bl = staticSpace = particle.relativePosition && particle.relativeRotation;
        if (staticSpace) {
            this.vector.set((float)px, (float)py, (float)pz);
            emitter.rotation.transform(this.vector);
            px = this.vector.x;
            py = this.vector.y;
            pz = this.vector.z;
            px += emitter.lastGlobal.x;
            py += emitter.lastGlobal.y;
            pz += emitter.lastGlobal.z;
        }
        if (particle.textureScale) {
            scale = (staticSpace ? emitter.rotation : particle.matrix).getRow(0, Vectors.TEMP_3F).length();
        }
        float entityYaw = emitter.cYaw;
        float entityPitch = emitter.cPitch;
        double entityX = emitter.cX;
        double entityY = emitter.cY;
        double entityZ = emitter.cZ;
        boolean bl2 = lookAt = this.facing == CameraFacing.LOOKAT_XYZ || this.facing == CameraFacing.LOOKAT_Y;
        if (lookAt) {
            double dX = entityX - px;
            double dY = entityY - py;
            double dZ = entityZ - pz;
            double horizontalDistance = Math.sqrt(dX * dX + dZ * dZ);
            entityYaw = 180.0f - (float)(Math.atan2(dZ, dX) * 57.29577951308232) - 90.0f;
            entityPitch = (float)(-(Math.atan2(dY, horizontalDistance) * 57.29577951308232)) + 180.0f;
        }
        px -= emitter.cX;
        py -= emitter.cY;
        pz -= emitter.cZ;
        this.vertices[0].set(-this.w / 2.0f, -this.h / 2.0f, 0.0f, 1.0f);
        this.vertices[1].set(this.w / 2.0f, -this.h / 2.0f, 0.0f, 1.0f);
        this.vertices[2].set(this.w / 2.0f, this.h / 2.0f, 0.0f, 1.0f);
        this.vertices[3].set(-this.w / 2.0f, this.h / 2.0f, 0.0f, 1.0f);
        this.transform.identity();
        if (this.facing == CameraFacing.ROTATE_XYZ || this.facing == CameraFacing.LOOKAT_XYZ) {
            this.rotation.identity();
            this.rotation.rotateY(entityYaw / 180.0f * (float)Math.PI);
            this.transform.mul((Matrix4fc)this.rotation);
            this.rotation.identity();
            this.rotation.rotateX(entityPitch / 180.0f * (float)Math.PI);
            this.transform.mul((Matrix4fc)this.rotation);
        } else if (this.facing == CameraFacing.ROTATE_Y || this.facing == CameraFacing.LOOKAT_Y) {
            this.rotation.identity();
            this.rotation.rotateY(entityYaw / 180.0f * (float)Math.PI);
            this.transform.mul((Matrix4fc)this.rotation);
        }
        if (format != class_290.field_1584) {
            this.n.set(0.0f, 0.0f, 1.0f);
            Matrices.EMPTY_3F.set((Matrix4fc)this.transform).transform(this.n);
            this.n.normalize();
        }
        this.rotation.identity();
        this.rotation.rotateZ(angle / 180.0f * (float)Math.PI);
        this.transform.mul((Matrix4fc)this.rotation);
        this.transform.scale(scale);
        this.transform.setTranslation((Vector3fc)new Vector3f((float)px, (float)py, (float)pz));
        this.build(builder, format, matrix, particle, overlay);
    }

    private void build(class_287 builder, class_293 format, Matrix4f matrix, Particle particle, int overlay) {
        float u1 = this.u1 / (float)this.textureWidth;
        float u2 = this.u2 / (float)this.textureWidth;
        float v1 = this.v1 / (float)this.textureHeight;
        float v2 = this.v2 / (float)this.textureHeight;
        for (Vector4f vertex : this.vertices) {
            this.transform.transform(vertex);
        }
        this.writeVertex(builder, format, matrix, this.vertices[0], u2, v2, overlay, particle);
        this.writeVertex(builder, format, matrix, this.vertices[1], u1, v2, overlay, particle);
        this.writeVertex(builder, format, matrix, this.vertices[2], u1, v1, overlay, particle);
        this.writeVertex(builder, format, matrix, this.vertices[2], u1, v1, overlay, particle);
        this.writeVertex(builder, format, matrix, this.vertices[3], u2, v1, overlay, particle);
        this.writeVertex(builder, format, matrix, this.vertices[0], u2, v2, overlay, particle);
    }

    private void writeVertex(class_287 builder, class_293 format, Matrix4f matrix, Vector4f vertex, float u, float v, int overlay, Particle particle) {
        if (format == class_290.field_1584) {
            builder.method_22918(matrix, vertex.x, vertex.y, vertex.z).method_22913(u, v).method_22915(particle.r, particle.g, particle.b, particle.a).method_60803(this.light);
        } else {
            builder.method_22918(matrix, vertex.x, vertex.y, vertex.z).method_22915(particle.r, particle.g, particle.b, particle.a).method_22913(u, v).method_22922(overlay).method_60803(this.light).method_22914(this.n.x, this.n.y, this.n.z);
        }
    }

    @Override
    public void renderUI(Particle particle, class_287 builder, Matrix4f matrix, float transition) {
        this.calculateUVs(particle, null, transition);
        this.h = 0.5f;
        this.w = 0.5f;
        float angle = Lerps.lerp(particle.prevRotation, particle.rotation, transition);
        this.vertices[0].set(-this.w / 2.0f, -this.h / 2.0f, 0.0f, 1.0f);
        this.vertices[1].set(this.w / 2.0f, -this.h / 2.0f, 0.0f, 1.0f);
        this.vertices[2].set(this.w / 2.0f, this.h / 2.0f, 0.0f, 1.0f);
        this.vertices[3].set(-this.w / 2.0f, this.h / 2.0f, 0.0f, 1.0f);
        this.transform.identity();
        this.transform.scale(2.5f);
        this.rotation.identity();
        this.rotation.rotateZ(angle / 180.0f * (float)Math.PI);
        this.transform.mul((Matrix4fc)this.rotation);
        this.buildUI(builder, matrix, particle);
    }

    private void buildUI(class_287 builder, Matrix4f matrix, Particle particle) {
        float u1 = this.u1 / (float)this.textureWidth;
        float u2 = this.u2 / (float)this.textureWidth;
        float v1 = this.v1 / (float)this.textureHeight;
        float v2 = this.v2 / (float)this.textureHeight;
        for (Vector4f vertex : this.vertices) {
            this.transform.transform(vertex);
        }
        this.writeVertexUI(builder, matrix, this.vertices[2], u2, v2, particle);
        this.writeVertexUI(builder, matrix, this.vertices[1], u2, v1, particle);
        this.writeVertexUI(builder, matrix, this.vertices[0], u1, v1, particle);
        this.writeVertexUI(builder, matrix, this.vertices[0], u1, v1, particle);
        this.writeVertexUI(builder, matrix, this.vertices[3], u1, v2, particle);
        this.writeVertexUI(builder, matrix, this.vertices[2], u2, v2, particle);
    }

    private void writeVertexUI(class_287 builder, Matrix4f matrix, Vector4f vertex, float u, float v, Particle particle) {
        builder.method_22918(matrix, vertex.x, vertex.y, 0.0f).method_22913(u, v).method_22915(particle.r, particle.g, particle.b, particle.a);
    }

    public void calculateUVs(Particle particle, ParticleEmitter emitter, float transition) {
        this.w = (float)this.sizeW.get() * 2.25f;
        this.h = (float)this.sizeH.get() * 2.25f;
        float u = (float)this.uvX.get();
        float v = (float)this.uvY.get();
        float w = (float)this.uvW.get();
        float h = (float)this.uvH.get();
        if (this.flipbook) {
            int index = (int)(particle.getAge(transition) * (double)this.fps);
            int max = (int)this.maxFrame.get();
            if (this.stretchFPS) {
                float lifetime = particle.lifetime <= 0 ? 0.0f : ((float)particle.age + transition) / (float)particle.lifetime;
                index = MathUtils.clamp((int)(lifetime * (float)max), 0, max - 1);
            }
            if (this.loop && max != 0) {
                index %= max;
            }
            if (index > max) {
                index = max;
            }
            u += this.stepX * (float)index;
            v += this.stepY * (float)index;
        }
        this.u1 = u;
        this.v1 = v;
        this.u2 = u + w;
        this.v2 = v + h;
        if (emitter == null || emitter.lit || emitter.world == null) {
            this.light = class_765.method_23687((int)15, (int)15);
        } else {
            int lightLevel;
            Vector3d pos = particle.getGlobalPosition(emitter);
            class_2338 blockPos = new class_2338((int)pos.x, (int)pos.y, (int)pos.z);
            this.light = lightLevel = class_761.method_23794((class_1920)emitter.world, (class_2338)blockPos);
        }
    }

    @Override
    public void postRender(ParticleEmitter emitter, float transition) {
    }
}

