/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.particles.components.appearance.colors;

import java.util.ArrayList;
import java.util.List;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.ListType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.math.Constant;
import mchorse.bbs_mod.math.molang.MolangParser;
import mchorse.bbs_mod.math.molang.expressions.MolangExpression;
import mchorse.bbs_mod.math.molang.expressions.MolangValue;
import mchorse.bbs_mod.particles.ParticleParser;
import mchorse.bbs_mod.particles.components.appearance.colors.Solid;
import mchorse.bbs_mod.particles.components.appearance.colors.Tint;
import mchorse.bbs_mod.particles.emitter.Particle;
import mchorse.bbs_mod.utils.MathUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class Gradient
extends Tint {
    public List<ColorStop> stops;
    public MolangExpression interpolant;
    public boolean equal;
    public float range;

    public Gradient(List<ColorStop> stops, MolangExpression interpolant, boolean equal) {
        this.stops = stops;
        this.interpolant = interpolant;
        this.equal = equal;
        this.range = stops.get((int)(stops.size() - 1)).stop;
    }

    public Gradient() {
        this.stops = new ArrayList<ColorStop>();
        this.stops.add(new ColorStop(0.0f, new Solid(new MolangValue(null, new Constant(1.0)), new MolangValue(null, new Constant(1.0)), new MolangValue(null, new Constant(1.0)), new MolangValue(null, new Constant(1.0)))));
        this.stops.add(new ColorStop(1.0f, new Solid(new MolangValue(null, new Constant(0.0)), new MolangValue(null, new Constant(0.0)), new MolangValue(null, new Constant(0.0)), new MolangValue(null, new Constant(1.0)))));
        this.interpolant = MolangParser.ZERO;
        this.equal = false;
        this.range = this.stops.get((int)(this.stops.size() - 1)).stop;
    }

    public void sort() {
        this.stops.sort((a, b) -> Float.compare(a.stop, b.stop));
    }

    @Override
    public void compute(Particle particle) {
        int length = this.stops.size();
        if (length == 0) {
            particle.a = 1.0f;
            particle.b = 1.0f;
            particle.g = 1.0f;
            particle.r = 1.0f;
            return;
        }
        if (length == 1) {
            this.stops.get((int)0).color.compute(particle);
            return;
        }
        double factor = this.interpolant.get();
        factor = MathUtils.clamp(factor, 0.0, 1.0);
        ColorStop prev = this.stops.get(0);
        if (factor < (double)prev.stop) {
            prev.color.compute(particle);
            return;
        }
        for (int i = 1; i < length; ++i) {
            ColorStop stop = this.stops.get(i);
            if ((double)stop.stop > factor) {
                prev.color.compute(particle);
                stop.color.lerp(particle, (float)(factor - (double)prev.stop) / (stop.stop - prev.stop));
                return;
            }
            prev = stop;
        }
        prev.color.compute(particle);
    }

    @Override
    public BaseType toData() {
        BaseType color;
        MapType data = new MapType();
        if (this.equal) {
            ListType gradient = new ListType();
            for (ColorStop stop : this.stops) {
                gradient.add(stop.color.toHexData());
            }
            color = gradient;
        } else {
            MapType gradient = new MapType();
            for (ColorStop stop : this.stops) {
                gradient.put(String.valueOf(stop.stop), stop.color.toHexData());
            }
            color = gradient;
        }
        if (!ParticleParser.isEmpty(color)) {
            data.put("gradient", color);
        }
        if (!MolangExpression.isZero(this.interpolant)) {
            data.put("interpolant", this.interpolant.toData());
        }
        return data;
    }

    @Environment(value=EnvType.CLIENT)
    public static class ColorStop {
        public float stop;
        public Solid color;

        public ColorStop(float stop, Solid color) {
            this.stop = stop;
            this.color = color;
        }
    }
}

