/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.settings.ui;

import java.util.List;
import java.util.function.Consumer;
import mchorse.bbs_mod.l10n.L10n;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.settings.values.core.ValueString;
import mchorse.bbs_mod.settings.values.numeric.ValueBoolean;
import mchorse.bbs_mod.settings.values.numeric.ValueDouble;
import mchorse.bbs_mod.settings.values.numeric.ValueFloat;
import mchorse.bbs_mod.settings.values.numeric.ValueInt;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIToggle;
import mchorse.bbs_mod.ui.framework.elements.input.UIColor;
import mchorse.bbs_mod.ui.framework.elements.input.UITrackpad;
import mchorse.bbs_mod.ui.framework.elements.input.text.UITextbox;
import mchorse.bbs_mod.ui.framework.elements.utils.UILabel;
import mchorse.bbs_mod.ui.utils.UI;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIValueFactory {
    public static String getTitleKey(BaseValue value) {
        return value.getId() + ".config.title";
    }

    public static String getCategoryTitleKey(BaseValue value) {
        return UIValueFactory.getValueLabelKey(value) + ".title";
    }

    public static String getCategoryTooltipKey(BaseValue value) {
        return UIValueFactory.getValueLabelKey(value) + ".tooltip";
    }

    public static String getValueLabelKey(BaseValue value) {
        List<String> segments = value.getPathSegments();
        String prefix = segments.remove(0);
        return prefix + ".config." + String.join((CharSequence)".", segments);
    }

    public static String getValueCommentKey(BaseValue value) {
        List<String> segments = value.getPathSegments();
        String prefix = segments.remove(0);
        return prefix + ".config." + String.join((CharSequence)".", segments) + "-comment";
    }

    public static UIToggle booleanUI(ValueBoolean value, Consumer<UIToggle> callback) {
        UIToggle booleanToogle = new UIToggle(L10n.lang(UIValueFactory.getValueLabelKey(value)), (Boolean)value.get(), callback == null ? toggle -> value.set(toggle.getValue()) : toggle -> {
            value.set(toggle.getValue());
            callback.accept((UIToggle)toggle);
        });
        booleanToogle.tooltip(L10n.lang(UIValueFactory.getValueCommentKey(value)));
        return booleanToogle;
    }

    public static UITrackpad intUI(ValueInt value, Consumer<Double> callback) {
        UITrackpad trackpad = new UITrackpad(callback == null ? v -> value.set(v.intValue()) : v -> {
            value.set(v.intValue());
            callback.accept((Double)v);
        });
        trackpad.limit(((Integer)value.getMin()).intValue(), ((Integer)value.getMax()).intValue(), true).delayedInput();
        trackpad.setValue(((Integer)value.get()).intValue());
        trackpad.tooltip(L10n.lang(UIValueFactory.getValueCommentKey(value)));
        return trackpad;
    }

    public static UIColor colorUI(ValueInt value, Consumer<Integer> callback) {
        UIColor color = new UIColor(callback == null ? value::set : integer -> {
            value.set(integer);
            callback.accept((Integer)integer);
        });
        color.tooltip(L10n.lang(UIValueFactory.getValueCommentKey(value)));
        if (value.getSubtype() == ValueInt.Subtype.COLOR_ALPHA) {
            color.withAlpha();
        }
        color.setColor((Integer)value.get());
        return color;
    }

    public static UITrackpad floatUI(ValueFloat value, Consumer<Double> callback) {
        UITrackpad trackpad = new UITrackpad(callback == null ? v -> value.set(Float.valueOf(v.floatValue())) : v -> {
            value.set(Float.valueOf(v.floatValue()));
            callback.accept((Double)v);
        });
        trackpad.limit(((Float)value.getMin()).floatValue(), ((Float)value.getMax()).floatValue()).delayedInput();
        trackpad.setValue(((Float)value.get()).floatValue());
        trackpad.tooltip(L10n.lang(UIValueFactory.getValueCommentKey(value)));
        return trackpad;
    }

    public static UITrackpad doubleUI(ValueDouble value, Consumer<Double> callback) {
        UITrackpad trackpad = new UITrackpad(callback == null ? value::set : v -> {
            value.set(v);
            callback.accept((Double)v);
        });
        trackpad.limit((Double)value.getMin(), (Double)value.getMax()).delayedInput();
        trackpad.setValue(((Double)value.get()).floatValue());
        trackpad.tooltip(L10n.lang(UIValueFactory.getValueCommentKey(value)));
        return trackpad;
    }

    public static UITextbox stringUI(ValueString value, Consumer<String> callback) {
        UITextbox textbox = new UITextbox(10000, callback == null ? value::set : string -> {
            value.set(string);
            callback.accept((String)string);
        });
        textbox.setText((String)value.get());
        textbox.tooltip(L10n.lang(UIValueFactory.getValueLabelKey(value)));
        return textbox;
    }

    public static UIElement column(UIElement control, BaseValue value) {
        UIElement element = new UIElement();
        control.removeTooltip();
        element.row(0).preferred(0).height(20);
        element.add(UIValueFactory.label(value), control);
        return UIValueFactory.commetTooltip(element, value);
    }

    public static UILabel label(BaseValue value) {
        return UI.label(L10n.lang(UIValueFactory.getValueLabelKey(value)), 0).labelAnchor(0.0f, 0.5f);
    }

    public static UIElement commetTooltip(UIElement element, BaseValue value) {
        element.tooltip(L10n.lang(UIValueFactory.getValueCommentKey(value)));
        return element;
    }
}

