/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.dashboard.panels;

import java.util.ArrayList;
import java.util.List;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.ui.dashboard.panels.IFlightSupported;
import mchorse.bbs_mod.ui.dashboard.panels.UIDashboardPanel;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.UIScrollView;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIIcon;
import mchorse.bbs_mod.ui.framework.elements.events.UIEvent;
import mchorse.bbs_mod.ui.framework.elements.utils.Batcher2D;
import mchorse.bbs_mod.ui.framework.elements.utils.UIRenderable;
import mchorse.bbs_mod.ui.utils.Area;
import mchorse.bbs_mod.ui.utils.ScrollDirection;
import mchorse.bbs_mod.ui.utils.icons.Icon;
import mchorse.bbs_mod.ui.utils.resizers.IResizer;
import mchorse.bbs_mod.utils.Direction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIDashboardPanels
extends UIElement {
    public List<UIDashboardPanel> panels = new ArrayList<UIDashboardPanel>();
    public UIDashboardPanel panel;
    public UIElement taskBar = new UIElement();
    public UIElement pinned;
    public UIScrollView panelButtons;

    public static void renderHighlight(Batcher2D batcher, Area area) {
        int color = (Integer)BBSSettings.primaryColor.get();
        batcher.box(area.x, area.ey() - 2, area.ex(), area.ey(), 0xFF000000 | color);
        batcher.gradientVBox(area.x, area.y, area.ex(), area.ey() - 2, color, 0xBB000000 | color);
    }

    public static void renderHighlightHorizontal(Batcher2D batcher, Area area) {
        int color = (Integer)BBSSettings.primaryColor.get();
        batcher.box(area.ex() - 2, area.y, area.ex(), area.ey(), 0xFF000000 | color);
        batcher.gradientHBox(area.x, area.y, area.ex() - 2, area.ey(), color, 0xBB000000 | color);
    }

    public UIDashboardPanels() {
        this.taskBar.relative(this).y(1.0f, -20).w(1.0f).h(20);
        this.pinned = new UIElement();
        this.pinned.relative(this.taskBar).h(20).row(0).resize();
        this.panelButtons = new UIScrollView(ScrollDirection.HORIZONTAL);
        this.panelButtons.relative(this.pinned).x(1.0f, 5).h(20).wTo((IResizer)this.taskBar.area, 1.0f).column(0).scroll();
        this.panelButtons.scroll.cancelScrolling().noScrollbar();
        this.panelButtons.scroll.scrollSpeed = 5;
        this.panelButtons.preRender(context -> {
            int c = this.panels.size();
            for (int i = 0; i < c; ++i) {
                if (this.panel != this.panels.get(i)) continue;
                UIDashboardPanels.renderHighlight(context.batcher, ((UIIcon)this.panelButtons.getChildren().get((int)i)).area);
            }
        });
        this.taskBar.add(new UIRenderable(this::renderBackground), this.pinned, this.panelButtons);
        this.add((IUIElement)this.taskBar);
    }

    public <T> T getPanel(Class<T> clazz) {
        for (UIDashboardPanel panel : this.panels) {
            if (panel.getClass() != clazz) continue;
            return (T)panel;
        }
        return null;
    }

    public boolean isFlightSupported() {
        return this.panel instanceof IFlightSupported;
    }

    public void open() {
        for (UIDashboardPanel panel : this.panels) {
            panel.open();
        }
    }

    public void close() {
        for (UIDashboardPanel panel : this.panels) {
            panel.close();
        }
    }

    public void setPanel(UIDashboardPanel panel) {
        UIDashboardPanel lastPanel = this.panel;
        if (this.panel != null) {
            this.panel.disappear();
            this.panel.removeFromParent();
        }
        this.panel = panel;
        this.getEvents().emit(new PanelEvent(this, lastPanel, panel));
        if (this.panel != null) {
            this.setPanelPlacement(panel);
            this.prepend(this.panel);
            this.panel.appear();
            this.panel.resize();
        }
    }

    private void setPanelPlacement(UIDashboardPanel panel) {
        panel.resetFlex().relative(this).w(1.0f).h(1.0f, -20);
    }

    public UIIcon registerPanel(UIDashboardPanel panel, IKey tooltip, Icon icon) {
        UIIcon button = new UIIcon(icon, b -> this.setPanel(panel));
        button.tooltip(tooltip, Direction.TOP);
        this.panels.add(panel);
        this.panelButtons.add((IUIElement)button);
        return button;
    }

    protected void renderBackground(UIContext context) {
        Area area = this.taskBar.area;
        Area a = this.pinned.area;
        context.batcher.box(area.x, area.y, area.ex(), area.ey(), -15461353);
        context.batcher.box(a.ex() + 2, a.y + 3, a.ex() + 3, a.ey() - 3, 0x44FFFFFF);
    }

    @Environment(value=EnvType.CLIENT)
    public static class PanelEvent
    extends UIEvent<UIDashboardPanels> {
        public final UIDashboardPanel lastPanel;
        public final UIDashboardPanel panel;

        public PanelEvent(UIDashboardPanels element, UIDashboardPanel lastPanel, UIDashboardPanel panel) {
            super(element);
            this.lastPanel = lastPanel;
            this.panel = panel;
        }
    }
}

