/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.clips.modules;

import java.util.function.Consumer;
import mchorse.bbs_mod.camera.clips.overwrite.PathClip;
import mchorse.bbs_mod.camera.data.Position;
import mchorse.bbs_mod.graphics.window.Window;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.film.IUIClipsDelegate;
import mchorse.bbs_mod.ui.film.clips.modules.UIAbstractModule;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.utils.Scroll;
import mchorse.bbs_mod.ui.utils.ScrollDirection;
import mchorse.bbs_mod.ui.utils.context.ContextMenuManager;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.MathUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIPointsModule
extends UIAbstractModule {
    public PathClip path;
    public Consumer<Integer> picker;
    public Scroll scroll;
    public int index;

    public UIPointsModule(IUIClipsDelegate editor, Consumer<Integer> picker) {
        super(editor);
        this.scroll = new Scroll(this.area, 20);
        this.index = 0;
        this.picker = picker;
        this.scroll.direction = ScrollDirection.HORIZONTAL;
        this.scroll.cancelScrolling();
        this.context((ContextMenuManager menu) -> {
            menu.action(Icons.ADD, UIKeys.CAMERA_PANELS_POINTS_CONTEXT_ADD, this::addPoint);
            menu.action(Icons.REMOVE, UIKeys.CAMERA_PANELS_POINTS_CONTEXT_REMOVE, this::removePoint);
            menu.action(Icons.SHIFT_BACKWARD, UIKeys.CAMERA_PANELS_POINTS_CONTEXT_MOVE_BACK, this::moveBack);
            menu.action(Icons.SHIFT_FORWARD, UIKeys.CAMERA_PANELS_POINTS_CONTEXT_MOVE_FORWARD, this::moveForward);
        });
    }

    public void setIndex(int index) {
        this.index = index;
        this.scroll.scrollIntoView(index * this.scroll.scrollItemSize);
    }

    public void moveBack() {
        if (this.index == 0) {
            return;
        }
        this.path.points.move(this.index, this.index - 1);
        --this.index;
    }

    public void moveForward() {
        if (this.index >= this.path.size() - 1) {
            return;
        }
        this.path.points.move(this.index, this.index + 1);
        --this.index;
    }

    public void addPoint() {
        this.path.points.add(this.index + 1, new Position(this.editor.getCamera()));
        this.index = MathUtils.clamp(this.index + 1, 0, this.path.points.size() - 1);
        this.scroll.setSize(this.path.size());
        this.scroll.scrollTo(this.index * this.scroll.scrollItemSize);
        if (this.picker != null) {
            this.picker.accept(this.index);
        }
    }

    public void removePoint() {
        if (this.path.points.size() == 1 && this.index >= 0) {
            return;
        }
        this.path.points.remove(this.index);
        this.index = Math.max(this.index - 1, 0);
        this.scroll.setSize(this.path.size());
        this.scroll.scrollTo(this.index * this.scroll.scrollItemSize);
        if (this.picker != null) {
            this.picker.accept(this.index);
        }
    }

    public void fill(PathClip path) {
        this.path = path;
        this.index = 0;
        this.scroll.setSize(path.size());
        this.scroll.clamp();
    }

    @Override
    public boolean subMouseClicked(UIContext context) {
        int mouseX = context.mouseX;
        int mouseY = context.mouseY;
        if (this.area.isInside(context)) {
            if (context.mouseButton == 2 || context.mouseButton == 0 && Window.isCtrlPressed()) {
                this.scroll.dragging = true;
                return true;
            }
            if (context.mouseButton == 0) {
                int index = this.scroll.getIndex(mouseX, mouseY);
                int size = this.path.size();
                if (index >= 0 && index < size) {
                    this.index = index;
                    if (this.picker != null) {
                        this.picker.accept(index);
                    }
                }
                return true;
            }
        }
        return super.subMouseClicked(context);
    }

    @Override
    public boolean subMouseScrolled(UIContext context) {
        return this.scroll.mouseScroll(context);
    }

    @Override
    public boolean subMouseReleased(UIContext context) {
        this.scroll.mouseReleased(context);
        return super.subMouseReleased(context);
    }

    @Override
    public void render(UIContext context) {
        if (this.path == null) {
            return;
        }
        this.scroll.drag(context);
        int x = this.area.x;
        int y = this.area.y;
        int c = this.path.size();
        context.batcher.box(x, y, x + this.area.w, y + this.area.h, -2013265920);
        context.batcher.clip(this.area, context);
        for (int i = 0; i < c; ++i) {
            String label = String.valueOf(i);
            int xx = this.area.x + i * this.scroll.scrollItemSize - (int)this.scroll.getScroll();
            int w = context.batcher.getFont().getWidth(label);
            context.batcher.box(xx, y, xx + 20, y + 20, this.index == i ? -3403408 : -56704);
            context.batcher.box(xx + 19, y, xx + 20, y + 20, 0x22000000);
            context.batcher.textShadow(label, xx + 10 - w / 2, y + 6);
        }
        context.batcher.unclip(context);
        int mw = this.area.w;
        int scroll = this.scroll.getScrollbar();
        if (scroll != 0) {
            int bx = this.area.x + (int)(this.scroll.getScroll() / (double)(this.scroll.scrollSize - this.area.w) * (double)(mw - scroll));
            int by = y + this.area.h + 2;
            context.batcher.box(bx, by, bx + scroll, by + 2, -2013265920);
        }
        if (this.scroll.getScroll() > 0.0 && this.scroll.scrollSize >= this.area.w - 40) {
            context.batcher.gradientHBox(x, y, x + 4, y + this.area.h, -2013265920, 0);
        }
        if (this.scroll.getScroll() < (double)(this.scroll.scrollSize - this.area.w) && this.scroll.scrollSize >= this.area.w) {
            context.batcher.gradientHBox(x + this.area.w - 4, y, x + this.area.w, y + this.area.h, 0, -2013265920);
        }
        super.render(context);
    }
}

