/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.forms.editors.panels;

import java.util.Set;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.cubic.ModelInstance;
import mchorse.bbs_mod.forms.forms.ModelForm;
import mchorse.bbs_mod.forms.renderers.ModelFormRenderer;
import mchorse.bbs_mod.graphics.window.Window;
import mchorse.bbs_mod.obj.shapes.ShapeKeys;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.forms.editors.forms.UIForm;
import mchorse.bbs_mod.ui.forms.editors.panels.UIFormPanel;
import mchorse.bbs_mod.ui.forms.editors.panels.widgets.UIModelPoseEditor;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIButton;
import mchorse.bbs_mod.ui.framework.elements.input.UIColor;
import mchorse.bbs_mod.ui.framework.elements.input.UITexturePicker;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIListOverlayPanel;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlay;
import mchorse.bbs_mod.ui.utils.shapes.UIShapeKeys;
import mchorse.bbs_mod.utils.Direction;
import mchorse.bbs_mod.utils.colors.Color;
import mchorse.bbs_mod.utils.pose.Pose;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIModelFormPanel
extends UIFormPanel<ModelForm> {
    public UIColor color;
    public UIModelPoseEditor poseEditor;
    public UIShapeKeys shapeKeys;
    public UIButton pickModel = new UIButton(UIKeys.FORMS_EDITOR_MODEL_PICK_MODEL, b -> {
        UIListOverlayPanel list = new UIListOverlayPanel(UIKeys.FORMS_EDITOR_MODEL_MODELS, l -> {
            ModelInstance model;
            ((ModelForm)this.form).model.set(l);
            if (Window.isCtrlPressed() && (model = ModelFormRenderer.getModel((ModelForm)this.form)) != null) {
                ((ModelForm)this.form).texture.set(model.texture);
            }
            this.editor.startEdit(this.form);
        });
        list.addValues(BBSModClient.getModels().getAvailableKeys());
        list.list.list.sort();
        list.setValue((String)((ModelForm)this.form).model.get());
        UIOverlay.addOverlay(this.getContext(), list);
    });
    public UIButton pick;

    public UIModelFormPanel(UIForm editor) {
        super(editor);
        this.color = new UIColor(c -> ((ModelForm)this.form).color.set(new Color().set((int)c))).withAlpha();
        this.color.direction(Direction.LEFT);
        this.poseEditor = new UIModelPoseEditor();
        this.poseEditor.setDefaultTextureSupplier(() -> {
            Link base = (Link)((ModelForm)this.form).texture.get();
            if (base != null) {
                return base;
            }
            ModelInstance model = ModelFormRenderer.getModel((ModelForm)this.form);
            return model != null ? model.texture : null;
        });
        this.shapeKeys = new UIShapeKeys();
        this.pick = new UIButton(UIKeys.FORMS_EDITOR_MODEL_PICK_TEXTURE, b -> {
            Link link = (Link)((ModelForm)this.form).texture.get();
            ModelInstance model = ModelFormRenderer.getModel((ModelForm)this.form);
            if (model != null && link == null) {
                link = model.texture;
            }
            UITexturePicker.open(this.getContext(), link, l -> ((ModelForm)this.form).texture.set(l));
        });
        this.options.add(this.pickModel, this.pick, this.color, this.poseEditor);
    }

    private void pickGroup(String group) {
        this.poseEditor.selectBone(group);
    }

    @Override
    public void startEdit(ModelForm form) {
        Set<String> modelShapeKeys;
        super.startEdit(form);
        ModelInstance model = ModelFormRenderer.getModel((ModelForm)this.form);
        this.poseEditor.setValuePose(form.pose);
        this.poseEditor.setPose((Pose)form.pose.get(), model == null ? (String)((ModelForm)this.form).model.get() : model.poseGroup);
        this.poseEditor.fillGroups(model == null ? null : model.model, model == null ? null : model.flippedParts, true);
        this.color.setColor(((Color)form.color.get()).getARGBColor());
        this.shapeKeys.removeFromParent();
        if (model != null && !(modelShapeKeys = model.model.getShapeKeys()).isEmpty()) {
            this.options.add((IUIElement)this.shapeKeys);
            this.shapeKeys.setShapeKeys(model.poseGroup, modelShapeKeys, (ShapeKeys)((ModelForm)this.form).shapeKeys.get());
        }
        this.options.resize();
    }

    @Override
    public void pickBone(String bone) {
        super.pickBone(bone);
        this.pickGroup(bone);
    }
}

